/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadBuilder;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.telemetry.cmc.CdfCollector;
import com.vmware.vsphere.telemetry.cmc.CollectedPayload;
import com.vmware.vsphere.telemetry.cmc.InvalidManifestException;
import com.vmware.vsphere.telemetry.cmc.ManifestUtils;
import com.vmware.vsphere.telemetry.cmc.cdf.CdfMappingParser;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.cdf.Mapping;
import com.vmware.vsphere.telemetry.cmc.cdf.PayloadUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManagedObjectCollector
implements CdfCollector {
    public static final String ELEMENT_NAME = "moCollector";
    private static final Logger log = LoggerFactory.getLogger(ManagedObjectCollector.class);
    private final CdfMappingParser _mappingParser;

    public ManagedObjectCollector(CdfMappingParser mappingParser) {
        this._mappingParser = mappingParser;
    }

    @Override
    public Iterable<CollectedPayload> collect(Document manifest, DataService dataService, VcService vcService, Context context, int pageSize) {
        Validate.notNull((Object)vcService);
        Element configNode = ManifestUtils.findOptionalElement(manifest, ELEMENT_NAME);
        if (configNode == null) {
            return Collections.emptyList();
        }
        ArrayList<CollectedPayload> result = new ArrayList<CollectedPayload>();
        NodeList children = configNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            CollectedPayload collectedPayload;
            Node moQueryNode = children.item(i);
            NamedNodeMap attributes = moQueryNode.getAttributes();
            if (attributes == null) continue;
            String moId = this.getAttributeValue(attributes.getNamedItem("moId"));
            String moType = this.getAttributeValue(attributes.getNamedItem("moType"));
            if (StringUtils.isBlank((String)moId) || StringUtils.isBlank((String)moType) || (collectedPayload = this.toCollectedPayload(moQueryNode, vcService, context, moId, moType)) == null) continue;
            result.add(collectedPayload);
        }
        return result;
    }

    private CollectedPayload toCollectedPayload(Node manifest, VcService vcService, Context context, String moId, String moType) {
        CollectedPayload.Builder builder = new CollectedPayload.Builder();
        try {
            Payload payload = this.toPayload(manifest, vcService, context, moId, moType);
            if (payload == null) {
                return null;
            }
            builder.setPayload(payload);
        }
        catch (RuntimeException e) {
            builder.setTransientError(e);
        }
        return builder.build();
    }

    private String getAttributeValue(Node attributeNode) {
        return attributeNode instanceof Attr ? ((Attr)attributeNode).getValue() : null;
    }

    private Payload toPayload(Node mappingHolder, VcService vcService, Context context, String moId, String moType) {
        ManagedObjectReference moRef = new ManagedObjectReference(moType, moId);
        long startTimeNanos = System.nanoTime();
        ManagedObject mo = null;
        try {
            assert (vcService != null);
            mo = vcService.getManagedObject(moRef);
        }
        catch (NullPointerException e) {
            log.warn("NPE in getManagedObject, usually caused by unknown type of MoRef {}", (Object)moRef, (Object)e);
        }
        Payload result = null;
        if (mo != null) {
            Mapping mapping = null;
            try {
                mapping = this._mappingParser.parse(mappingHolder);
            }
            catch (InvalidManifestException e) {
                log.warn("Invalid manifest for {}", (Object)moRef, (Object)e);
            }
            catch (IllegalArgumentException e) {
                log.warn("Missing manifest for {}", (Object)moRef, (Object)e);
            }
            if (mapping != null) {
                Resource res = (Resource)mapping.map(this.wrap(mo), context);
                long elapsedNano = System.nanoTime() - startTimeNanos;
                Resource perfData = PayloadUtil.buildPerfDataResource(elapsedNano, moId, null, context);
                result = new PayloadBuilder().add(new Resource[]{res, perfData}).build();
            } else {
                log.warn("No mapping for {}", (Object)moRef);
            }
        } else {
            log.warn("getManagedObject returned null for MoRef {}.", (Object)moRef);
        }
        return result;
    }

    private ManagedObject wrap(final ManagedObject mo) {
        final HashMap argsToOutput = new HashMap();
        Class<?> cls = mo.getClass();
        return (ManagedObject)Proxy.newProxyInstance(cls.getClassLoader(), cls.getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Invokation methodAndArgs = new Invokation(method, args);
                Object result = argsToOutput.get(methodAndArgs);
                if (result == null && !argsToOutput.containsKey(methodAndArgs)) {
                    try {
                        result = method.invoke((Object)mo, args);
                        argsToOutput.put(methodAndArgs, result);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
                return result;
            }
        });
    }

    private static class Invokation {
        final Method method;
        final Object[] args;

        Invokation(Method method, Object[] args) {
            this.method = method;
            this.args = args;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }
    }
}

