/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection;

import com.vmware.ph.exceptions.Bug;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.telemetry.cmc.CollectedFile;
import com.vmware.vsphere.telemetry.cmc.FileCollector;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public final class MiscDataFileCollector
implements FileCollector {
    private static final String ENV_GLOBAL_CFG_DIR = "VMWARE_CFG_DIR";
    private static final Logger logger = LoggerFactory.getLogger(MiscDataFileCollector.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Iterable<CollectedFile> collect(Document manifest, DataService dataService, VcService vcService, Context context) {
        CollectedFile.Builder collectedFile = new CollectedFile.Builder().onDisposeDelete();
        FileOutputStream dataStream = null;
        File dataFile = null;
        try {
            dataFile = Files.createTempFile("cmc", "misc", new FileAttribute[0]).toFile();
            logger.info("Collecting misc data into temporary file: {}", (Object)dataFile.getAbsolutePath());
            dataStream = new FileOutputStream(dataFile);
            try (ArchiveOutputStream archiveStream = new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)dataStream);){
                this.addJavaSystemProperties(archiveStream);
                this.addVpxdCfg(archiveStream);
            }
            collectedFile.setFile(dataFile);
            if (dataStream == null) return Collections.singletonList(collectedFile.build());
        }
        catch (IOException e) {
            collectedFile.setTransientError(e);
            MiscDataFileCollector.deleteQuietly(dataFile);
            this.logCollectionError(e);
            return Collections.singletonList(collectedFile.build());
        }
        catch (ArchiveException e2) {
            collectedFile.setTransientError((Exception)((Object)e2));
            MiscDataFileCollector.deleteQuietly(dataFile);
            this.logCollectionError((Exception)((Object)e2));
            return Collections.singletonList(collectedFile.build());
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (dataStream != null) {
                IOUtils.closeQuietly(dataStream);
            }
        }
        IOUtils.closeQuietly((OutputStream)dataStream);
        return Collections.singletonList(collectedFile.build());
    }

    private void logCollectionError(Exception e) {
        logger.warn("Misc data collection failued to {}: {}", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
    }

    private void addJavaSystemProperties(ArchiveOutputStream archiveStream) throws IOException {
        byte[] propBytes;
        try {
            ByteArrayOutputStream propStream = new ByteArrayOutputStream();
            System.getProperties().store(propStream, null);
            propBytes = propStream.toByteArray();
            propStream.close();
        }
        catch (IOException e) {
            throw new Bug("I/O error while writing to in-memory stream.", (Throwable)e);
        }
        ZipArchiveEntry entry = new ZipArchiveEntry("javaSystemProperties.txt");
        entry.setSize((long)propBytes.length);
        archiveStream.putArchiveEntry((ArchiveEntry)entry);
        archiveStream.write(propBytes);
        archiveStream.closeArchiveEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVpxdCfg(ArchiveOutputStream archiveStream) throws IOException {
        byte[] vpxdCfgBytes;
        String cfgDir = System.getenv(ENV_GLOBAL_CFG_DIR);
        if (StringUtils.isEmpty((String)cfgDir)) {
            logger.warn("Required environment variable `{}' not set. Unable to detect vpxd config dir. Skipping vpxd.cfg collection.");
            return;
        }
        File vpxdCfg = new File(cfgDir, "vmware-vpx/vpxd.cfg");
        FileInputStream vpxdCfgStream = null;
        try {
            vpxdCfgStream = new FileInputStream(vpxdCfg);
            vpxdCfgBytes = IOUtils.toByteArray((InputStream)vpxdCfgStream);
        }
        catch (IOException e) {
            try {
                logger.warn("Skipping vpxd.cfg collection due to I/O error reading the file: {}", (Object)e.getMessage(), (Object)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(vpxdCfgStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)vpxdCfgStream);
            return;
        }
        IOUtils.closeQuietly((InputStream)vpxdCfgStream);
        ZipArchiveEntry entry = new ZipArchiveEntry(vpxdCfg.getName());
        entry.setSize((long)vpxdCfgBytes.length);
        archiveStream.putArchiveEntry((ArchiveEntry)entry);
        archiveStream.write(vpxdCfgBytes);
        archiveStream.closeArchiveEntry();
    }

    private static void deleteQuietly(File file) {
        if (file != null) {
            file.delete();
        }
    }
}

