/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadBuilder;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventFilterSpec;
import com.vmware.vim.binding.vim.event.EventHistoryCollector;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vim.fault.InvalidState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.telemetry.cmc.CollectedPayload;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.cdf.Mapping;
import com.vmware.vsphere.telemetry.cmc.cdf.PayloadUtil;
import com.vmware.vsphere.telemetry.cmc.event.request.QueryManifest;
import com.vmware.vsphere.telemetry.cmc.event.request.RequestManifest;
import com.vmware.vsphere.telemetry.cmc.event.response.Response;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PagingEventQueryBatchIterator
implements Iterator<CollectedPayload>,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(PagingEventQueryBatchIterator.class);
    private final VcService vcService;
    private final Mapping<Response, Payload> responseMapping;
    private final Context mappingContext;
    private final int pageSize;
    private int currentPageIdx;
    private Response nextResponse;
    private Iterator<Event[]> pagePerEventSpecIter;
    private QueryManifest currQuery;
    private final Iterator<QueryManifest> queriesIter;
    private EventHistoryCollector eventHistoryCollector;
    private boolean hasError;
    private Exception error;

    public PagingEventQueryBatchIterator(VcService vcService, Mapping<Response, Payload> responseMapping, Context mappingContext, RequestManifest request, int pageSize) {
        this.vcService = vcService;
        this.responseMapping = responseMapping;
        this.mappingContext = mappingContext;
        this.pageSize = pageSize;
        this.queriesIter = request.getQueries().iterator();
        this.currentPageIdx = 0;
        this.nextResponse = null;
        this.pagePerEventSpecIter = null;
        this.currQuery = null;
        this.hasError = false;
        this.error = null;
    }

    @Override
    public boolean hasNext() {
        return !this.hasError && this.hasMorePages();
    }

    @Override
    public CollectedPayload next() {
        long startTimeNanos = System.nanoTime();
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next item is available in the iterator.");
        }
        ++this.currentPageIdx;
        Response currResponse = this.nextResponse;
        this.nextResponse = null;
        this.logResponseForDebugging(currResponse);
        return this.responseToPayload(currResponse, startTimeNanos);
    }

    @Override
    public void close() {
        this.removeEventHistoryCollector();
    }

    private CollectedPayload responseToPayload(Response response, long startTimeNanos) {
        Payload eventPayload = this.responseMapping.map(response, this.mappingContext);
        eventPayload = this.addTelemetry(eventPayload, startTimeNanos);
        CollectedPayload.Builder collectedData = new CollectedPayload.Builder();
        collectedData.setPayload(eventPayload);
        if (this.hasError) {
            collectedData.setError(this.error, false);
        }
        return collectedData.build();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Payload addTelemetry(Payload eventPayload, long startTimeNanos) {
        PayloadBuilder mergedPayloadBuilder = new PayloadBuilder();
        PayloadUtil.merge(mergedPayloadBuilder, eventPayload);
        long elapsedNano = System.nanoTime() - startTimeNanos;
        mergedPayloadBuilder.add(new Resource[]{PayloadUtil.buildPerfDataResource(elapsedNano, this.currQuery.getName(), this.currentPageIdx, this.mappingContext)});
        return mergedPayloadBuilder.build();
    }

    private void logResponseForDebugging(Response r) {
        if (logger.isTraceEnabled()) {
            logger.trace("Usage event collection result for query #{} (page {}):\n{}", new Object[]{r.queryName, this.currentPageIdx, Arrays.toString(r.events)});
        }
    }

    private boolean hasMorePages() {
        this.ensureNextResponse();
        return this.nextResponse != null;
    }

    private void ensureNextResponse() {
        while (this.nextResponse == null) {
            logger.debug("Checking for more events...");
            if (this.pagePerEventSpecIter == null || !this.pagePerEventSpecIter.hasNext()) {
                if (this.queriesIter.hasNext()) {
                    this.currQuery = this.queriesIter.next();
                    logger.debug("Getting events for the {} query in the event collector.", (Object)this.currQuery.getName());
                    this.pagePerEventSpecIter = this.getEvents(this.currQuery.getEventFilterSpecManifest().getEventFilterSpec(), this.currQuery.getMaxResultCount());
                } else {
                    logger.debug("No more queries left for all the queries in the event collector.");
                    return;
                }
            }
            try {
                if (!this.pagePerEventSpecIter.hasNext()) continue;
                this.nextResponse = new Response();
                this.nextResponse.queryName = this.currQuery.getName();
                this.nextResponse.events = this.pagePerEventSpecIter.next();
                logger.debug("Returned #{} events for {} query", (Object)this.nextResponse.events.length, (Object)this.nextResponse.queryName);
            }
            catch (RuntimeException e) {
                logger.error("Failed while retrieving next events from the event collector", (Throwable)e);
                this.hasError = true;
                this.error = e;
                return;
            }
        }
    }

    private Iterator<Event[]> getEvents(final EventFilterSpec eventFilterSpec, final int maxResultCount) {
        return new Iterator<Event[]>(){
            EventHistoryCollector eventHistoryCollector;
            private Event[] nextEvents;
            int eventsReturnedCounter;
            {
                this.eventHistoryCollector = PagingEventQueryBatchIterator.this.createEventHistoryCollector(eventFilterSpec);
                this.nextEvents = null;
                this.eventsReturnedCounter = 0;
            }

            @Override
            public boolean hasNext() {
                this.loadEvents();
                return this.nextEvents != null;
            }

            @Override
            public Event[] next() {
                this.loadEvents();
                if (this.nextEvents != null) {
                    this.eventsReturnedCounter += this.nextEvents.length;
                }
                Event[] currEvents = this.nextEvents;
                this.nextEvents = null;
                return currEvents;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void loadEvents() {
                if (this.eventHistoryCollector == null) {
                    logger.warn("eventHistoryCollector is null.");
                    return;
                }
                if (this.nextEvents == null) {
                    int nextPageSize = Math.min(PagingEventQueryBatchIterator.this.pageSize, maxResultCount - this.eventsReturnedCounter);
                    logger.trace("Reading next #{} events from the event history collector", (Object)nextPageSize);
                    if (nextPageSize == 0) {
                        logger.trace("Reached maximum events #{} per current query. Will not get next events.", (Object)this.eventsReturnedCounter);
                        return;
                    }
                    this.nextEvents = this.eventHistoryCollector.readNext(nextPageSize);
                }
            }
        };
    }

    private EventHistoryCollector createEventHistoryCollector(EventFilterSpec eventFilterSpec) {
        this.removeEventHistoryCollector();
        ManagedObjectReference eventManagerMoRef = this.vcService.getServiceInstanceContent().getEventManager();
        EventManager em = (EventManager)this.vcService.getManagedObject(eventManagerMoRef);
        if (em == null) {
            logger.warn("getManagedObject returned null for MoRef {}.", (Object)eventManagerMoRef);
            return null;
        }
        ManagedObjectReference morEhc = null;
        try {
            morEhc = em.createCollector(eventFilterSpec);
        }
        catch (InvalidState e) {
            logger.error("Failed while creating event collector", (Throwable)e);
            this.hasError = true;
            this.error = e;
            return null;
        }
        this.eventHistoryCollector = (EventHistoryCollector)this.vcService.getManagedObject(morEhc);
        return this.eventHistoryCollector;
    }

    private void removeEventHistoryCollector() {
        if (this.eventHistoryCollector != null) {
            this.eventHistoryCollector.remove();
            this.eventHistoryCollector = null;
        }
    }
}

