/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadBuilder;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.ph.exceptions.Bug;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vsphere.telemetry.cmc.CollectedPayload;
import com.vmware.vsphere.telemetry.cmc.Utils;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.cdf.Mapping;
import com.vmware.vsphere.telemetry.cmc.cdf.PayloadUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PagingQueryBatchIterator
implements Iterator<CollectedPayload> {
    private static final Logger logger = LoggerFactory.getLogger(PagingQueryBatchIterator.class);
    private final DataService _dataService;
    private final Mapping<Response, Payload> _responseMapping;
    private final Context _mappingContext;
    private final QuerySpec[] _request;
    private final int _pageSize;
    private boolean _hasError;
    private int _currentQueryIdx;
    private QueryPager _currentQueryPager;

    public PagingQueryBatchIterator(DataService dataService, Mapping<Response, Payload> responseMapping, Context mappingContext, QuerySpec[] request, int pageSize) {
        this._dataService = dataService;
        this._responseMapping = responseMapping;
        this._mappingContext = mappingContext;
        this._request = request;
        this._hasError = false;
        this._currentQueryIdx = 0;
        this._pageSize = pageSize;
        this._currentQueryPager = new QueryPager(request[0], this._pageSize);
    }

    @Override
    public boolean hasNext() {
        boolean hasMorePages = this._currentQueryIdx < this._request.length - 1 || this._currentQueryPager.hasMorePages();
        return !this._hasError && hasMorePages;
    }

    @Override
    public CollectedPayload next() {
        long startTimeNanos = System.nanoTime();
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next item is available in the iterator.");
        }
        if (!this._currentQueryPager.hasMorePages()) {
            ++this._currentQueryIdx;
            QuerySpec nextQuerySpec = this._request[this._currentQueryIdx];
            this._currentQueryPager = new QueryPager(nextQuerySpec, this._pageSize);
        }
        Response nextPage = this._currentQueryPager.getNextPage(this._dataService);
        this.logResponseForDebugging(this._currentQueryPager, nextPage);
        CollectedPayload payload = this.responseToPayload(nextPage, startTimeNanos);
        this._hasError = payload.hasFatalError();
        return payload;
    }

    private String getCurrentQueryName() {
        QuerySpec query = this._currentQueryPager.baseQuery;
        String name = query.name;
        Constraint constraint = query.resourceSpec.constraint;
        return name != null || constraint == null ? name : String.valueOf(constraint.targetType);
    }

    private CollectedPayload responseToPayload(Response response, long startTimeNanos) {
        Payload payload = this._responseMapping.map(response, this._mappingContext);
        PayloadBuilder mergedPayloadBuilder = new PayloadBuilder();
        PayloadUtil.merge(mergedPayloadBuilder, payload);
        long elapsedNano = System.nanoTime() - startTimeNanos;
        mergedPayloadBuilder.add(new Resource[]{PayloadUtil.buildPerfDataResource(elapsedNano, this.getCurrentQueryName(), this._currentQueryPager.currentPageIdx, this._mappingContext)});
        CollectedPayload.Builder collectedData = new CollectedPayload.Builder(mergedPayloadBuilder.build());
        if (ArrayUtils.getLength((Object)response.resultSet) > 0) {
            boolean errorIsFatal;
            Exception error = response.resultSet[0].error;
            ResultSet resultSet = response.resultSet[0];
            boolean bl = errorIsFatal = ArrayUtils.isEmpty((Object[])resultSet.items) && (resultSet.totalMatchedObjectCount == null || resultSet.totalMatchedObjectCount == 0) && error != null;
            if (error != null) {
                collectedData.setError(error, errorIsFatal);
            }
        }
        return collectedData.build();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void logResponseForDebugging(QueryPager pager, Response data) {
        if (logger.isTraceEnabled()) {
            logger.trace("Usage data collection result for query #{} ({}):\n{}", new Object[]{this._currentQueryIdx, pager.getPageInfo(), Utils.renderResultSets(data.resultSet)});
        }
    }

    private static final class QueryPager {
        private final QuerySpec baseQuery;
        private final int pageSize;
        private final int forcedMaxResultCount;
        private boolean firstRunComplete;
        private int totalItemCount;
        private int currentOffset;
        private int currentPageIdx;

        public QueryPager(QuerySpec query, int pageSize) {
            this.baseQuery = query;
            this.forcedMaxResultCount = query.resultSpec != null && query.resultSpec.maxResultCount != null ? query.resultSpec.maxResultCount : Integer.MAX_VALUE;
            this.pageSize = Math.min(pageSize, this.forcedMaxResultCount);
            this.firstRunComplete = false;
            this.totalItemCount = -1;
            this.currentOffset = 0;
            this.currentPageIdx = 0;
        }

        public String getPageInfo() {
            int estTotal = Math.min(this.forcedMaxResultCount, this.totalItemCount);
            int estTotalPages = estTotal > 0 ? (estTotal + this.pageSize - 1) / this.pageSize : this.currentPageIdx;
            return "page " + this.currentPageIdx + " of " + estTotalPages;
        }

        public boolean hasMorePages() {
            return !this.firstRunComplete || this.currentOffset < this.totalItemCount && this.currentOffset < this.forcedMaxResultCount;
        }

        public Response getNextPage(DataService dataService) {
            RequestSpec nextPageQuery = this.getRequestForNextPage();
            Response nextPageResponse = dataService.getData(nextPageQuery);
            this.currentOffset += this.pageSize;
            ++this.currentPageIdx;
            this.firstRunComplete = true;
            if (ArrayUtils.getLength((Object)nextPageResponse.resultSet) == 0 || nextPageResponse.resultSet[0] == null) {
                logger.error("DataService returned null ResultSet for a query:\n{}", (Object)com.vmware.vise.data.query.impl.Utils.renderQuerySpec((QuerySpec)nextPageQuery.querySpec[0]));
                this.totalItemCount = 0;
            } else {
                if (nextPageResponse.resultSet.length > 1) {
                    logger.warn("DataService returned multiple ResultSets for a single-query request. Extraneous results were discarded. The query was:\n{}", (Object)com.vmware.vise.data.query.impl.Utils.renderQuerySpec((QuerySpec)nextPageQuery.querySpec[0]));
                    nextPageResponse.resultSet = new ResultSet[]{nextPageResponse.resultSet[0]};
                }
                ResultSet nextPage = nextPageResponse.resultSet[0];
                this.totalItemCount = nextPage.totalMatchedObjectCount != null ? nextPage.totalMatchedObjectCount : ArrayUtils.getLength((Object)nextPage.items);
            }
            return nextPageResponse;
        }

        private RequestSpec getRequestForNextPage() {
            QuerySpec querySpec;
            try {
                querySpec = this.baseQuery.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Bug("Known clonable type QuerySpec threw CloneNotSupportedException.", (Throwable)e);
            }
            if (querySpec.resultSpec == null) {
                querySpec.resultSpec = new ResultSpec();
            }
            querySpec.resultSpec.offset = this.currentOffset;
            querySpec.resultSpec.maxResultCount = this.pageSize;
            RequestSpec requestSpec = new RequestSpec();
            requestSpec.querySpec = new QuerySpec[]{querySpec};
            return requestSpec;
        }
    }
}

