/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.QueryOption;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.telemetry.cmc.CdfCollector;
import com.vmware.vsphere.telemetry.cmc.CollectedPayload;
import com.vmware.vsphere.telemetry.cmc.Utils;
import com.vmware.vsphere.telemetry.cmc.cdf.CdfMappingParser;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.cdf.Mapping;
import com.vmware.vsphere.telemetry.cmc.request.RequestSpecParser;
import java.util.Collections;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestCdfCollector
implements CdfCollector {
    public static final String HOST_QUERY_NAME = "ghost:host-statistics";
    public static final String VC_QUERY_NAME = "ghost:vcenter-deployment-statistics";
    public static final String LM_QUERY_NAME = "ghost-lm-query2";
    public static final String MAPPING_ELEMENT_NAME = "cdfMapping";
    private static final Logger logger = LoggerFactory.getLogger(TestCdfCollector.class);
    private final CdfMappingParser _mappingParser;
    private final RequestSpec _requestSpec;
    private final RequestSpecParser _requestSpecParser;

    public TestCdfCollector(CdfMappingParser mappingParser) {
        this(mappingParser, TestCdfCollector.createTestRequest());
    }

    public TestCdfCollector(CdfMappingParser mappingParser, RequestSpec requestSpec) {
        this._mappingParser = mappingParser;
        this._requestSpec = requestSpec;
        this._requestSpecParser = null;
    }

    public TestCdfCollector(CdfMappingParser mappingParser, RequestSpecParser requestSpecParser) {
        this._mappingParser = mappingParser;
        this._requestSpecParser = requestSpecParser;
        this._requestSpec = null;
    }

    @Override
    public Iterable<CollectedPayload> collect(Document manifest, DataService dataService, VcService vcService, Context context, int pageSize) {
        Response response;
        Mapping cdfMapping;
        try {
            NodeList nl = manifest.getElementsByTagName(MAPPING_ELEMENT_NAME);
            if (nl.getLength() < 1) {
                throw new SAXException("No element cdfMapping");
            }
            Node cdfMappingNode = nl.item(0);
            cdfMapping = this._mappingParser.parse(cdfMappingNode);
        }
        catch (SAXException e) {
            logger.warn("Unrecognized manifest. Skipping collection", (Throwable)e);
            return null;
        }
        try {
            if (this._requestSpec != null) {
                response = dataService.getData(this._requestSpec);
            } else {
                NodeList nodeList = manifest.getElementsByTagName("request");
                if (nodeList.getLength() < 1) {
                    throw new SAXException("There's no request element in the manifest document.");
                }
                response = dataService.getData(this._requestSpecParser.parse(nodeList.item(0)));
            }
        }
        catch (SAXException e) {
            logger.warn("Unrecognized querySpec in the manifest. Skipping collection", (Throwable)e);
            return null;
        }
        String resultSetAsString = Utils.renderResultSets(response.resultSet);
        logger.info("[CMC] Test query result:\n{}", (Object)resultSetAsString);
        Payload payload = (Payload)cdfMapping.map(response, context);
        CollectedPayload collectedData = new CollectedPayload.Builder(payload).build();
        return Collections.singletonList(collectedData);
    }

    private static RequestSpec createTestRequest() {
        RequestSpec request = new RequestSpec();
        request.querySpec = new QuerySpec[]{TestCdfCollector.createHostsDataRequest(), TestCdfCollector.createVCentersDataRequest(), TestCdfCollector.createLMDataRequest()};
        return request;
    }

    private static QuerySpec createLMDataRequest() {
        ObjectIdentityConstraint vcs = new ObjectIdentityConstraint();
        vcs.targetType = "HostSystem";
        vcs.target = new ManagedObjectReference("HostSystem", "host-9", "313a8eb9-4fa5-4af8-854c-b8506840e655");
        RelationalConstraint ac = new RelationalConstraint();
        ac.constraintOnRelatedObject = vcs;
        ac.relation = "assets";
        ac.targetType = "Asset";
        ac.hasInverseRelation = true;
        PropertySpec vcPropertiesSpec = new PropertySpec();
        vcPropertiesSpec.type = "Asset";
        vcPropertiesSpec.propertyNames = new String[]{"name"};
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = LM_QUERY_NAME;
        querySpec.resourceSpec = new ResourceSpec();
        querySpec.resourceSpec.constraint = ac;
        querySpec.resourceSpec.propertySpecs = new PropertySpec[]{vcPropertiesSpec};
        TestCdfCollector.configureLocalQuery(querySpec);
        return querySpec;
    }

    private static QuerySpec createVCentersDataRequest() {
        Constraint vcs = new Constraint();
        vcs.targetType = "ServiceInstance";
        PropertySpec vcPropertiesSpec = new PropertySpec();
        vcPropertiesSpec.type = "ServiceInstance";
        vcPropertiesSpec.propertyNames = new String[]{"content.about.build", "content.about.version", "content.about.osType"};
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = VC_QUERY_NAME;
        querySpec.resourceSpec = new ResourceSpec();
        querySpec.resourceSpec.constraint = vcs;
        querySpec.resourceSpec.propertySpecs = new PropertySpec[]{vcPropertiesSpec};
        TestCdfCollector.configureLocalQuery(querySpec);
        return querySpec;
    }

    protected static void configureLocalQuery(QuerySpec querySpec) {
        querySpec.options = new HashMap();
        querySpec.options.put(QueryOption.LOCAL_SCOPE.name(), true);
    }

    private static QuerySpec createHostsDataRequest() {
        Constraint hosts = new Constraint();
        hosts.targetType = "HostSystem";
        PropertySpec hostPropertiesSpec = new PropertySpec();
        hostPropertiesSpec.type = "HostSystem";
        hostPropertiesSpec.propertyNames = new String[]{"hardware.systemInfo.uuid", "summary.config.product.version", "summary.config.product.build", "hardware.systemInfo.vendor", "hardware.systemInfo.model", "hardware.cpuPkg.vendor", "hardware.cpuInfo.numCpuPackages", "hardware.cpuInfo.numCpuCore", "hardware.memorySize"};
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = HOST_QUERY_NAME;
        querySpec.resourceSpec = new ResourceSpec();
        querySpec.resourceSpec.constraint = hosts;
        querySpec.resourceSpec.propertySpecs = new PropertySpec[]{hostPropertiesSpec};
        TestCdfCollector.configureLocalQuery(querySpec);
        return querySpec;
    }
}

