/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection;

import com.vmware.ph.ceip.authentication.DsSessionSimulator;
import com.vmware.ph.ceip.authentication.SessionSimulationException;
import com.vmware.ph.ceip.authentication.solutionuser.SolutionUserAuthenticationConfig;
import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadBuilder;
import com.vmware.ph.client.api.commondataformat.dimensions.Collector;
import com.vmware.ph.client.api.commondataformat.serialization.rdf.CdfSequenceSerializerFactory;
import com.vmware.ph.client.api.commondataformat.serialization.rdf.RdfCdfSequenceSerializer;
import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.ceip.util.Utils;
import com.vmware.vsphere.telemetry.cmc.CdfCollector;
import com.vmware.vsphere.telemetry.cmc.CollectedPayload;
import com.vmware.vsphere.telemetry.cmc.ContextFactory;
import com.vmware.vsphere.telemetry.cmc.InvalidManifestException;
import com.vmware.vsphere.telemetry.cmc.ManifestUtils;
import com.vmware.vsphere.telemetry.cmc.StorageUtils;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.cdf.PayloadUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.exception.ParseErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class TestQueryExecutor {
    private static final String TEST_COLLECTION_ID = "collection_id";
    private static final Collector TEST_COLLECTOR = new Collector("test_query_collector_id", "test_query_instance_id");
    private static final Logger logger = LoggerFactory.getLogger(TestQueryExecutor.class);
    private final DataService _dataService;
    private final CdfCollector _cdfCollector;
    private final File _fileToMonitor;
    private final ContextFactory _contextFactory;
    private final DsSessionSimulator _sessionSimulator;
    private final SolutionUserAuthenticationConfig _authConfig;

    public TestQueryExecutor(DataService dataService, CdfCollector cdfCollector, ContextFactory contextFactory, File fileToMonitor, DsSessionSimulator sessionSimulator, SolutionUserAuthenticationConfig authConfig) {
        this._dataService = dataService;
        this._cdfCollector = cdfCollector;
        this._fileToMonitor = fileToMonitor;
        this._contextFactory = contextFactory;
        this._sessionSimulator = sessionSimulator;
        this._authConfig = authConfig;
    }

    public void start() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestQueryExecutor.this.monitorManifestFileForChanges();
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted exception happened.", (Throwable)e);
                }
            }
        }, "usage-data-collector-thread");
        t.setDaemon(true);
        t.start();
    }

    private void monitorManifestFileForChanges() throws InterruptedException {
        long lastModified = 0L;
        while (true) {
            long newLastModified;
            if ((newLastModified = this._fileToMonitor.lastModified()) != lastModified) {
                try {
                    logger.info("Manifest file was changed.");
                    this.execute();
                }
                catch (InvalidManifestException e) {
                    logger.error("Invalid manifest found.", (Throwable)e);
                }
                catch (ParseErrorException e) {
                    logger.error("Invalid manifest found.", (Throwable)e);
                }
                lastModified = newLastModified;
            }
            Thread.sleep(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        Document manifestDoc = this.createManifestDocument();
        int accumulationSize = 1000;
        HttpServletRequest request = null;
        try {
            request = this._sessionSimulator.simulate(this._authConfig, "test_query_executor_solution_user_actor_simulation");
            VcService targetVc = this.findTargetVcService();
            Context context = this.createContext(targetVc);
            this.runCollector(context, manifestDoc, 1000, targetVc);
        }
        catch (SessionSimulationException sse) {
            logger.error("Error while simulating session: " + sse.getMessage(), (Throwable)sse);
        }
        finally {
            logger.debug("Destroying session.");
            this._sessionSimulator.close(request);
        }
    }

    private Document createManifestDocument() {
        return ManifestUtils.parseManifestToDoc(this.readManifestFromFile());
    }

    private Context createContext(VcService vcService) {
        return this._contextFactory.createVcAwareContext(TEST_COLLECTOR, TEST_COLLECTION_ID, vcService);
    }

    private void runCollector(Context context, Document manifestDoc, int accumulationSize, VcService vcService) {
        Iterable<CollectedPayload> payloads = this._cdfCollector.collect(manifestDoc, this._dataService, vcService, context, accumulationSize);
        PayloadBuilder uploadBuilder = new PayloadBuilder();
        for (CollectedPayload collectedPayload : payloads) {
            Payload payload = collectedPayload.getPayload();
            PayloadUtil.merge(uploadBuilder, payload);
        }
        this.savePayloadToFile(uploadBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePayloadToFile(Payload payload) {
        FileOutputStream fileStream = null;
        RdfCdfSequenceSerializer serializer = null;
        try {
            File cdfDirectory = new File(StorageUtils.getStorageDirectory(), "cdf");
            FileUtils.forceMkdir((File)cdfDirectory);
            FileUtils.cleanDirectory((File)cdfDirectory);
            File filename = new File(cdfDirectory, "payload.cdf");
            fileStream = new FileOutputStream(filename);
            try {
                serializer = CdfSequenceSerializerFactory.createRdfCdfSequenceSerializer((OutputStream)fileStream);
                for (Resource res : payload.getResources()) {
                    serializer.write((CdfAble)res);
                }
            }
            finally {
                if (serializer != null) {
                    serializer.close();
                }
                ((OutputStream)fileStream).close();
            }
        }
        catch (IOException e) {
            logger.error("Exception occurred while trying to serialize Payload.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readManifestFromFile() {
        String string;
        FileInputStream is = null;
        try {
            is = new FileInputStream(this._fileToMonitor);
            StringBuilder content = new StringBuilder();
            for (Object obj : IOUtils.readLines((InputStream)is)) {
                content.append((String)obj);
            }
            string = content.toString();
        }
        catch (IOException e) {
            String string2;
            try {
                string2 = "";
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            return string2;
        }
        IOUtils.closeQuietly((InputStream)is);
        return string;
    }

    private VcService findTargetVcService() {
        logger.info("findTargetVcService taking it from VimSessionUtil.getLinkedVcGroupRegistry()");
        LinkedVcGroupRegistry vcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        return Utils.getVcService((LinkedVcGroupRegistry)vcGroupRegistry);
    }
}

