/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.telemetry.cmc.CdfCollector;
import com.vmware.vsphere.telemetry.cmc.CollectedPayload;
import com.vmware.vsphere.telemetry.cmc.InvalidManifestException;
import com.vmware.vsphere.telemetry.cmc.cdf.CdfMappingParser;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.cdf.Mapping;
import com.vmware.vsphere.telemetry.cmc.collection.PagingEventQueryBatchIterator;
import com.vmware.vsphere.telemetry.cmc.event.request.RequestManifest;
import com.vmware.vsphere.telemetry.cmc.event.request.RequestManifestParser;
import com.vmware.vsphere.telemetry.cmc.event.response.Response;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class VcEventCollector
implements CdfCollector {
    private static final Logger log = LoggerFactory.getLogger(VcEventCollector.class);
    private static final String MAPPING_ELEMENT_NAME = "eventResponse";
    private static final String REQUEST_ELEMENT_NAME = "eventRequest";
    private static final int EVENT_HISTORY_COLLECTOR_MAX_PAGE_SIZE = 1000;
    private final CdfMappingParser mappingParser;
    private final RequestManifestParser requestParser;
    private final PagingEventQueryBatchIteratorFactory iteratorFactory = new PagingEventQueryBatchIteratorFactory(){

        @Override
        public PagingEventQueryBatchIterator newInstance(VcService vcService, Mapping<Response, Payload> responseMapping, Context mappingContext, RequestManifest request, int pageSize) {
            return new PagingEventQueryBatchIterator(vcService, responseMapping, mappingContext, request, pageSize);
        }
    };

    public VcEventCollector(RequestManifestParser requestParser, CdfMappingParser mappingParser) {
        this.requestParser = requestParser;
        this.mappingParser = mappingParser;
    }

    @Override
    public Iterable<CollectedPayload> collect(Document manifest, DataService dataService, final VcService vcService, final Context context, int pageSize) {
        Validate.notNull((Object)manifest, (String)"manifest is required.");
        Validate.notNull((Object)vcService, (String)"vcService is required.");
        final int reducedPageSize = Math.min(pageSize, 1000);
        final RequestManifest request = this.parseRequestSpecFromManifest(manifest);
        if (CollectionUtils.isEmpty(request.getQueries())) {
            log.info("VC event collector is turned off.");
            log.debug("VC event collector is turned off since the '{}' element does not exist.", (Object)REQUEST_ELEMENT_NAME);
            return Collections.emptyList();
        }
        final Mapping responseMapping = this.parseMappingFromManifest(manifest);
        return new Iterable<CollectedPayload>(){

            @Override
            public Iterator<CollectedPayload> iterator() {
                return VcEventCollector.this.iteratorFactory.newInstance(vcService, responseMapping, context, request, reducedPageSize);
            }
        };
    }

    private <T> Mapping<T, Payload> parseMappingFromManifest(Document manifestDoc) {
        Element mappingElement = this.getRequiredElement(manifestDoc, MAPPING_ELEMENT_NAME);
        return this.mappingParser.parse(mappingElement);
    }

    private RequestManifest parseRequestSpecFromManifest(Document manifestDoc) {
        Element requestElement = this.getRequiredElement(manifestDoc, REQUEST_ELEMENT_NAME);
        return this.requestParser.parse(requestElement);
    }

    private Element getRequiredElement(Document manifest, String elementName) {
        NodeList elements = manifest.getElementsByTagName(elementName);
        if (elements.getLength() < 1 || elements.item(0).getNodeType() != 1) {
            throw new InvalidManifestException("Collection manifest is missing required element: " + elementName);
        }
        return (Element)elements.item(0);
    }

    static interface PagingEventQueryBatchIteratorFactory {
        public PagingEventQueryBatchIterator newInstance(VcService var1, Mapping<Response, Payload> var2, Context var3, RequestManifest var4, int var5);
    }
}

