/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadBuilder;
import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.ExtensionManager;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.vmomi.client.exception.RemoteException;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.telemetry.cmc.CdfCollector;
import com.vmware.vsphere.telemetry.cmc.CollectedPayload;
import com.vmware.vsphere.telemetry.cmc.ManifestUtils;
import com.vmware.vsphere.telemetry.cmc.cdf.CdfMappingParser;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.cdf.Mapping;
import com.vmware.vsphere.telemetry.cmc.cdf.PayloadUtil;
import java.util.Collections;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class VcExtensionsCollector
implements CdfCollector {
    private static final String ERROR_READING_EXTENSIONS = "Error while retrieving VC extension information.";
    private static final Logger log = LoggerFactory.getLogger(VcExtensionsCollector.class);
    private static final String EXTENSION_MAPPING_ELEMENT_NAME = "extensionMapping";
    private static final String COLLECTOR_IS_TURNED_OFF_MSG = "VC extension collector is turned off in the";
    private final CdfMappingParser _mappingParser;

    public VcExtensionsCollector(CdfMappingParser mappingParser) {
        this._mappingParser = mappingParser;
    }

    @Override
    public Iterable<CollectedPayload> collect(Document manifest, DataService dataService, VcService vcService, Context context, int pageSize) {
        Validate.notNull((Object)manifest, (String)"manifest is required.");
        Validate.notNull((Object)vcService, (String)"vcService is required.");
        Element mappingElement = ManifestUtils.findOptionalElement(manifest, EXTENSION_MAPPING_ELEMENT_NAME);
        if (mappingElement == null) {
            log.info("VC extension collector is turned off in the, {} element does not exist.", (Object)EXTENSION_MAPPING_ELEMENT_NAME);
            return Collections.emptyList();
        }
        NodeList children = mappingElement.getChildNodes();
        if (children.getLength() == 0 || children.getLength() == 1 && mappingElement.getTextContent() != null && "".equals(mappingElement.getTextContent().trim())) {
            log.info("VC extension collector is turned off in the, {} element is empty.", (Object)EXTENSION_MAPPING_ELEMENT_NAME);
            return Collections.emptyList();
        }
        Mapping<DataObject, Payload> extensionMapping = this._mappingParser.parse(mappingElement);
        return Collections.singletonList(this.collect(extensionMapping, vcService, context));
    }

    CollectedPayload collect(Mapping<DataObject, Payload> extensionMapping, VcService vcService, Context context) {
        assert (extensionMapping != null);
        assert (vcService != null);
        log.debug("Start collecting extension information for VC url = {}  guid = {}", (Object)vcService.getServiceUrl(), (Object)vcService.getServiceGuid());
        Context extensionContext = new Context(context);
        extensionContext.put("vc.serviceGuid", vcService.getServiceGuid());
        PayloadBuilder extensionsPayload = new PayloadBuilder();
        CollectedPayload.Builder collectedData = new CollectedPayload.Builder();
        try {
            Extension[] extensions = this.getExtensionList(vcService);
            for (Extension extension : extensions = extensions == null ? new Extension[]{} : extensions) {
                if (extension == null) continue;
                log.trace("Mapping extension {} to Payload", (Object)extension.getKey());
                Payload currentExtensionPayload = extensionMapping.map((DataObject)extension, extensionContext);
                PayloadUtil.merge(extensionsPayload, currentExtensionPayload);
            }
            collectedData.setPayload(extensionsPayload.build());
        }
        catch (RuntimeFault e) {
            log.error(ERROR_READING_EXTENSIONS, (Throwable)e);
            collectedData.setTransientError((Exception)((Object)e));
        }
        catch (RemoteException e) {
            log.error(ERROR_READING_EXTENSIONS, (Throwable)e);
            collectedData.setTransientError((Exception)((Object)e));
        }
        return collectedData.build();
    }

    private Extension[] getExtensionList(VcService vcService) {
        ManagedObjectReference extensionManagerMoRef = vcService.getServiceInstanceContent().getExtensionManager();
        ExtensionManager em = (ExtensionManager)vcService.getManagedObject(extensionManagerMoRef);
        if (em == null) {
            log.warn("getManagedObject returned null for moRef {}.", (Object)extensionManagerMoRef);
            return null;
        }
        return em.getExtensionList();
    }
}

