/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VmodlDomFormatter {
    private static final String FIELD_DELIMETER = "_";

    public Map<String, Object> flattenToKeyValuePairs(Node root) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        HashSet<Node> visited = new HashSet<Node>();
        Stack<Node> pending = new Stack<Node>();
        pending.push(root);
        while (!pending.isEmpty()) {
            Node current = (Node)pending.pop();
            if (visited.contains(current)) continue;
            visited.add(current);
            if (current.getNodeType() == 3) {
                if (StringUtils.isBlank((String)current.getTextContent())) continue;
                String key = this.getKey(current, root);
                String value = current.getTextContent();
                properties.put(key, value);
                continue;
            }
            NodeList childNodes = current.getChildNodes();
            for (int childIndex = 0; childIndex < childNodes.getLength(); ++childIndex) {
                pending.push(childNodes.item(childIndex));
            }
        }
        return properties;
    }

    public Map<String, Object> getKeyValuePairs(Node root) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        NodeList childNodes = root.getChildNodes();
        for (int childIndex = 0; childIndex < childNodes.getLength(); ++childIndex) {
            Node child = childNodes.item(childIndex);
            if (child.getChildNodes().getLength() != 1 || child.getFirstChild().getNodeType() != 3) continue;
            result.put(child.getNodeName(), child.getFirstChild().getTextContent());
        }
        return result;
    }

    private String getKey(Node textNode, Node root) {
        LinkedList<String> names = new LinkedList<String>();
        for (Node current = textNode.getParentNode(); current != root; current = current.getParentNode()) {
            names.add(current.getNodeName());
        }
        return StringUtils.join((Collection)Lists.reverse(names), (String)FIELD_DELIMETER);
    }
}

