/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection;

import com.vmware.ph.exceptions.Bug;
import com.vmware.vim.binding.vim.version.version10;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.vmomi.core.exception.MarshallException;
import com.vmware.vim.vmomi.core.soap.Marshaller;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vim.vmomi.core.types.impl.VmodlFieldImpl;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class VmodlDomSerializer {
    private static Logger log = LoggerFactory.getLogger(VmodlDomSerializer.class);
    private final VmodlVersion _vimVersion;
    private final VmodlContext _vmodlContext;

    public VmodlDomSerializer() {
        VmodlContext vmodlContext = null;
        try {
            vmodlContext = VmodlContext.getContext();
        }
        catch (IllegalStateException ex) {
            String vimCtx = "com.vmware.vim.binding.vim";
            log.debug("Initializing VIM VMODL context for com.vmware.vim.binding.vim");
            vmodlContext = VmodlContext.initContext((String[])new String[]{"com.vmware.vim.binding.vim"});
        }
        this._vmodlContext = vmodlContext;
        VmodlVersionMap versionMap = VmodlVersionMap.Factory.getVmodlVersionMap();
        this._vimVersion = versionMap.getVersion(version10.class);
    }

    Node getDataObjectAsNode(DataObject dataObject) {
        assert (null != dataObject);
        Class<?> fieldClass = dataObject.getClass();
        VmodlField field = this.getField(fieldClass);
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            DOMResult result = new DOMResult(docBuilder.newDocument());
            XMLStreamWriter xtw = xof.createXMLStreamWriter(result);
            Marshaller m = this._vmodlContext.createMarshaller(this._vimVersion);
            m.marshal(field, (Object)dataObject, xtw);
            if (log.isDebugEnabled()) {
                log.debug("Data Object {} serialized as XML: {}", dataObject.getClass(), (Object)VmodlDomSerializer.docToString(result.getNode()));
            }
            return result.getNode().getFirstChild();
        }
        catch (XMLStreamException e) {
            log.error("Failed marshalling " + dataObject + " due to processing xml error", (Throwable)e);
            throw new Bug("Failed marshing " + dataObject, (Throwable)e);
        }
        catch (MarshallException e) {
            log.error("Failed marshalling " + dataObject, (Throwable)e);
            throw new IllegalArgumentException("Failed marshing " + dataObject, e);
        }
        catch (ParserConfigurationException e) {
            log.error("Failed marshalling " + dataObject + " due to bad xml parser configuration", (Throwable)e);
            throw new Bug("Failed marshing " + dataObject, (Throwable)e);
        }
    }

    private VmodlField getField(Class<? extends DataObject> fieldClass) {
        String fieldName = fieldClass.getSimpleName();
        VmodlFieldImpl field = new VmodlFieldImpl(this._vmodlContext);
        field.setName(fieldName);
        field.setType(VmodlTypeMap.Factory.getTypeMap().getVmodlType(fieldClass));
        field.setVersion(this._vimVersion);
        return field;
    }

    private static String docToString(Node doc) {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            StringWriter sw = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerConfigurationException e) {
            log.debug("Failed to parse  XML Node", (Throwable)e);
        }
        catch (TransformerException e) {
            log.debug("Failed to parse  XML Node", (Throwable)e);
        }
        return "[cannot-parse-node]";
    }
}

