/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection.file;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.Validate;
import org.apache.http.conn.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTrustStrategy
implements TrustStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractTrustStrategy.class);
    protected String hostName;
    protected List<X509Certificate> trustedCertificates;

    public AbstractTrustStrategy(List<X509Certificate> trustedCertificates, String hostName) {
        Validate.notNull(trustedCertificates, (String)"trustedCertificates");
        Validate.notNull((Object)hostName, (String)"hostName");
        this.hostName = hostName;
        this.trustedCertificates = trustedCertificates;
    }

    protected AbstractTrustStrategy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore createTempKeyStore() {
        log.trace("Creating in-memory trust store for host at " + this.hostName);
        try {
            KeyStore tempKeyStore = KeyStore.getInstance("JKS");
            tempKeyStore.load(null, null);
            for (X509Certificate trustedCertificate : this.trustedCertificates) {
                try {
                    tempKeyStore.setCertificateEntry(trustedCertificate.getSubjectDN().getName(), trustedCertificate);
                    log.trace("Added " + trustedCertificate + " as trusted authority for " + this.hostName);
                }
                catch (KeyStoreException e) {
                    log.warn("Cannot add certificate " + trustedCertificate + " for connection to host " + this.hostName + ", this certificate will not be trusted", (Throwable)e);
                }
            }
            KeyStore keyStore = tempKeyStore;
            return keyStore;
        }
        catch (GeneralSecurityException e) {
            this.failedToCreateKeyStoreLogException(e);
        }
        catch (IOException e) {
            this.failedToCreateKeyStoreLogException(e);
        }
        finally {
            log.trace("FINISHED creating in-memory trust store for host at " + this.hostName);
        }
        return null;
    }

    private void failedToCreateKeyStoreLogException(Exception e) {
        log.warn("FAILED to create in-memory trust store for host at " + this.hostName + " connection this host will happen without a trustore, this will result in SSL" + " exception if the host certificate is not trusted by an official trusted authority.", (Throwable)e);
    }

    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            KeyStore tempKeyStore = this.createTempKeyStore();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(tempKeyStore);
            if (trustManagerFactory.getTrustManagers() != null) {
                boolean isTrusted = false;
                for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                    if (!(trustManager instanceof X509TrustManager)) continue;
                    ((X509TrustManager)trustManager).checkServerTrusted(chain, authType);
                    isTrusted = true;
                }
                return isTrusted;
            }
            log.warn("No SSL trust managers could be obtained, certificate verification cannot be preformed on chain " + Arrays.toString(chain) + ". SSL connection to host " + this.hostName + " will fail.");
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            this.cannotVerifyChain(chain, e);
        }
        catch (KeyStoreException e) {
            this.cannotVerifyChain(chain, e);
        }
        return false;
    }

    private void cannotVerifyChain(X509Certificate[] chain, GeneralSecurityException e) {
        log.error("Cannot verify that certificate chain " + Arrays.toString(chain) + " is valid. SSL connection to host " + this.hostName + " will fail.", (Throwable)e);
    }
}

