/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection.file;

import com.vmware.ph.common.StringUtil;
import com.vmware.ph.exceptions.Exceptions;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.telemetry.cmc.collection.file.AllowAllHttpsConnectionsTrustStrategy;
import com.vmware.vsphere.telemetry.cmc.collection.file.InventoryScanner;
import com.vmware.vsphere.telemetry.cmc.collection.file.SingleHostTrustStrategy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsxCfgInfoCollector {
    private static final int CONNECTION_TIMEOUT_MILLIS = 60000;
    private static final int SOCKET_TIMEOUT_MILLIS = 120000;
    private static final Logger log = LoggerFactory.getLogger(EsxCfgInfoCollector.class);
    private final SessionManager sessionManager;
    private final byte[] certificate;
    private String devEsxCfgInfoDownloadUrl = "";
    private final String[] availableIps;

    public EsxCfgInfoCollector(VcService vcService, HostSystem host) {
        ManagedObjectReference sessionMgrMor = vcService.getServiceInstanceContent().getSessionManager();
        this.sessionManager = (SessionManager)vcService.getManagedObject(sessionMgrMor);
        VirtualNic[] hostNics = InventoryScanner.getHostManagementInterfaces(host, vcService);
        this.availableIps = new String[hostNics.length];
        for (int i = 0; i < hostNics.length; ++i) {
            this.availableIps[i] = hostNics[i].getSpec().getIp().getIpAddress();
        }
        this.certificate = host.getConfig().getCertificate();
    }

    public void setDevEsxCfgInfoDownloadUrl(String value) {
        this.devEsxCfgInfoDownloadUrl = value;
    }

    private HttpResponse accessUrl(String accessUrl, byte[] certificate, SessionManager.GenericServiceTicket accessTicket) throws ClientProtocolException, IOException {
        if (this.isDevEsxCfgInfoDownloadUrlPropertySpecified()) {
            log.debug("EsxCfgInfo url dev mode property is specified, will download {}", (Object)this.devEsxCfgInfoDownloadUrl);
            accessUrl = this.devEsxCfgInfoDownloadUrl;
        }
        try {
            SingleHostTrustStrategy trustStrategy = this.createTrustStrategy(accessUrl, certificate);
            HttpClient client = this.createHttpClient(accessUrl, trustStrategy, trustStrategy);
            HttpGet httpGet = new HttpGet(accessUrl);
            httpGet.setHeader("Cookie", "vmware_cgi_ticket=" + accessTicket.getId());
            HttpResponse response = client.execute((HttpUriRequest)httpGet);
            return response;
        }
        catch (KeyManagementException e) {
            this.cannotConnectLogExpception(accessUrl, e);
        }
        catch (UnrecoverableKeyException e) {
            this.cannotConnectLogExpception(accessUrl, e);
        }
        catch (NoSuchAlgorithmException e) {
            this.cannotConnectLogExpception(accessUrl, e);
        }
        catch (KeyStoreException e) {
            this.cannotConnectLogExpception(accessUrl, e);
        }
        catch (CertificateException e) {
            this.cannotConnectLogExpception(accessUrl, e);
        }
        assert (false);
        return null;
    }

    private boolean isDevEsxCfgInfoDownloadUrlPropertySpecified() {
        return !StringUtils.isEmpty((String)this.devEsxCfgInfoDownloadUrl);
    }

    private SingleHostTrustStrategy createTrustStrategy(String accessUrl, byte[] certificate) throws CertificateException, MalformedURLException {
        if (this.isDevEsxCfgInfoDownloadUrlPropertySpecified()) {
            return new AllowAllHttpsConnectionsTrustStrategy(certificate, accessUrl);
        }
        return new SingleHostTrustStrategy(certificate, accessUrl);
    }

    private void cannotConnectLogExpception(String accessUrl, GeneralSecurityException e) throws IOException {
        String message = "FAILED connecting to URL " + accessUrl + " the support data for this host will not be" + " downloaded.";
        log.error(message, (Throwable)e);
        throw new IOException(message, e);
    }

    protected HttpClient createHttpClient(String accessUrl, TrustStrategy trustStrategy, X509HostnameVerifier hostNameVerifier) throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, MalformedURLException {
        URL url = new URL(accessUrl);
        SSLSocketFactory ssf = new SSLSocketFactory(trustStrategy, hostNameVerifier);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        int port = url.getPort() > 0 ? url.getPort() : 443;
        log.trace("Setting up SSL connection for url '" + accessUrl + "', the protocol is '" + url.getProtocol() + "' the port is '" + port + "'");
        schemeRegistry.register(new Scheme(url.getProtocol(), port, (SchemeSocketFactory)ssf));
        BasicClientConnectionManager ccm = new BasicClientConnectionManager(schemeRegistry);
        DefaultHttpClient result = new DefaultHttpClient((ClientConnectionManager)ccm);
        result.getParams().setIntParameter("http.socket.timeout", 120000);
        result.getParams().setIntParameter("http.connection.timeout", 60000);
        return result;
    }

    public void retrieveConfigXml(File destinationFile) {
        Exceptions.traceEntering((Logger)log);
        for (String ipAddress : this.availableIps) {
            String address = "https://" + ipAddress + "/cgi-bin/esxcfg-info.cgi?xml";
            log.debug("Requesting service ticket for esxcfg xml via {} ...", (Object)address);
            SessionManager.HttpServiceRequestSpec spec = new SessionManager.HttpServiceRequestSpec();
            spec.setUrl(address);
            try {
                SessionManager.GenericServiceTicket serviceTicket = this.sessionManager.acquireGenericServiceTicket((SessionManager.ServiceRequestSpec)spec);
                log.debug("Acquired generic service ticket for URL '{}' with id: '{}'", (Object)spec.getUrl(), (Object)serviceTicket.getId());
                log.debug("Requesting service ticket for esxcfg xml via {} DONE, ticket for {} is {}", (Object[])new String[]{address, spec.getUrl(), StringUtil.trimMiddle((String)serviceTicket.getId(), (int)3, (int)3)});
                this.downloadSupportData(address, serviceTicket, destinationFile);
                return;
            }
            catch (Exception e) {
                log.warn("Could not get cgi-bin/esxcfg-info.cgi?xml via IP " + ipAddress, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadSupportData(String esxAccessUrl, SessionManager.GenericServiceTicket esxAccessTicket, File destinationFile) throws IOException {
        assert (null != destinationFile);
        log.debug("Requesting to download data. Request address is " + esxAccessUrl);
        HttpResponse response = this.accessUrl(esxAccessUrl, this.certificate, esxAccessTicket);
        log.debug("Request to download data received response: " + response.getStatusLine());
        destinationFile.getAbsoluteFile().getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(destinationFile);
        try {
            long contentLength = response.getEntity().getContentLength();
            String destPathName = destinationFile.getAbsolutePath();
            log.debug("Writing data to file {}, expected data file size (as reported by the HTTP response body length) is (negative means \"don't know\"){}.", (Object)destPathName, (Object)contentLength);
            long totalRead = IOUtils.copyLarge((InputStream)response.getEntity().getContent(), (OutputStream)out);
            out.flush();
            log.debug("Writing data to file completed. Read {} bytes from HTTP stream, expected {}, read {}", new Object[]{destPathName, totalRead, contentLength});
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

