/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection.file;

import com.vmware.ph.ProductVersion;
import com.vmware.ph.exceptions.Exceptions;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.telemetry.cmc.collection.file.EsxCfgInfoCollector;
import com.vmware.vsphere.telemetry.cmc.collection.file.FileLayout;
import com.vmware.vsphere.telemetry.cmc.collection.file.InventoryHelper;
import com.vmware.vsphere.telemetry.cmc.collection.file.InventoryScanner;
import com.vmware.vsphere.telemetry.cmc.collection.file.ScannerCleaner;
import com.vmware.vsphere.telemetry.cmc.collection.file.VsphereFileCollectorStatistics;
import com.vmware.vsphere.telemetry.cmc.compress.Zip;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsxCollector {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final VsphereFileCollectorStatistics statsWriter = new VsphereFileCollectorStatistics();
    private final ScannerCleaner esxCfgCleaner = new ScannerCleaner("password");
    private final InventoryHelper inventoryHelper = new InventoryHelper();
    private String devEsxCfgInfoDownloadUrl = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectFromAllHosts(VcService vcService, File collectionRootFolder) {
        try {
            ManagedObjectReference[] arrMorHosts;
            Exceptions.traceEnteringWithInput((Logger)this.log, (String)("workingFolder=" + collectionRootFolder + ", vcService=" + vcService));
            for (ManagedObjectReference morHost : arrMorHosts = this.inventoryHelper.retrieveAllHosts(vcService)) {
                String moidHost = morHost.getValue();
                try {
                    this.log.trace("Starting working with {}.", (Object)moidHost);
                    HostSystem esx = (HostSystem)vcService.getManagedObject(morHost);
                    this.log.info("Requesting host version for {} ...", (Object)moidHost);
                    ProductVersion esxVersion = InventoryScanner.getHostVersion(esx);
                    this.log.info("Requesting host version for {} DONE. Version is {}", (Object)moidHost, (Object)esxVersion);
                    FileLayout fl = new FileLayout();
                    File fPerformanceStats = fl.getPerformanceStatsFile(collectionRootFolder);
                    this.statsWriter.appendTextToFile(fPerformanceStats, "version-of-" + moidHost + "\t" + esxVersion);
                    this.addEsxUuidToStats(esx, fPerformanceStats);
                    if (0 < new ProductVersion("5.0.0").compareTo(esxVersion)) {
                        this.log.info("Host {} version is {}, which is before 5.0.0, skipping this host.", (Object)moidHost, (Object)esxVersion);
                        continue;
                    }
                    File workingFolderForHost = fl.getWorkingFolderForHost(collectionRootFolder, moidHost);
                    workingFolderForHost.mkdirs();
                    File esxCfgXmlFile = new FileLayout().getEsxCfgXmlFile(workingFolderForHost);
                    this.collectEsxCfgXml(vcService, esx, esxCfgXmlFile, fPerformanceStats);
                    try {
                        this.esxCfgCleaner.clean(esxCfgXmlFile);
                        File zipFile = fl.getRTUZipFileForHostEsxcfg(collectionRootFolder, moidHost);
                        this.zipWithStatistics(esxCfgXmlFile, zipFile, "timeToArchiveEsxcfgIntoZipOfSize_", fPerformanceStats);
                    }
                    catch (IOException e) {
                        this.log.warn("Failed to clean sensitive data from {}. Skipping file.", (Throwable)e);
                    }
                    finally {
                        esxCfgXmlFile.delete();
                    }
                }
                catch (Exception e) {
                    this.log.error("Failed getting host version for " + moidHost + ". Continuing with next hosts (if any)", (Throwable)e);
                }
                finally {
                    this.log.trace("Done working with {}.", (Object)moidHost);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Failed collecting. Skipping VC {}", (Object)vcService, (Object)e);
        }
        finally {
            Exceptions.traceExiting((Logger)this.log);
        }
    }

    public void setDevEsxCfgInfoDownloadUrl(String value) {
        this.devEsxCfgInfoDownloadUrl = value;
    }

    private void zipWithStatistics(File fileOrFolderToZip, File destinationZipFile, String timeMetricPrefix, File fPerformanceStats) throws IOException {
        this.log.info(".... Zipping {} to file {}", (Object)fileOrFolderToZip.getAbsolutePath(), (Object)destinationZipFile.getAbsolutePath());
        destinationZipFile.getParentFile().mkdirs();
        long start = System.currentTimeMillis();
        Zip.zip(fileOrFolderToZip, destinationZipFile, false);
        long end = System.currentTimeMillis();
        this.log.info("DONE Zipping {} to file {}", (Object)fileOrFolderToZip.getAbsolutePath(), (Object)destinationZipFile.getAbsolutePath());
        String stats = timeMetricPrefix + destinationZipFile.length() + "\t" + (end - start);
        this.statsWriter.appendTextToFile(fPerformanceStats, stats);
    }

    private void addEsxUuidToStats(HostSystem esx, File fPerformanceStats) {
        try {
            String uuid = esx.getSummary().hardware.uuid;
            this.statsWriter.appendTextToFile(fPerformanceStats, "uuid-of-" + esx._getRef().getValue() + "\t" + uuid);
        }
        catch (Exception e) {
            this.log.warn("Could not write esx uuid to the stats file " + fPerformanceStats + ". No problem. Continuing.", (Throwable)e);
        }
    }

    private void collectEsxCfgXml(VcService vcService, HostSystem esx, File esxCfgXmlFile, File fPerformanceStats) {
        EsxCfgInfoCollector esxCfgInfoCollector = new EsxCfgInfoCollector(vcService, esx);
        long start = System.currentTimeMillis();
        esxCfgInfoCollector.setDevEsxCfgInfoDownloadUrl(this.devEsxCfgInfoDownloadUrl);
        esxCfgInfoCollector.retrieveConfigXml(esxCfgXmlFile);
        long end = System.currentTimeMillis();
        String stats = "retrieveTimeForEsxCfg_" + esx._getRef().getValue() + "\t" + (end - start);
        this.statsWriter.appendTextToFile(fPerformanceStats, stats);
    }
}

