/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection.file;

import com.vmware.vise.store.InvalidArgumentException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtilsMisc {
    private static final Logger log = LoggerFactory.getLogger(FileUtilsMisc.class);

    public static void moveFileToDirectory(File srcFile, File destDir) throws InvalidArgumentException, IOException {
        if (srcFile == null) {
            throw new InvalidArgumentException("Source file should be specified.");
        }
        if (destDir == null) {
            throw new InvalidArgumentException("Destination directory should be specified.");
        }
        if (!destDir.exists()) {
            throw new InvalidArgumentException("Destination directory does not exist.");
        }
        if (!destDir.isDirectory()) {
            throw new InvalidArgumentException(String.format("Destination directory '%s' is not a directory", destDir));
        }
        File destFile = new File(destDir, srcFile.getName());
        FileUtilsMisc.moveFile(srcFile, destFile);
    }

    public static boolean moveFileToDirectoryQuietly(File srcFile, File destDir) {
        try {
            FileUtilsMisc.moveFileToDirectory(srcFile, destDir);
            return true;
        }
        catch (IOException e) {
            log.error("Failed to move file {} in directory {}.", new Object[]{srcFile, destDir, e});
            return false;
        }
        catch (InvalidArgumentException e) {
            log.error("Failed to move file {} in directory {}.", new Object[]{srcFile, destDir, e});
            return false;
        }
    }

    public static void moveFile(File srcFile, File destFile) throws IOException, InvalidArgumentException {
        if (srcFile == null) {
            throw new InvalidArgumentException("Source file should be specified.");
        }
        if (!srcFile.exists()) {
            throw new InvalidArgumentException(String.format("Source '%s' does not exist, cannot continue", srcFile));
        }
        if (srcFile.isDirectory()) {
            throw new InvalidArgumentException(String.format("Source file '%s' actually is a directory, cannot continue.", srcFile));
        }
        if (destFile == null) {
            throw new InvalidArgumentException("Destination file should be specified.");
        }
        if (destFile.exists()) {
            throw new InvalidArgumentException(String.format("Destination file '%s' already exists, cannot continue.", destFile));
        }
        if (destFile.isDirectory()) {
            throw new InvalidArgumentException(String.format("Destination '%s' is a directory, cannot continue", destFile));
        }
        boolean successfulMove = srcFile.renameTo(destFile);
        if (successfulMove) {
            log.debug("Successfully moved {} to {}.", (Object)srcFile, (Object)destFile);
        } else {
            FileUtils.copyFile((File)srcFile, (File)destFile);
            if (!srcFile.delete()) {
                FileUtilsMisc.deleteFileQuietly(destFile);
                throw new IOException(String.format("Failed to delete source file '%s'", srcFile));
            }
            log.debug("Successfully copied+deleted {} over {}.", (Object)srcFile, (Object)destFile);
        }
    }

    public static void deleteFileQuietly(File file) {
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException ignored) {
            log.debug("force delete failed", (Throwable)ignored);
        }
    }
}

