/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection.file;

import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.view.ContainerView;
import com.vmware.vim.binding.vim.view.ViewManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.impl.VmodlTypeImpl;
import com.vmware.vise.vim.commons.vcservice.VcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryHelper {
    protected static final Logger log = LoggerFactory.getLogger(InventoryHelper.class);

    public ManagedObjectReference[] retrieveAllHosts(VcService vcService) {
        log.debug("started: retrieving host list");
        TypeNameImpl hostSystemTypeName = new TypeNameImpl((VmodlType)new VmodlTypeImpl(HostSystem.class, VmodlContext.getContext()));
        ServiceInstanceContent sic = vcService.getServiceInstanceContent();
        ViewManager viewManager = (ViewManager)vcService.getManagedObject(sic.getViewManager());
        ManagedObjectReference containerViewMor = viewManager.createContainerView(sic.getRootFolder(), new TypeName[]{hostSystemTypeName}, true);
        ContainerView containerView = (ContainerView)vcService.getManagedObject(containerViewMor);
        ManagedObjectReference[] hostMoRefs = containerView.getView();
        log.debug("completed: retrieving host list");
        return hostMoRefs == null ? new ManagedObjectReference[]{} : hostMoRefs;
    }
}

