/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection.file;

import com.vmware.ph.ProductVersion;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.fault.HostConfigFault;
import com.vmware.vim.binding.vim.host.ConfigInfo;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.NetCapabilities;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vim.host.Summary;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vim.view.ContainerView;
import com.vmware.vim.binding.vim.view.ViewManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.impl.VmodlTypeImpl;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryScanner {
    public static final ProductVersion MIN_HOST_SUPPORTED_VERSION = new ProductVersion("5.0.0");
    static final Logger log = LoggerFactory.getLogger(InventoryScanner.class);

    public static String extractHostSslThumbprint(HostSystem host) throws InterruptedException, ExecutionException {
        BlockingFuture fSummary = new BlockingFuture();
        host.getSummary((Future)fSummary);
        Summary hostSummary = (Summary)fSummary.get();
        String hostThumbprint = hostSummary.getConfig().getSslThumbprint();
        return hostThumbprint;
    }

    public static ManagedObjectReference[] retrieveAllHosts(VcService vcService) throws InterruptedException, ExecutionException {
        ServiceInstanceContent sic = vcService.getServiceInstanceContent();
        ManagedObjectReference vmMoRef = sic.getViewManager();
        ViewManager viewManager = (ViewManager)vcService.getManagedObject(vmMoRef);
        BlockingFuture fContainerView = new BlockingFuture();
        VmodlTypeImpl hostSystemType = new VmodlTypeImpl(HostSystem.class, VmodlContext.getContext());
        TypeNameImpl hostSystemTypeName = new TypeNameImpl((VmodlType)hostSystemType);
        viewManager.createContainerView(sic.getRootFolder(), new TypeName[]{hostSystemTypeName}, true, (Future)fContainerView);
        ManagedObjectReference containerViewMO = (ManagedObjectReference)fContainerView.get();
        ContainerView containerView = (ContainerView)vcService.getManagedObject(containerViewMO);
        BlockingFuture fhostSystemsMORefs = new BlockingFuture();
        containerView.getView((Future)fhostSystemsMORefs);
        ManagedObjectReference[] hostSystemsMORefs = (ManagedObjectReference[])fhostSystemsMORefs.get();
        return hostSystemsMORefs;
    }

    public static VirtualNic[] getHostManagementInterfaces(HostSystem host, VcService localVcServerView) {
        HostNetworkHelper hostHelper = new HostNetworkHelper(host, localVcServerView);
        VirtualNic[] result = hostHelper.usesServiceConsole() ? hostHelper.getServiceConsoleNics() : hostHelper.getManagmentNetworkNics();
        return result;
    }

    public static ProductVersion getHostVersion(HostSystem host) {
        ConfigInfo config = host.getConfig();
        AboutInfo about = config.getProduct();
        ProductVersion version = new ProductVersion(about.getVersion());
        return version;
    }

    public static boolean isHostSupported(HostSystem host) {
        ProductVersion version = InventoryScanner.getHostVersion(host);
        boolean result = MIN_HOST_SUPPORTED_VERSION.compareTo(version) <= 0;
        return result;
    }

    private static class HostNetworkHelper {
        private final VirtualNicManager vNicManager;
        private final NetCapabilities netCapabilities;
        private final NetworkInfo networkInfo;

        public HostNetworkHelper(HostSystem host, VcService vcService) {
            ConfigManager configManager = host.getConfigManager();
            ManagedObjectReference virtualNicMoRef = configManager.getVirtualNicManager();
            this.vNicManager = (VirtualNicManager)vcService.getManagedObject(virtualNicMoRef);
            ManagedObjectReference netSystemMoRef = configManager.getNetworkSystem();
            NetworkSystem netSystem = (NetworkSystem)vcService.getManagedObject(netSystemMoRef);
            this.netCapabilities = netSystem.getCapabilities();
            ConfigInfo info = host.getConfig();
            this.networkInfo = info.getNetwork();
        }

        @Nullable
        public VirtualNic[] getManagmentNetworkNics() {
            VirtualNic[] result = null;
            try {
                String[] selectedNics;
                VirtualNic[] candidateNics;
                VirtualNicManager.NetConfig netConfig = this.vNicManager.queryNetConfig(VirtualNicManager.NicType.management.toString());
                if (netConfig == null) {
                    candidateNics = null;
                    selectedNics = null;
                } else {
                    candidateNics = netConfig.getCandidateVnic();
                    selectedNics = netConfig.getSelectedVnic();
                }
                if (candidateNics == null || selectedNics == null) {
                    result = null;
                } else {
                    result = new VirtualNic[selectedNics.length];
                    for (int i = 0; i < selectedNics.length; ++i) {
                        for (VirtualNic nic : candidateNics) {
                            if (!selectedNics[i].equals(nic.getKey())) continue;
                            result[i] = nic;
                            break;
                        }
                        assert (result[i] != null);
                    }
                }
            }
            catch (HostConfigFault e) {
                String msg = "Failed querying network configuration of the host.";
                log.error(msg, (Throwable)e);
            }
            return result;
        }

        public boolean usesServiceConsole() {
            return this.netCapabilities.isUsesServiceConsoleNic();
        }

        public VirtualNic[] getServiceConsoleNics() {
            return this.networkInfo.getConsoleVnic();
        }
    }
}

