/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection.file;

import com.vmware.ph.exceptions.Exceptions;
import com.vmware.vsphere.telemetry.cmc.exceptions.system.DataValidationException;
import com.vmware.vsphere.telemetry.cmc.exceptions.system.PersistenceException;
import com.vmware.vsphere.telemetry.cmc.exceptions.system.ReadFailed;
import com.vmware.vsphere.telemetry.cmc.exceptions.system.WriteFailed;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.lang.Validate;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonSerializer {
    public static final String JSON_SUFFIX = ".json";
    private static final Logger log = LoggerFactory.getLogger(JacksonSerializer.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final ObjectWriter writer = this.mapper.writerWithDefaultPrettyPrinter();
    private static final Object bug987186 = new Object();

    public File getPersistenceFilename(String key, File fFolder) {
        File resultFile = new File(fFolder.getPath() + File.separator + key + JSON_SUFFIX);
        return resultFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void writeObject(String key, File folder, T oValue) throws PersistenceException, IllegalArgumentException {
        Validate.notNull((Object)key, (String)"key");
        Validate.notNull((Object)folder, (String)"folder");
        Validate.isTrue((folder.isDirectory() || folder.mkdirs() ? 1 : 0) != 0, (String)("Failed ensuring folder " + folder + " exists."));
        Validate.notNull((Object)key, (String)"key");
        String msg = "Error reading object with key '" + key + "' to folder '" + folder + "'. Object = " + oValue;
        try {
            Object object = bug987186;
            synchronized (object) {
                File resultFile = this.getPersistenceFilename(key, folder);
                if (oValue == null) {
                    if (resultFile.exists()) {
                        Files.delete(resultFile.toPath());
                    }
                } else {
                    File resultFileTmp = File.createTempFile(resultFile.getName(), null, resultFile.getParentFile());
                    FileOutputStream out = new FileOutputStream(resultFileTmp);
                    this.writeValue(out, oValue);
                    Files.move(resultFileTmp.toPath(), resultFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
                }
            }
        }
        catch (JsonProcessingException e) {
            log.error(msg, (Throwable)e);
            Exceptions.logAsErrorAndThrow((Logger)log, (String)msg, (Throwable)new DataValidationException(msg, e));
        }
        catch (IOException e) {
            log.error(msg, (Throwable)e);
            Exceptions.logAsErrorAndThrow((Logger)log, (String)msg, (Throwable)new WriteFailed(msg, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(String key, File folder, Class<T> clazz) throws PersistenceException, IllegalArgumentException {
        Validate.notNull((Object)key, (String)"key");
        Validate.notNull((Object)folder, (String)"folder");
        Validate.notNull(clazz, (String)"clazz");
        T res = null;
        String msg = "Error reading object with key '" + key + "' from folder '" + folder + "'.";
        try {
            File f = this.getPersistenceFilename(key, folder);
            Object object = bug987186;
            synchronized (object) {
                if (f.exists()) {
                    if (f.isFile()) {
                        FileInputStream in = new FileInputStream(f);
                        res = this.readValue(in, clazz);
                    } else {
                        String message = msg + " Not a file: " + f.getAbsolutePath();
                        Exceptions.logAsErrorAndThrow((Logger)log, (String)message, (Throwable)new IllegalArgumentException(message));
                    }
                } else {
                    log.debug("{} does not exist. No problem. Returnning null.", (Object)f.getAbsolutePath());
                }
            }
        }
        catch (JsonProcessingException e) {
            log.error(msg, (Throwable)e);
            Exceptions.logAsErrorAndThrow((Logger)log, (String)msg, (Throwable)new DataValidationException(msg, e));
        }
        catch (IOException e) {
            log.error(msg, (Throwable)e);
            Exceptions.logAsErrorAndThrow((Logger)log, (String)msg, (Throwable)new ReadFailed(msg, e));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readValue(InputStream in, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        Object object = bug987186;
        synchronized (object) {
            return (T)this.mapper.readValue(in, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeValue(OutputStream out, Object oValue) throws JsonGenerationException, JsonMappingException, IOException {
        Object object = bug987186;
        synchronized (object) {
            this.writer.writeValue(out, oValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readValue(String in, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        Object object = bug987186;
        synchronized (object) {
            return (T)this.mapper.readValue(in, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeValue(Object oValue) throws JsonGenerationException, JsonMappingException, IOException {
        Object object = bug987186;
        synchronized (object) {
            String res = this.writer.writeValueAsString(oValue);
            return res;
        }
    }
}

