/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection.file;

import com.vmware.vise.store.InvalidArgumentException;
import com.vmware.vsphere.telemetry.cmc.collection.file.FileUtilsMisc;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannerCleaner {
    private static final Logger log = LoggerFactory.getLogger(ScannerCleaner.class);
    private final String alertWord;

    public ScannerCleaner(String alertWord) {
        this.alertWord = alertWord;
    }

    public void clean(File textFile) throws IOException {
        if (!textFile.isFile()) {
            log.debug("Ignoring missing file {}", (Object)textFile.getAbsolutePath());
            return;
        }
        try {
            this.scanFile(textFile);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFile(File textFile) throws IOException, IllegalAccessException, InvalidArgumentException {
        File tempFile = new File(textFile.getCanonicalPath() + ".tmp");
        try {
            this.copyNonMatchingLines(textFile, tempFile);
            FileUtils.forceDelete((File)textFile);
            FileUtilsMisc.moveFile(tempFile, textFile);
        }
        finally {
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyNonMatchingLines(File textFile, File tempFile) throws IOException, IllegalAccessException {
        BufferedReader br = null;
        Writer out = null;
        try {
            br = this.makeReader(textFile);
            out = this.makeWriter(tempFile);
            String nextLine = br.readLine();
            while (nextLine != null) {
                if (!nextLine.contains(this.alertWord)) {
                    out.write(nextLine);
                    out.write(10);
                } else {
                    log.debug("Removed sensitive line from {}", (Object)textFile);
                }
                nextLine = br.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Reader)br);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)br);
        IOUtils.closeQuietly((Writer)out);
    }

    private BufferedReader makeReader(File textFile) throws IOException {
        FileInputStream stream = new FileInputStream(textFile);
        InputStreamReader reader = new InputStreamReader((InputStream)stream, "UTF-8");
        return new BufferedReader(reader);
    }

    private Writer makeWriter(File outputFile) throws IOException {
        FileOutputStream stream = new FileOutputStream(outputFile);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
        return new BufferedWriter(writer);
    }
}

