/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection.file;

import com.vmware.ph.exceptions.Exceptions;
import com.vmware.vsphere.telemetry.cmc.collection.file.AbstractTrustStrategy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.lang.Validate;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SingleHostTrustStrategy
extends AbstractTrustStrategy
implements TrustStrategy,
X509HostnameVerifier {
    private static final Logger log = LoggerFactory.getLogger(SingleHostTrustStrategy.class);
    private final X509Certificate hostCertificate;
    private final X509HostnameVerifier hostnameChecker;

    public SingleHostTrustStrategy(byte[] certificate, String accessUrl) throws CertificateException, MalformedURLException {
        Validate.notNull((Object)certificate, (String)"certificate");
        Validate.notNull((Object)accessUrl, (String)"accessUrl");
        URL url = new URL(accessUrl);
        this.hostName = url.getHost();
        Validate.notNull((Object)this.hostName, (String)"hostName");
        if (!"https".equals(url.getProtocol())) {
            throw new IllegalArgumentException("You cannot use a TrustStrategy for non-https URLs, the URL was " + accessUrl);
        }
        this.hostCertificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificate));
        Validate.notNull((Object)this.hostCertificate, (String)"hostCertificate");
        this.hostnameChecker = new X509HostnameVerifier(){

            public boolean verify(String hostname, SSLSession session) {
                return true;
            }

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            }

            public void verify(String host, X509Certificate cert) throws SSLException {
            }

            public void verify(String host, SSLSocket ssl) throws IOException {
            }
        };
        Validate.notNull((Object)this.hostnameChecker, (String)"hostnameChecker");
        this.trustedCertificates = Collections.singletonList(this.hostCertificate);
    }

    public boolean verify(String hostname, SSLSession session) {
        try {
            this.verifyHostName(hostname);
            return true;
        }
        catch (SSLException e) {
            log.error("Hostname verification for host " + hostname + " FAILED.", (Throwable)e);
            return false;
        }
    }

    public void verify(String host, SSLSocket ssl) throws IOException {
        this.verifyHostName(host);
    }

    private void checkHostNames(String hostName) throws SSLException {
        this.hostnameChecker.verify(hostName, this.hostCertificate);
    }

    private void verifyHostName(String host) throws SSLException {
        try {
            this.checkHostNames(host);
            log.trace("Host name verification for host '{}' succeeded.", (Object)host);
        }
        catch (SSLException e) {
            log.warn("Host name verification for host '" + host + "' failed. The hostname is illegal for certificate " + this.hostCertificate + ", (in a subsequent step will try finding and matching a cannonical/DNS name for this host). ", (Throwable)e);
            try {
                log.trace("Searching for the cannonical (aka DNS, FQDN) name of host {} ...", (Object)host);
                InetAddress inteAddress = InetAddress.getByName(host);
                String canonicalHostName = inteAddress.getCanonicalHostName();
                if (canonicalHostName != null) {
                    log.trace("Found FQDN {} for host {}. Trying hostname validation using the FQDN .... ", (Object)canonicalHostName, (Object)host);
                    this.checkHostNames(canonicalHostName);
                } else {
                    String message = "Cannot obtain FQDN for host " + host + ", SSL verification FAILED";
                    Exceptions.logAsErrorAndThrow((Logger)log, (String)message, (Throwable)new SSLException(message));
                }
                log.trace("Host name verification for host " + host + " succeeded with FQDN '" + canonicalHostName + "'.");
            }
            catch (UnknownHostException e1) {
                String message = "Cannot obtain FQDN for host " + host + ", SSL verification FAILED";
                Exceptions.logAsErrorAndThrow((Logger)log, (String)message, (Throwable)new SSLException(message));
            }
            catch (SSLException e2) {
                String message = "Cannot validate FQDN for host " + host + ", SSL verification FAILED against certificate " + this.hostCertificate;
                Exceptions.logAsErrorAndThrow((Logger)log, (String)message, (Throwable)new SSLException(message, e2));
            }
        }
    }

    public void verify(String host, X509Certificate cert) throws SSLException {
        this.verifyHostName(host);
    }

    public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
        log.trace("trying to verify host '" + host + "' against certificate " + this.hostCertificate + "' with Common Names " + Arrays.toString(cns) + " and Subject alternative names " + Arrays.toString(subjectAlts));
        try {
            this.checkHostNames(host);
            log.trace("Hostname verification for host " + host + " succeeded.");
            return;
        }
        catch (SSLException e) {
            log.warn("Hostname verification for host " + host + " against certificate " + this.hostCertificate + " FAILED, trying to verify using common names " + Arrays.toString(cns), (Throwable)e);
            if (cns != null) {
                for (String cn : cns) {
                    try {
                        this.checkHostNames(cn);
                        log.trace("Hostname verification for host " + host + " succeeded with common name " + cn);
                        return;
                    }
                    catch (SSLException e2) {
                        log.warn("Hostname verification for host " + host + " against certificate " + this.hostCertificate + " FAILED for common name " + cn + " continue with other names", (Throwable)e2);
                    }
                }
            }
            log.warn("Trying to verify host " + host + " using subject alternative names " + Arrays.toString(subjectAlts));
            if (subjectAlts != null) {
                for (String subjectAlternativeName : subjectAlts) {
                    try {
                        this.checkHostNames(subjectAlternativeName);
                        log.trace("Hostname verification for host " + host + " succeeded with subject alternative name " + subjectAlternativeName);
                        return;
                    }
                    catch (SSLException e3) {
                        log.warn("Hostname verification for host " + host + " against certificate " + this.hostCertificate + " FAILED for subject alternative name " + subjectAlternativeName + " continue with other names", (Throwable)e3);
                    }
                }
            }
            String message = "Host name '" + host + "' cannot be ferified against certificate " + this.hostCertificate + "' and neither of the Common Names " + Arrays.toString(cns) + " nor Subject alternative names " + Arrays.toString(subjectAlts) + " can be ferified.";
            Exceptions.logAsErrorAndThrow((Logger)log, (String)message, (Throwable)new SSLException(message));
            return;
        }
    }
}

