/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection.file;

import com.vmware.ph.exceptions.Exceptions;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.telemetry.cmc.collection.file.JacksonSerializer;
import com.vmware.vsphere.telemetry.cmc.collection.file.VcServerView;
import com.vmware.vsphere.telemetry.cmc.exceptions.system.PersistenceException;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcCollector {
    public static final Logger log = LoggerFactory.getLogger(VcCollector.class);

    public void writeVcAboutInfoTo(File workingFolder, VcService vcService) throws PersistenceException, IllegalArgumentException {
        Exceptions.traceEntering((Logger)log);
        ServiceInstanceContent sic = vcService.getServiceInstanceContent();
        AboutInfo about = sic.getAbout();
        about.setDynamicType(null);
        about.setDynamicProperty(null);
        new JacksonSerializer().writeObject(AboutInfo.class.getSimpleName(), workingFolder, about);
        Exceptions.traceExiting((Logger)log);
    }

    public void collect(VcService vcService, File workingFolder) {
        this.writeVcAboutInfoTo(workingFolder, vcService);
    }

    private static final class VmodlFieldList {
        private final String[] arrFieldsAsSoapXml;
        private final String fieldType;
        private final String vimVmodlVersionUsedByVlsiXmlSerialization;

        public VmodlFieldList(String vimVmodlVersionUsedByVlsiXmlSerialization, Class<? extends DataObject> fieldType, String[] arrFieldsAsSoapXml) {
            String n;
            VmodlType vmodlType;
            this.vimVmodlVersionUsedByVlsiXmlSerialization = vimVmodlVersionUsedByVlsiXmlSerialization;
            this.arrFieldsAsSoapXml = arrFieldsAsSoapXml;
            String wsdlName = fieldType.getName();
            VmodlTypeMap typeMap = VmodlTypeMap.Factory.getTypeMap();
            if (null != typeMap && null != (vmodlType = typeMap.getVmodlType(fieldType)) && null != (n = vmodlType.getWsdlName())) {
                wsdlName = n;
            }
            this.fieldType = wsdlName;
        }

        public String[] getArrFieldsAsSoapXml() {
            return this.arrFieldsAsSoapXml;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public String getVimVmodlVersionUsedByVlsiXmlSerialization() {
            return this.vimVmodlVersionUsedByVlsiXmlSerialization;
        }

        public static void writeFieldsAsJson(List<String> listFieldsAsXml, Class<? extends DataObject> fieldClass, File workingFolder) throws PersistenceException, IllegalArgumentException {
            VmodlVersion ver = VcServerView.getTheVimVmodlVersionWeUse();
            String versionId = ver.getVersionId();
            String[] arr = listFieldsAsXml.toArray(new String[0]);
            VmodlFieldList oValue = new VmodlFieldList(versionId, fieldClass, arr);
            JacksonSerializer js = new JacksonSerializer();
            js.writeObject(fieldClass.getSimpleName(), workingFolder, oValue);
        }
    }
}

