/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection.file;

import com.vmware.vise.data.query.DataService;
import com.vmware.vise.store.InvalidArgumentException;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.telemetry.cmc.CollectedFile;
import com.vmware.vsphere.telemetry.cmc.FileCollector;
import com.vmware.vsphere.telemetry.cmc.ManifestUtils;
import com.vmware.vsphere.telemetry.cmc.StorageUtils;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.collection.file.EsxCollector;
import com.vmware.vsphere.telemetry.cmc.collection.file.FileLayout;
import com.vmware.vsphere.telemetry.cmc.collection.file.FileUtilsMisc;
import com.vmware.vsphere.telemetry.cmc.collection.file.VcCollector;
import com.vmware.vsphere.telemetry.cmc.collection.file.VsphereFileCollectorStatistics;
import com.vmware.vsphere.telemetry.cmc.compress.Tar;
import com.vmware.vsphere.telemetry.cmc.compress.Zip;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VsphereFileCollector
implements FileCollector {
    private static final String DEV_ESXCFG_INFO_DOWNLOAD_URL = "dev.esxcfg_info.download_url";
    private static final String TRUE_VALUE = "true";
    private static final String ENABLED_NODE_NAME = "enabled";
    private static final String FILE_COLLECTOR_NODE_NAME = "fileCollector";
    private static final Logger log = LoggerFactory.getLogger(VsphereFileCollector.class);
    private static final String STAGING_DIRECTORY_NAME = "vmware-datacollector";
    private final EsxCollector esxCollector;
    private final VcCollector vcCollector;
    private final ConfigurationService configurationService;

    public VsphereFileCollector(ConfigurationService configurationService) {
        this.configurationService = configurationService;
        this.esxCollector = new EsxCollector();
        this.vcCollector = new VcCollector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Iterable<CollectedFile> collect(Document manifest, DataService dataService, VcService vcService, Context context) {
        try {
            if (!this.isEnabledCollector(manifest)) {
                log.info("File collector is disabled in the manifest: skip this collection.");
                return Collections.emptyList();
            }
        }
        catch (Exception e) {
            log.error("Exception was thrown on attempt to parse the manifest.", (Throwable)e);
            return this.prepareFatalErrorResult(e);
        }
        File stagingDirectory = this.getStagingDirectory();
        FileLayout fileLayout = new FileLayout();
        File collectionRootFolder = fileLayout.generateCollectionFolderName(stagingDirectory);
        File readyToUploadFolder = fileLayout.getReadyToUploadFolder(collectionRootFolder);
        File workingFolder = fileLayout.getWorkingFolderForCollection(collectionRootFolder);
        try {
            this.prepareDirectoryStructure(stagingDirectory, collectionRootFolder, readyToUploadFolder, workingFolder);
        }
        catch (IOException e) {
            log.error("Failed to initialize working directories, aborting vSphere file collection.", (Throwable)e);
            return this.prepareFatalErrorResult(e);
        }
        VsphereFileCollectorStatistics stats = new VsphereFileCollectorStatistics();
        File statsFile = fileLayout.getPerformanceStatsFile(collectionRootFolder);
        stats.appendTextToFile(statsFile, String.format("collectionId\t%s", context.get("global-collectionId")));
        this.addSystemStats(stats, statsFile);
        try {
            File tarFile;
            Throwable nonFatalCollectionError;
            block24: {
                block23: {
                    File workingFolderForThisVc = fileLayout.getWorkingFolderForThisVc(collectionRootFolder);
                    nonFatalCollectionError = null;
                    try {
                        this.collectVcData(vcService, readyToUploadFolder, stats, statsFile, workingFolderForThisVc);
                    }
                    catch (Exception e) {
                        log.error("Exception occurred while collecting data from VC.", (Throwable)e);
                        nonFatalCollectionError = e;
                    }
                    try {
                        this.collectEsxData(vcService, collectionRootFolder, stats, statsFile);
                    }
                    catch (Exception e) {
                        log.error("Exception occurred while collecting data from ESX servers.", (Throwable)e);
                        if (nonFatalCollectionError != null) break block23;
                        nonFatalCollectionError = e;
                    }
                }
                try {
                    FileUtilsMisc.moveFileToDirectory(statsFile, readyToUploadFolder);
                }
                catch (IOException e) {
                    log.error("Unable to move file {} to directory {}.", (Object)statsFile, (Object)readyToUploadFolder);
                    if (nonFatalCollectionError == null) {
                        nonFatalCollectionError = e;
                    }
                }
                catch (InvalidArgumentException e) {
                    log.error("Unable to move file {} to directory {}.", (Object)statsFile, (Object)readyToUploadFolder);
                    if (nonFatalCollectionError != null) break block24;
                    nonFatalCollectionError = e;
                }
            }
            try {
                tarFile = this.createTarFile(readyToUploadFolder);
            }
            catch (FileNotFoundException e) {
                log.error("Exception occurred while creating tar file.", (Throwable)e);
                Iterable<CollectedFile> iterable = this.prepareFatalErrorResult(e);
                FileUtilsMisc.deleteFileQuietly(fileLayout.getWorkingFolderForCollection(collectionRootFolder));
                return iterable;
            }
            catch (IOException e) {
                log.error("Exception occurred while creating tar file.", (Throwable)e);
                Iterable<CollectedFile> iterable = this.prepareFatalErrorResult(e);
                FileUtilsMisc.deleteFileQuietly(fileLayout.getWorkingFolderForCollection(collectionRootFolder));
                return iterable;
            }
            if (tarFile != null) {
                log.debug("vSphere file collection completed.");
                Iterable<CollectedFile> iterable = this.prepareResult(tarFile, (Exception)nonFatalCollectionError);
                return iterable;
            }
            log.warn("vSphere file collection completed with no files in upload directory.");
            Iterable<CollectedFile> iterable = this.prepareResult(null, (Exception)nonFatalCollectionError);
            return iterable;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            FileUtilsMisc.deleteFileQuietly(fileLayout.getWorkingFolderForCollection(collectionRootFolder));
        }
    }

    private Iterable<CollectedFile> prepareFatalErrorResult(Exception fatalError) {
        return Collections.singleton(((CollectedFile.Builder)new CollectedFile.Builder().setFile(null).setFatalError(fatalError)).build());
    }

    private Iterable<CollectedFile> prepareResult(File file, Exception nonFatalError) {
        CollectedFile.Builder cfb = new CollectedFile.Builder().setFile(file);
        if (nonFatalError != null) {
            cfb.setError(nonFatalError, false);
        }
        return Collections.singleton(cfb.build());
    }

    private void prepareDirectoryStructure(File stagingDirectory, File collectionRootFolder, File readyToUploadFolder, File workingFolder) throws IOException {
        if (!stagingDirectory.exists()) {
            FileUtils.forceMkdir((File)stagingDirectory);
        } else if (!stagingDirectory.isDirectory()) {
            throw new RuntimeException(String.format("Staging directory %s exists and it is not directory. Aborting file collection.", stagingDirectory));
        }
        FileUtils.cleanDirectory((File)stagingDirectory);
        FileUtils.forceMkdir((File)collectionRootFolder);
        FileUtils.forceMkdir((File)readyToUploadFolder);
        FileUtils.forceMkdir((File)workingFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectEsxData(VcService vcService, File collectionRootFolder, VsphereFileCollectorStatistics stats, File statsFile) {
        this.esxCollector.setDevEsxCfgInfoDownloadUrl(this.initializeDevEsxCfgInfoUrl());
        try {
            log.info("....    Collecting ESX data.");
            stats.appendTextToFile(statsFile, "esxAllCollectionStart\t" + System.currentTimeMillis());
            this.esxCollector.collectFromAllHosts(vcService, collectionRootFolder);
            log.info("Completed Collecting ESX data.");
        }
        finally {
            stats.appendTextToFile(statsFile, "esxAllCollectionEnd\t" + System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectVcData(VcService vcService, File readyToUploadFolder, VsphereFileCollectorStatistics stats, File statsFile, File workingFolderForThisVc) throws IOException {
        try {
            log.info("....   Collecting VC data.");
            stats.appendTextToFile(statsFile, "vcCollectionStart\t" + System.currentTimeMillis());
            this.vcCollector.collect(vcService, workingFolderForThisVc);
            log.info("....   Collecting VC data completed successfully.");
            this.zipVcDataToTheUploadFolder(workingFolderForThisVc, readyToUploadFolder);
        }
        finally {
            stats.appendTextToFile(statsFile, "vcCollectionEnd\t" + System.currentTimeMillis());
        }
    }

    private File getStagingDirectory() {
        File rootDir = new File(StorageUtils.getStorageDirectory());
        File stagingDirectory = new File(rootDir, STAGING_DIRECTORY_NAME);
        stagingDirectory.mkdirs();
        return stagingDirectory;
    }

    private void addSystemStats(VsphereFileCollectorStatistics stats, File statsFile) {
        log.debug("adding system stats to statistics file, started");
        stats.appendTextToFile(statsFile, "machineTimeAndTimeZone\t" + System.currentTimeMillis() + "\t" + new Date());
        stats.appendTextToFile(statsFile, "JvmUpTime\t" + ManagementFactory.getRuntimeMXBean().getUptime());
        stats.appendTextToFile(statsFile, "os.name\t" + System.getProperty("os.name"));
        stats.appendTextToFile(statsFile, "os.arch\t" + System.getProperty("os.arch"));
        stats.appendTextToFile(statsFile, "os.version\t" + System.getProperty("os.version"));
        stats.appendTextToFile(statsFile, "java.vm.version\t" + System.getProperty("java.vm.version"));
        stats.appendTextToFile(statsFile, "java.vm.vendor\t" + System.getProperty("java.vm.vendor"));
        stats.appendTextToFile(statsFile, "user.language\t" + System.getProperty("user.language"));
        log.debug("adding system stats to statistics file, completed.");
    }

    private void zipVcDataToTheUploadFolder(File workingFolderForThisVc, File readyToUploadFolder) throws IOException {
        Zip.zip(workingFolderForThisVc, new File(readyToUploadFolder, "vc.zip"), false);
    }

    private boolean isEnabledCollector(Document manifest) {
        Element fileCollectorElement = ManifestUtils.findOptionalElement(manifest, FILE_COLLECTOR_NODE_NAME);
        if (fileCollectorElement == null) {
            log.warn("The manifest does not contain {} element.", (Object)FILE_COLLECTOR_NODE_NAME);
            return false;
        }
        NodeList nodeList = fileCollectorElement.getElementsByTagNameNS("", ENABLED_NODE_NAME);
        if (nodeList.getLength() == 0) {
            log.warn("The {} element does not contain {} element.", (Object)FILE_COLLECTOR_NODE_NAME, (Object)ENABLED_NODE_NAME);
            return false;
        }
        if (nodeList.item(0).getNodeType() == 1) {
            Element enabledElement = (Element)nodeList.item(0);
            String value = enabledElement.getTextContent();
            log.debug("Found a {} element with value {}.", (Object)ENABLED_NODE_NAME, (Object)value);
            return value != null && TRUE_VALUE.equals(value);
        }
        log.warn("First element with name {} is not of type ELEMENT_NODE.", (Object)ENABLED_NODE_NAME);
        return false;
    }

    private File createTarFile(File workingFolder) throws FileNotFoundException, IOException {
        Collection listFiles = FileUtils.listFiles((File)workingFolder, null, (boolean)true);
        if (listFiles.isEmpty()) {
            log.warn("There's nothing to upload. Moving on ...");
            return null;
        }
        Tar tar = new Tar(listFiles);
        File destination = new File(workingFolder.getAbsolutePath() + ".tar");
        tar.createBundle(destination);
        return destination;
    }

    private String initializeDevEsxCfgInfoUrl() {
        String value = this.configurationService.getProperty(DEV_ESXCFG_INFO_DOWNLOAD_URL);
        if (value == null) {
            return "";
        }
        try {
            new URL(value);
            return value;
        }
        catch (MalformedURLException e) {
            return "";
        }
    }
}

