/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.compress;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArchiveExtractor {
    protected static final Logger log = LoggerFactory.getLogger(AbstractArchiveExtractor.class);
    protected final File fileToDecompress;

    public AbstractArchiveExtractor(File fileToDecompress) {
        this.fileToDecompress = fileToDecompress;
    }

    protected void validateFolderLocationExists(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            log.trace("Folder " + dir.getAbsolutePath() + " alredy exists.");
        } else if (dir.mkdirs()) {
            log.trace("Created folder " + dir.getAbsolutePath());
        } else {
            throw new RuntimeException("Cannot create folder " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Destination folder " + dir.getAbsolutePath() + " must be a directory.");
        }
    }

    protected void ensureParentExists(File file) {
        File destinationParent = file.getParentFile();
        if (!destinationParent.exists()) {
            destinationParent.mkdirs();
        }
    }

    protected void readWriteStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
    }

    public abstract void extractToFolder(File var1) throws IOException;

    public void extractToFolder(String folderPath) throws IOException {
        this.extractToFolder(new File(folderPath));
    }
}

