/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.compress;

import com.vmware.ph.exceptions.Exceptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tar {
    protected static final Logger log = LoggerFactory.getLogger((String)(".compress." + Tar.class.getSimpleName()));
    private final List<File> filesToBundle;

    public Tar(File ... filesToBundle) {
        Validate.notNull((Object)filesToBundle, (String)"filesToBundle");
        this.filesToBundle = new ArrayList<File>(filesToBundle.length);
        for (File f : filesToBundle) {
            Validate.notNull((Object)f, (String)"file in the array of bundles");
            this.filesToBundle.add(f);
        }
    }

    public Tar(Collection<File> filesToBundle) {
        Validate.notNull(filesToBundle, (String)"filesToBundle");
        this.filesToBundle = new ArrayList<File>(filesToBundle.size());
        this.filesToBundle.addAll(filesToBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBundle(File destination) throws FileNotFoundException, IOException {
        Exceptions.traceEnteringWithInput((Logger)log, (String)destination.toString());
        if (destination.exists()) {
            throw new IllegalArgumentException("Cannot create tar bundle using destionation " + destination + ", it already exists, I refuse to overwrite it.");
        }
        try (TarArchiveOutputStream outputStream = null;){
            outputStream = new TarArchiveOutputStream((OutputStream)new FileOutputStream(destination));
            for (File fileToBundle : this.filesToBundle) {
                log.info("Bundling file " + fileToBundle + " to bundle " + destination);
                ArchiveEntry entry = outputStream.createArchiveEntry(fileToBundle, fileToBundle.getName());
                outputStream.putArchiveEntry(entry);
                FileInputStream input = null;
                try {
                    input = new FileInputStream(fileToBundle);
                    long bytesWritten = IOUtils.copy((InputStream)input, (OutputStream)outputStream);
                    outputStream.closeArchiveEntry();
                    log.trace("File " + fileToBundle + " bundled successfully, bytes written " + bytesWritten);
                }
                finally {
                    if (input == null) continue;
                    ((InputStream)input).close();
                }
            }
        }
        log.trace("Tar bundle " + destination + " created successfully, the total lenght of the bundle is " + destination.length());
    }

    public void createBundle(String destination) throws FileNotFoundException, IOException {
        this.createBundle(new File(destination));
    }
}

