/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.compress;

import com.vmware.vsphere.telemetry.cmc.compress.AbstractArchiveExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class UnTar
extends AbstractArchiveExtractor {
    public UnTar(File fileToDecompress) {
        super(fileToDecompress);
    }

    public UnTar(String filePath) {
        this(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractToFolder(File folder) throws IOException {
        log.trace("Extracting archive " + this.fileToDecompress.getAbsolutePath());
        this.validateFolderLocationExists(folder);
        try (TarArchiveInputStream tarInputStream = null;){
            tarInputStream = new TarArchiveInputStream((InputStream)new FileInputStream(this.fileToDecompress));
            TarArchiveEntry tarEntry = null;
            while ((tarEntry = tarInputStream.getNextTarEntry()) != null) {
                if (!tarEntry.isFile()) continue;
                log.trace("Extracting entry " + tarEntry.getName());
                File tarFile = new File(tarEntry.getName());
                File destination = new File(folder, tarFile.getPath());
                this.ensureParentExists(destination);
                try (FileOutputStream outputStream = new FileOutputStream(destination);){
                    this.readWriteStreams((InputStream)tarInputStream, outputStream);
                    outputStream.flush();
                    log.trace("File " + tarEntry.getName() + " extracted.");
                }
            }
        }
        log.trace("File " + this.fileToDecompress.getAbsolutePath() + " sucessfully extracted at " + folder.getAbsolutePath());
    }
}

