/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public final class Zip {
    public static final String ZIP_PATH_SEPARATOR = "/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File fileOrFolder, File zipOutputFile, boolean includeIfSourceIsFolder) throws IOException {
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            File[] allFiles;
            File[] fileArray;
            fos = new FileOutputStream(zipOutputFile);
            zos = new ZipOutputStream(fos);
            if (fileOrFolder.isFile() || includeIfSourceIsFolder) {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = fileOrFolder;
            } else {
                fileArray = allFiles = fileOrFolder.listFiles();
            }
            if (allFiles != null) {
                for (File f : allFiles) {
                    Zip.doZip(f, f.getName(), zos);
                }
            }
        }
        finally {
            if (zos != null) {
                zos.close();
            } else if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doZip(File file, String name, ZipOutputStream zos) throws IOException {
        block5: {
            block4: {
                if (!file.isDirectory()) break block4;
                File[] files = file.listFiles();
                if (files == null) break block5;
                for (File f : files) {
                    String childName = name + ZIP_PATH_SEPARATOR + f.getName();
                    Zip.doZip(f, childName, zos);
                }
                break block5;
            }
            try (FileInputStream fis = new FileInputStream(file);){
                ZipEntry entry = new ZipEntry(name);
                zos.putNextEntry(entry);
                IOUtils.copy((InputStream)fis, (OutputStream)zos);
            }
        }
    }
}

