/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.impl;

import com.vmware.ph.client.api.impl.PhClientBuilder;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vsphere.telemetry.cmc.PhEnvironmentProvider;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebClientPropertiesEnvironmentProvider
implements PhEnvironmentProvider {
    private static final Logger logger = LoggerFactory.getLogger(WebClientPropertiesEnvironmentProvider.class);
    static final String PROP_CMC_TARGET_ENVIRONMENT = "cmc.target_environment";
    private final ConfigurationService _configurationService;

    public WebClientPropertiesEnvironmentProvider(ConfigurationService configurationService) {
        this._configurationService = configurationService;
    }

    @Override
    public PhClientBuilder.Environment getEnvironment() {
        String targetEnvironment = this._configurationService.getProperty(PROP_CMC_TARGET_ENVIRONMENT);
        logger.debug("targetEnvironment read from configurationService is: {}", (Object)targetEnvironment);
        PhClientBuilder.Environment result = PhClientBuilder.Environment.PRODUCTION;
        if (StringUtils.isNotBlank((String)targetEnvironment)) {
            targetEnvironment = targetEnvironment.toUpperCase();
            try {
                result = PhClientBuilder.Environment.valueOf((String)targetEnvironment);
            }
            catch (IllegalArgumentException e) {
                logger.warn("Cannot convert string value '{}' to Environment enum, will default to {}.", (Object)targetEnvironment, (Object)result);
            }
        }
        logger.debug("environment to be used: {}", (Object)result);
        return result;
    }
}

