/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.request;

import com.vmware.ph.exceptions.Bug;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vsphere.telemetry.cmc.InvalidManifestException;
import com.vmware.vsphere.telemetry.cmc.request.QueryManifest;
import com.vmware.vsphere.telemetry.cmc.request.RequestManifest;
import com.vmware.vsphere.telemetry.cmc.request.RequestSpecParser;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Node;

public final class JaxbRequestSpecParser
implements RequestSpecParser {
    @Override
    public RequestSpec parse(Node xmlNode) throws InvalidManifestException {
        JAXBElement parsedManifest;
        Unmarshaller parser;
        Validate.notNull((Object)xmlNode, (String)"An xmlNode is required.");
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RequestManifest.class});
            parser = context.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new Bug("Internal error: failed to create JAXB Unmarshaller for manifest parsing.", (Throwable)e);
        }
        try {
            parsedManifest = parser.unmarshal(xmlNode, RequestManifest.class);
        }
        catch (JAXBException e) {
            throw new InvalidManifestException("Failed to parse the request manifest: " + e.getMessage(), e);
        }
        RequestManifest manifest = (RequestManifest)parsedManifest.getValue();
        List<QueryManifest> queryManifests = manifest.getQueries();
        QuerySpec[] querySpecs = new QuerySpec[queryManifests.size()];
        for (int i = 0; i < queryManifests.size(); ++i) {
            QueryManifest queryManifest = queryManifests.get(i);
            this.validateManifestConstraint(queryManifest.getConstraint());
            QuerySpec querySpec = new QuerySpec();
            querySpec.name = queryManifest.getName();
            querySpec.resourceSpec = new ResourceSpec();
            querySpec.resourceSpec.constraint = queryManifest.getConstraint();
            querySpec.resourceSpec.propertySpecs = queryManifest.getPropertySpecs().toArray(new PropertySpec[queryManifest.getPropertySpecs().size()]);
            if (queryManifest.getMaxResultCount() != null) {
                querySpec.resultSpec = new ResultSpec();
                querySpec.resultSpec.maxResultCount = queryManifest.getMaxResultCount();
            }
            querySpecs[i] = querySpec;
        }
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecs;
        return requestSpec;
    }

    private void validateManifestConstraint(Constraint constraint) {
        if (constraint == null) {
            throw new InvalidManifestException("Invalid query: no constraint defined.");
        }
        if (constraint.getClass().equals(Constraint.class)) {
            this.requireTargetType(constraint, "constraint");
        } else if (constraint instanceof PropertyConstraint) {
            String friendlyTypeName = PropertyConstraint.class.getSimpleName();
            this.requireTargetType(constraint, friendlyTypeName);
            PropertyConstraint propConstraint = (PropertyConstraint)constraint;
            this.requireField(friendlyTypeName, "propertyName", propConstraint.propertyName != null);
            this.requireField(friendlyTypeName, "comparator", propConstraint.comparator != null);
            this.requireField(friendlyTypeName, "comparableValue", propConstraint.comparableValue != null);
        } else if (constraint instanceof CompositeConstraint) {
            CompositeConstraint cc = (CompositeConstraint)constraint;
            String friendlyTypeName = CompositeConstraint.class.getSimpleName();
            this.requireField(friendlyTypeName, "conjoiner", cc.conjoiner != null);
            this.requireField(friendlyTypeName, "nestedConstraints", !ArrayUtils.isEmpty((Object[])cc.nestedConstraints));
            for (Constraint nested : cc.nestedConstraints) {
                this.validateManifestConstraint(nested);
            }
        }
    }

    private void requireTargetType(Constraint constraint, String friendlyConstraintType) {
        if (StringUtils.isEmpty((String)constraint.targetType)) {
            throw new InvalidManifestException("Invalid query: targetType is required for " + friendlyConstraintType);
        }
    }

    private void requireField(String constraintType, String fieldName, boolean isPresent) {
        if (!isPresent) {
            throw new InvalidManifestException(String.format("Invalid query: %s.%s field is required.", constraintType, fieldName));
        }
    }
}

