/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage;

import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.host.DatastoreBrowser;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.common.storage.FileSpec;
import com.vmware.vsphere.client.storage.util.DatastorePathUtil;

public class FilePropertyProvider
implements PropertyProviderBean {
    private TaskMonitor _taskMonitor;

    public FilePropertyProvider(TaskMonitor taskMonitor) {
        this._taskMonitor = taskMonitor;
    }

    @type(value="DatastoreBrowser,HostDatastoreBrowser,HostSystem,Datastore,VirtualMachine,ComputeResource,ClusterComputeResource")
    public OperationResult getFile(ManagedObjectReference moRef, FileSpec spec) throws Exception {
        EnvironmentBrowser envBrowser;
        ManagedObjectReference envBrowserRef;
        DatastorePathUtil.escapeDatastoreNameInFileSpec(spec);
        String errorMessage = null;
        ManagedObjectReference dsBrowserRef = null;
        OperationResult opResult = new OperationResult();
        opResult.entity = moRef;
        ManagedObject managedObject = ManagedObjectUtil.getManagedObject((ManagedObjectReference)moRef);
        if (managedObject instanceof DatastoreBrowser) {
            dsBrowserRef = moRef;
        } else if (managedObject instanceof HostSystem) {
            dsBrowserRef = ((HostSystem)managedObject).getDatastoreBrowser();
        } else if (managedObject instanceof Datastore) {
            dsBrowserRef = ((Datastore)managedObject).getBrowser();
        } else if (managedObject instanceof ComputeResource) {
            envBrowserRef = ((ComputeResource)managedObject).getEnvironmentBrowser();
            envBrowser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)envBrowserRef);
            dsBrowserRef = envBrowser.getDatastoreBrowser();
        } else if (managedObject instanceof VirtualMachine) {
            envBrowserRef = ((VirtualMachine)managedObject).getEnvironmentBrowser();
            envBrowser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)envBrowserRef);
            dsBrowserRef = envBrowser.getDatastoreBrowser();
        } else {
            errorMessage = ResourceUtil.getString((String)"StorageService", (String)"error.invalidManagedObject", (ClassLoader)this.getClass().getClassLoader());
            throw new IllegalArgumentException(errorMessage);
        }
        DatastoreBrowser dsBrowser = (DatastoreBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dsBrowserRef);
        try {
            ManagedObjectReference taskRef = null;
            taskRef = spec.subFolders ? dsBrowser.searchSubFolders(spec.datastorePath, spec.searchSpec) : dsBrowser.search(spec.datastorePath, spec.searchSpec);
            TaskInfo info = this._taskMonitor.monitorTask(taskRef);
            opResult.task = taskRef;
            DatastorePathUtil.unescapeDatastoreNameInSearchResults(info.result);
            opResult.result = info.result;
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }
}

