/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.VimVasaProviderInfo;
import com.vmware.vim.binding.vim.host.DatastoreSystem;
import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vim.binding.vim.host.MultipathInfo;
import com.vmware.vim.binding.vim.host.MultipathStateInfo;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.ScsiDisk;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vim.host.StorageSystem;
import com.vmware.vim.binding.vim.host.UnresolvedVmfsExtent;
import com.vmware.vim.binding.vim.host.UnresolvedVmfsVolume;
import com.vmware.vim.binding.vim.host.VmfsDatastoreExpandSpec;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import com.vmware.vim.binding.vim.host.VmfsDatastoreOption;
import com.vmware.vim.binding.vim.host.VvolDatastoreInfo;
import com.vmware.vim.binding.vim.host.VvolVolume;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.Version;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.common.util.ObjectNamesRetriever;
import com.vmware.vsphere.client.storage.DatastoreCreateOptionsQuerySpec;
import com.vmware.vsphere.client.storage.DatastoreFilePathsSpec;
import com.vmware.vsphere.client.storage.DatastoreIncreaseOptionsQuerySpec;
import com.vmware.vsphere.client.storage.DeviceMultipathingInfo;
import com.vmware.vsphere.client.storage.FileTransferEndpoint;
import com.vmware.vsphere.client.storage.ScsiDiskInfo;
import com.vmware.vsphere.client.storage.StorageDataService;
import com.vmware.vsphere.client.storage.VmfsExtentInfo;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;
import com.vmware.vsphere.client.storage.util.HostStoragePropertyCache;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;

public class DatastorePropertyProvider
implements PropertyProviderBean {
    private static final String NAME = "name";
    private static final String PARENT = "parent";
    private static final String DS_INFO_PROPERTY = "info";
    private static final String HOST_CONNECTION_STATE_PROPERTY = "runtime.connectionState";
    private static final String HOST_NAME_PROPERTY = "name";
    private static final String HOST_VERSION_PROPERTY = "config.product.version";
    private static final String HOST_MOUNT_PROPERTY = "hostMount";
    private static final String STORAGE_POD_RELATIONSHIP = "parentPod";
    private static final String SDRS_ENABLED_PROPERTY = "podStorageDrsEntry.storageDrsConfig.podConfig.enabled";
    private static final String DATASTORE_VMS_COUNT = "vm._length";
    private static final String DC_PATH_PARAM = "dcPath";
    private static final String DS_NAME_PARAM = "dsName";
    private static final String FOLDER_ENDPOINT = "/folder/";
    private static final String ESX_DATACENTER_NAME = "ha-datacenter";
    private static final String ESX_ENDPOINT_PROTOCOL = "https://";
    private static final Version VERSION_65 = new Version("6.5.0");
    private static final Pattern DATASTORE_PATH_PATTERN = Pattern.compile("^\\[(?<datastoreName>.*?)\\]\\s{0,1}/{0,1}(?<filePath>.*)");
    private static final String FILE_PATH_GROUP = "filePath";
    private static final String DEFAULT_DATASTORE_NAME = StorageUtil.getLocalizedString("datastore.defaultName");
    private static final String DATASTORE_TYPE = Datastore.class.getSimpleName();
    private static final Log _logger = LogFactory.getLog(DatastorePropertyProvider.class);
    private LegacyAuthorizationService _authorizationService;
    private DataService _dataService;
    private StorageDataService _storageDataService;

    public DatastorePropertyProvider(LegacyAuthorizationService authorizationService, DataService dataService, StorageDataService storageDataService) {
        this._authorizationService = authorizationService;
        this._dataService = dataService;
        this._storageDataService = storageDataService;
    }

    @type(value="Datastore")
    public ManagedObjectReference getConnectedHost(ManagedObjectReference dsRef) throws Exception {
        return this.getConnectedHostForDatastore(dsRef);
    }

    @type(value="Datastore")
    public VmfsDatastoreOption[] getVmfsDatastoreIncreaseOptions(ManagedObjectReference datastoreRef, DatastoreIncreaseOptionsQuerySpec spec) throws Exception {
        if (datastoreRef == null) {
            _logger.error((Object)"getVmfsDatastoreIncreaseOptions: datastoreRef can't be null.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidDatastore"));
        }
        DatastorePropertyProvider.validateDatastoreIncreaseOptionsQuerySpec(spec);
        DatastoreSystem datastoreSystem = this._storageDataService.getHostDatastoreSystem(spec.host);
        if (datastoreSystem == null) {
            _logger.error((Object)"Failed to retrieve host's DatastoreSystem.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        if (spec.scsiDiskInfo.expandable) {
            VmfsDatastoreOption[] expandOptions = DatastorePropertyProvider.getExpandAndExtendOptions(datastoreRef, datastoreSystem, spec);
            return expandOptions;
        }
        VmfsDatastoreOption[] extendOptions = datastoreSystem.queryVmfsDatastoreExtendOptions(datastoreRef, spec.scsiDiskInfo.disk.devicePath, Boolean.valueOf(false));
        return extendOptions;
    }

    @type(value="HostSystem")
    public VmfsDatastoreOption[] getVmfsDatastoreCreateOptions(ManagedObjectReference hostRef, DatastoreCreateOptionsQuerySpec spec) throws Exception {
        DatastorePropertyProvider.validateDatastoreCreateOptionsQuerySpec(spec);
        DatastoreSystem datastoreSystem = this._storageDataService.getHostDatastoreSystem(hostRef);
        if (datastoreSystem == null) {
            _logger.error((Object)"getVmfsDatastoreCreateOptions: Failed to retrieve host's datastoreSystem");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        VmfsDatastoreOption[] options = datastoreSystem.queryVmfsDatastoreCreateOptions(spec.scsiDiskInfo.disk.devicePath, Integer.valueOf(spec.vmfsMajorVersion));
        return options;
    }

    @type(value="Datastore")
    public long getSharesValue(ManagedObjectReference datastoreRef) throws Exception {
        if (datastoreRef == null) {
            _logger.error((Object)"datastoreRef can't be null.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidDatastore"));
        }
        Constraint dsVmsConstraint = QueryUtil.createConstraintForRelationship((Object)datastoreRef, (String)"vm", (String)"VirtualMachine");
        QuerySpec dsVirtualDisksQuery = QueryUtil.buildQuerySpec((Constraint)dsVmsConstraint, (String[])new String[]{"virtualDisks"});
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)dsVirtualDisksQuery);
        if (resultSet.items.length == 0) {
            return 0L;
        }
        long dsShares = 0L;
        for (ResultItem resItem : resultSet.items) {
            VirtualDisk[] vDisks;
            if (resItem.properties[0].value == null) continue;
            for (VirtualDisk vDisk : vDisks = (VirtualDisk[])resItem.properties[0].value) {
                if (!(vDisk.backing instanceof VirtualDevice.FileBackingInfo)) continue;
                VirtualDevice.FileBackingInfo fileBacking = (VirtualDevice.FileBackingInfo)vDisk.backing;
                if (!ManagedObjectUtil.areEqual((ManagedObjectReference)fileBacking.datastore, (ManagedObjectReference)datastoreRef).booleanValue()) continue;
                if (vDisk.storageIOAllocation == null) {
                    if (vDisk.shares == null) continue;
                    dsShares += (long)vDisk.shares.shares;
                    continue;
                }
                if (vDisk.storageIOAllocation.shares == null) continue;
                dsShares += (long)vDisk.storageIOAllocation.shares.shares;
            }
        }
        return dsShares;
    }

    @type(value="Datastore")
    public double getDeviceModelIntercept(ManagedObjectReference datastoreRef) throws Exception {
        StorageResourceManager srm;
        StorageResourceManager.IORMDeviceModel iormModel;
        double intercept = 0.0;
        if (this.isVC51orLater(datastoreRef.getServerGuid()) && (iormModel = (srm = StorageUtil.getStorageManager(datastoreRef)).GetStorageIORMDeviceModel(datastoreRef)) != null) {
            intercept = iormModel.lqIntercept;
        }
        return intercept;
    }

    @type(value="HostSystem")
    public ScsiDiskInfo[] getAvailableDisksForVmfs(ManagedObjectReference hostRef, ManagedObjectReference datastoreRef) throws Exception {
        DatastoreSystem datastoreSystem = this._storageDataService.getHostDatastoreSystem(hostRef);
        if (datastoreSystem == null) {
            _logger.error((Object)"getAvailableDisksForVmfs: Failed to retrieve host's datastoreSystem.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
        StorageDeviceInfo deviceInfo = this._storageDataService.getHostStorageDeviceInfo(hostRef);
        if (deviceInfo == null) {
            _logger.error((Object)"Failed to retrieve host's StorageDeviceInfo.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        ScsiDisk[] disks = datastoreSystem.queryAvailableDisksForVmfs(datastoreRef);
        ScsiDiskInfo[] diskInfos = DatastorePropertyProvider.createScsiDiskInfos(disks, deviceInfo);
        if (datastoreRef == null) {
            DatastorePropertyProvider.populateUnresolvedVmfsVolumeInfo(diskInfos, storageSystem);
        } else {
            DatastorePropertyProvider.populateExpandableProperties(datastoreRef, diskInfos, datastoreSystem);
        }
        return diskInfos;
    }

    @type(value="HostSystem")
    public DeviceMultipathingInfo getDeviceMultipathingInfo(ManagedObjectReference hostRef, String deviceCanonicalName) throws Exception {
        if (hostRef == null) {
            _logger.error((Object)"getDeviceMultipathingInfo: hostRef can't be null.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidHost"));
        }
        if (deviceCanonicalName == null || deviceCanonicalName.length() == 0) {
            _logger.error((Object)"getDeviceMultipathingInfo: invalid deviceCanonicalName.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidArgument"));
        }
        HostSystem.ConnectionState hostConnectionState = (HostSystem.ConnectionState)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)HOST_CONNECTION_STATE_PROPERTY);
        if (hostConnectionState != HostSystem.ConnectionState.connected) {
            _logger.warn((Object)"getDeviceMultipathingInfo:Host is disconnected.");
            return null;
        }
        StorageDeviceInfo sdi = this._storageDataService.getHostStorageDeviceInfo(hostRef);
        if (sdi == null) {
            _logger.error((Object)"getDeviceMultipathingInfo:Failed to retrieve host's StorageDeviceInfo.");
            return null;
        }
        MultipathStateInfo msi = this._storageDataService.getHostMultipathStateInfo(hostRef);
        if (msi == null) {
            _logger.error((Object)"getDeviceMultipathingInfo:Failed to retrieve host's MultipathStateInfo.");
            return null;
        }
        HostStoragePropertyCache cache = new HostStoragePropertyCache(sdi, msi);
        return DatastorePropertyProvider.getDeviceMultipathingInfoInternal(cache, deviceCanonicalName);
    }

    @type(value="HostSystem")
    public DeviceMultipathingInfo[] getExtentsMultipathingInfo(ManagedObjectReference hostRef, ManagedObjectReference datastoreRef) throws Exception {
        if (hostRef == null) {
            _logger.error((Object)"getExtentsMultipathingInfo: hostRef can't be null.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidHost"));
        }
        if (datastoreRef == null) {
            _logger.error((Object)"getExtentsMultipathingInfo: datastoreRef can't be null.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidDatastore"));
        }
        Datastore.Info dsInfo = (Datastore.Info)QueryUtil.getProperty((DataService)this._dataService, (Object)datastoreRef, (String)DS_INFO_PROPERTY);
        if (!(dsInfo instanceof VmfsDatastoreInfo)) {
            _logger.error((Object)"getExtentsMultipathingInfo: datastore is not VMFS.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.dsIsNotVMFS"));
        }
        HostSystem.ConnectionState hostConnectionState = (HostSystem.ConnectionState)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)HOST_CONNECTION_STATE_PROPERTY);
        if (hostConnectionState != HostSystem.ConnectionState.connected) {
            return new DeviceMultipathingInfo[0];
        }
        StorageDeviceInfo sdi = this._storageDataService.getHostStorageDeviceInfo(hostRef);
        if (sdi == null) {
            _logger.error((Object)"getExtentsMultipathingInfo:Failed to retrieve host's StorageDeviceInfo.");
            return new DeviceMultipathingInfo[0];
        }
        MultipathStateInfo msi = this._storageDataService.getHostMultipathStateInfo(hostRef);
        if (msi == null) {
            _logger.error((Object)"getExtentsMultipathingInfo:Failed to retrieve host's MultipathStateInfo.");
            return new DeviceMultipathingInfo[0];
        }
        HostStoragePropertyCache cache = new HostStoragePropertyCache(sdi, msi);
        return DatastorePropertyProvider.getExtentsMultipathingInfoInternal((VmfsDatastoreInfo)dsInfo, cache);
    }

    private static DeviceMultipathingInfo[] getExtentsMultipathingInfoInternal(VmfsDatastoreInfo vmfsInfo, HostStoragePropertyCache cache) {
        if (vmfsInfo.vmfs == null || vmfsInfo.vmfs.extent == null || vmfsInfo.vmfs.extent.length == 0) {
            return new DeviceMultipathingInfo[0];
        }
        DeviceMultipathingInfo[] deviceInfos = new DeviceMultipathingInfo[vmfsInfo.vmfs.extent.length];
        for (int i = 0; i < deviceInfos.length; ++i) {
            deviceInfos[i] = DatastorePropertyProvider.getDeviceMultipathingInfoInternal(cache, vmfsInfo.vmfs.extent[i].diskName);
        }
        return deviceInfos;
    }

    private static DeviceMultipathingInfo getDeviceMultipathingInfoInternal(HostStoragePropertyCache cache, String deviceCanonicalName) {
        for (ScsiLun scsiLun : cache.storageDeviceInfo.scsiLun) {
            if (!deviceCanonicalName.equals(scsiLun.canonicalName)) continue;
            DeviceMultipathingInfo deviceInfo = new DeviceMultipathingInfo();
            deviceInfo.deviceDisplayName = scsiLun.displayName;
            deviceInfo.canonicalName = scsiLun.canonicalName;
            MultipathInfo.LogicalUnit logicalUnit = cache.lunLogicalUnits.get(scsiLun.key);
            if (logicalUnit != null) {
                deviceInfo.logicalUnitId = logicalUnit.id;
                deviceInfo.pathSelectionPolicy = logicalUnit.policy;
                deviceInfo.storageArrayTypePolicy = logicalUnit.storageArrayTypePolicy;
            }
            deviceInfo.ownerPlugin = StorageUtil.getLunPluginName(cache, scsiLun);
            PlugStoreTopology.Device device = cache.lunDevices.get(scsiLun.key);
            if (device.path == null) {
                deviceInfo.paths = new StoragePathData[0];
            } else {
                PlugStoreTopology.Plugin[] pstPluginsArray = cache.pstPlugins.values().toArray(new PlugStoreTopology.Plugin[cache.pstPlugins.size()]);
                ArrayList<StoragePathData> paths = new ArrayList<StoragePathData>();
                for (int pathIndex = 0; pathIndex < device.path.length; ++pathIndex) {
                    if (StorageUtil.isPathMasked(device.path[pathIndex], pstPluginsArray)) continue;
                    paths.add(StorageUtil.buildStoragePathData(device.path[pathIndex], cache));
                }
                deviceInfo.paths = paths.toArray(new StoragePathData[paths.size()]);
            }
            return deviceInfo;
        }
        return null;
    }

    @type(value="Datastore")
    public VmfsExtentInfo[] getVmfsDatastoreExtents(ManagedObjectReference datastoreRef) throws Exception {
        if (datastoreRef == null) {
            _logger.error((Object)"getVmfsDatastoreExtents: datastoreRef can't be null.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidDatastore"));
        }
        Datastore.Info dsInfo = (Datastore.Info)QueryUtil.getProperty((DataService)this._dataService, (Object)datastoreRef, (String)DS_INFO_PROPERTY);
        if (!(dsInfo instanceof VmfsDatastoreInfo)) {
            _logger.error((Object)"getVmfsDatastoreExtents: datastore is not VMFS.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidDatastore"));
        }
        ManagedObjectReference hostRef = this.getConnectedHost(datastoreRef);
        if (hostRef == null) {
            return new VmfsExtentInfo[0];
        }
        return this.getDatastoreExtentsInternal((VmfsDatastoreInfo)dsInfo, hostRef);
    }

    @type(value="Datastore")
    public boolean getShouldWarnOnDatastoreEnterMaintenanceMode(ManagedObjectReference datastoreRef) throws Exception {
        Integer vmCount;
        if (datastoreRef == null) {
            _logger.error((Object)"getShouldWarnOnDatastoreEnterMaintenanceMode : datastoreRef can't be null.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidDatastore"));
        }
        boolean isSDRSDisabled = false;
        PropertyValue[] sdrsEnabledPV = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)datastoreRef, (String)STORAGE_POD_RELATIONSHIP, (String)StoragePod.class.getSimpleName(), (String)SDRS_ENABLED_PROPERTY);
        if (sdrsEnabledPV != null && sdrsEnabledPV.length > 0) {
            isSDRSDisabled = (Boolean)sdrsEnabledPV[0].value == false;
        }
        boolean vmsFound = false;
        if (isSDRSDisabled && (vmCount = (Integer)QueryUtil.getProperty((DataService)this._dataService, (Object)datastoreRef, (String)DATASTORE_VMS_COUNT)) > 0) {
            vmsFound = true;
        }
        return isSDRSDisabled && vmsFound;
    }

    @type(value="Datastore")
    public String getVvolStorageProvider(ManagedObjectReference datastoreRef) throws Exception {
        if (datastoreRef == null) {
            _logger.error((Object)"getVvolStorageProvider: datastoreRef can't be null.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidDatastore"));
        }
        Datastore.Info dsInfo = (Datastore.Info)QueryUtil.getProperty((DataService)this._dataService, (Object)datastoreRef, (String)DS_INFO_PROPERTY);
        if (!(dsInfo instanceof VvolDatastoreInfo)) {
            _logger.error((Object)"getVvolStorageProvider: datastore is not VVOL.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidDatastoreType"));
        }
        String vVolSPName = StorageUtil.getVvolDeviceName(((VvolDatastoreInfo)dsInfo).vvolDS);
        return vVolSPName;
    }

    @type(value="Datastore")
    public VimVasaProviderInfo[] getDatastoreStorageProvidersData(ManagedObjectReference datastoreRef) throws Exception {
        if (datastoreRef == null) {
            _logger.error((Object)"getDatastoreStorageProvidersData: datastoreRef can't be null.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidDatastore"));
        }
        Datastore.Info dsInfo = (Datastore.Info)QueryUtil.getProperty((DataService)this._dataService, (Object)datastoreRef, (String)DS_INFO_PROPERTY);
        if (dsInfo == null || !(dsInfo instanceof VvolDatastoreInfo)) {
            _logger.error((Object)"getDatastoreStorageProvidersData: datastore is not VVOL.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidDatastoreType"));
        }
        VvolVolume vvolDS = ((VvolDatastoreInfo)dsInfo).vvolDS;
        if (vvolDS != null && vvolDS.vasaProviderInfo != null) {
            VimVasaProviderInfo[] providers = vvolDS.vasaProviderInfo;
            return providers;
        }
        return new VimVasaProviderInfo[0];
    }

    private VmfsExtentInfo[] getDatastoreExtentsInternal(VmfsDatastoreInfo vmfsInfo, ManagedObjectReference hostRef) throws Exception {
        if (vmfsInfo.vmfs == null || vmfsInfo.vmfs.extent == null || vmfsInfo.vmfs.extent.length == 0) {
            return new VmfsExtentInfo[0];
        }
        StorageDeviceInfo storageDeviceInfo = this._storageDataService.getHostStorageDeviceInfo(hostRef);
        if (storageDeviceInfo == null) {
            return new VmfsExtentInfo[0];
        }
        VmfsExtentInfo[] extents = new VmfsExtentInfo[vmfsInfo.vmfs.extent.length];
        String[] devicePaths = new String[extents.length];
        block0: for (int i = 0; i < extents.length; ++i) {
            extents[i] = new VmfsExtentInfo();
            extents[i].extentPartition = vmfsInfo.vmfs.extent[i];
            for (ScsiLun scsiLun : storageDeviceInfo.scsiLun) {
                if (!extents[i].extentPartition.diskName.equals(scsiLun.canonicalName)) continue;
                extents[i].deviceDisplayName = scsiLun.displayName;
                devicePaths[i] = ((ScsiDisk)scsiLun).devicePath;
                continue block0;
            }
        }
        StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
        DiskPartitionInfo[] partitionInfos = storageSystem.retrieveDiskPartitionInfo(devicePaths);
        for (int i = 0; i < extents.length; ++i) {
            extents[i].partitionInfo = partitionInfos[i];
        }
        return extents;
    }

    private static void validateDatastoreCreateOptionsQuerySpec(DatastoreCreateOptionsQuerySpec spec) {
        if (spec == null) {
            _logger.error((Object)"Invalid argument - DatastoreCreateOptionsQuerySpec");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidArgument"));
        }
        if (spec.scsiDiskInfo == null) {
            _logger.error((Object)"Invalid argument - DatastoreCreateOptionsQuerySpec.scsiDiskInfo");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidArgument"));
        }
    }

    private static void validateDatastoreIncreaseOptionsQuerySpec(DatastoreIncreaseOptionsQuerySpec spec) {
        if (spec == null) {
            _logger.error((Object)"Invalid argument - DatastoreIncreaseOptionsQuerySpec");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidArgument"));
        }
        if (spec.host == null) {
            _logger.error((Object)"Invalid argument - DatastoreIncreaseOptionsQuerySpec.host");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidArgument"));
        }
        if (spec.scsiDiskInfo == null) {
            _logger.error((Object)"Invalid argument - DatastoreIncreaseOptionsQuerySpec.scsiDiskInfo");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidArgument"));
        }
    }

    private static VmfsDatastoreOption[] getExpandAndExtendOptions(ManagedObjectReference datastoreRef, DatastoreSystem datastoreSystem, DatastoreIncreaseOptionsQuerySpec spec) throws Exception {
        ArrayList<VmfsDatastoreOption> options = DatastorePropertyProvider.filterExpandOptionByDevice(spec.scsiDiskInfo.disk, datastoreSystem.queryVmfsDatastoreExpandOptions(datastoreRef));
        VmfsDatastoreOption[] extendOptions = datastoreSystem.queryVmfsDatastoreExtendOptions(datastoreRef, spec.scsiDiskInfo.disk.devicePath, Boolean.valueOf(true));
        if (options.size() != 0) {
            if (extendOptions != null) {
                for (VmfsDatastoreOption extendOption : extendOptions) {
                    options.add(extendOption);
                }
            }
            return options.toArray(new VmfsDatastoreOption[0]);
        }
        return extendOptions;
    }

    private static ArrayList<VmfsDatastoreOption> filterExpandOptionByDevice(ScsiDisk disk, VmfsDatastoreOption[] options) {
        ArrayList<VmfsDatastoreOption> filteredOptions = new ArrayList<VmfsDatastoreOption>();
        for (VmfsDatastoreOption vmfsOption : options) {
            if (!DatastorePropertyProvider.isVmfsExpandOptionForDevice(vmfsOption, disk)) continue;
            filteredOptions.add(vmfsOption);
        }
        return filteredOptions;
    }

    private static boolean isVmfsExpandOptionForDevice(VmfsDatastoreOption vmfsOption, ScsiDisk scsiDisk) {
        if (vmfsOption != null && scsiDisk != null && vmfsOption.spec instanceof VmfsDatastoreExpandSpec) {
            return ((VmfsDatastoreExpandSpec)vmfsOption.spec).extent.diskName.equals(scsiDisk.canonicalName);
        }
        return false;
    }

    private static void populateUnresolvedVmfsVolumeInfo(ScsiDiskInfo[] diskInfos, StorageSystem storageSystem) {
        UnresolvedVmfsVolume[] unresolvedVolumes = storageSystem.queryUnresolvedVmfsVolume();
        if (unresolvedVolumes == null || unresolvedVolumes.length == 0) {
            return;
        }
        for (UnresolvedVmfsVolume unresolvedVolume : unresolvedVolumes) {
            block1: for (UnresolvedVmfsExtent unresolvedVmfsExtent : unresolvedVolume.extent) {
                String extentPath = unresolvedVmfsExtent.devicePath;
                int lastColon = unresolvedVmfsExtent.devicePath.lastIndexOf(58);
                if (lastColon != -1) {
                    extentPath = extentPath.substring(0, lastColon);
                }
                for (ScsiDiskInfo diskInfo : diskInfos) {
                    if (!diskInfo.disk.devicePath.equals(extentPath)) continue;
                    if (diskInfo.unresolvedExtent != null && diskInfo.unresolvedExtent.isHeadExtent) continue block1;
                    diskInfo.vmfsLabel = unresolvedVolume.vmfsLabel;
                    diskInfo.unresolvedExtent = unresolvedVmfsExtent;
                    diskInfo.resolveStatus = unresolvedVolume.resolveStatus;
                    diskInfo.volumeSignature = unresolvedVolume.vmfsUuid;
                    continue block1;
                }
            }
        }
    }

    private static void populateExpandableProperties(ManagedObjectReference datastoreRef, ScsiDiskInfo[] diskInfos, DatastoreSystem datastoreSystem) throws Exception {
        if (!StorageUtil.isVmfsExtentExpansionSupported(datastoreSystem)) {
            return;
        }
        VmfsDatastoreOption[] expandOptions = datastoreSystem.queryVmfsDatastoreExpandOptions(datastoreRef);
        if (expandOptions == null || expandOptions.length == 0) {
            return;
        }
        for (VmfsDatastoreOption vmfsOption : expandOptions) {
            for (ScsiDiskInfo diskInfo : diskInfos) {
                if (!DatastorePropertyProvider.isVmfsExpandOptionForDevice(vmfsOption, diskInfo.disk)) continue;
                diskInfo.expandable = true;
            }
        }
    }

    private static ScsiDiskInfo[] createScsiDiskInfos(ScsiDisk[] disks, StorageDeviceInfo deviceInfo) {
        if (disks == null) {
            return new ScsiDiskInfo[0];
        }
        ScsiDiskInfo[] result = new ScsiDiskInfo[disks.length];
        for (int i = 0; i < disks.length; ++i) {
            result[i] = new ScsiDiskInfo();
            result[i].disk = disks[i];
            result[i].lun = StorageUtil.getDiskLunNumber(deviceInfo, disks[i].canonicalName);
            result[i].expandable = false;
        }
        return result;
    }

    private boolean isVC51orLater(String serverGuid) {
        try {
            VcService service = VimSessionUtil.getService((String)serverGuid);
            Version version = new Version(service.getServiceVersion());
            return version.compareTo(new Version("5.1.0")) >= 0;
        }
        catch (Exception exception) {
            _logger.error((Object)"[DatastorePropertyProvider failed in determining VC version]", (Throwable)exception);
            return false;
        }
    }

    @type(value="Folder,Datacenter,HostSystem,ComputeResource")
    public String getNewUniqueDatastoreName(ManagedObjectReference context) {
        ArrayList<String> existingNames = this.getAllDatastoreNames(context);
        String newUniqueDatastoreName = StringUtil.getIndexedString(existingNames, (String)DEFAULT_DATASTORE_NAME, (String)" ");
        return newUniqueDatastoreName;
    }

    private ArrayList<String> getAllDatastoreNames(ManagedObjectReference context) {
        ArrayList existingNames = null;
        try {
            existingNames = ObjectNamesRetriever.getNamesOfAllObjectsWithinDatacenter((DataService)this._dataService, (ManagedObjectReference)context, (String)DATASTORE_TYPE, (String)DEFAULT_DATASTORE_NAME);
        }
        catch (Exception e) {
            _logger.error((Object)e);
        }
        return existingNames;
    }

    private ManagedObjectReference getConnectedHostForDatastore(ManagedObjectReference datastore) throws Exception {
        ManagedObjectReference result = null;
        Datastore.HostMount[] hostMounts = (Datastore.HostMount[])QueryUtil.getProperty((DataService)this._dataService, (Object)datastore, (String)HOST_MOUNT_PROPERTY);
        if (hostMounts == null) {
            return result;
        }
        for (Datastore.HostMount hostMount : hostMounts) {
            if (hostMount == null || !StorageUtil.isHostConnected(hostMount.key).booleanValue() || !this._authorizationService.checkPrivileges(new ManagedObjectReference[]{hostMount.key}, new String[]{"Host.Config.Storage"}) || hostMount.mountInfo.mounted != null && !hostMount.mountInfo.mounted.booleanValue()) continue;
            result = hostMount.key;
            DatastoreSystem datastoreSystem = this._storageDataService.getHostDatastoreSystem(hostMount.key);
            if (!StorageUtil.isVmfsExtentExpansionSupported(datastoreSystem)) continue;
            return result;
        }
        return result;
    }

    @type(value="Datastore")
    public String[] getFilesUrls(ManagedObjectReference datastore, DatastoreFilePathsSpec fileSpec) throws Exception {
        ArrayList<String> fileUrls = new ArrayList<String>();
        String vcServiceUrl = this.getServiceUrl(datastore.getServerGuid());
        String datacenterPath = this.getInventoryPath(fileSpec.datacenter);
        String datastoreName = this.getDatastoreName(datastore);
        for (String datastorePath : fileSpec.datastorePaths) {
            String filePath = DatastorePropertyProvider.getFilePath(datastorePath);
            String fileUrl = DatastorePropertyProvider.createFileUrl(vcServiceUrl, datacenterPath, datastoreName, filePath);
            fileUrls.add(fileUrl);
        }
        return fileUrls.toArray(new String[fileUrls.size()]);
    }

    @type(value="Datastore")
    public FileTransferEndpoint[] getFileTransferEndpoints(ManagedObjectReference datastore, DatastoreFilePathsSpec fileSpec) throws Exception {
        ArrayList<FileTransferEndpoint> endpoints = new ArrayList<FileTransferEndpoint>();
        PropertyValue[] propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object)datastore, (String[])new String[]{"name", HOST_MOUNT_PROPERTY});
        Datastore.HostMount[] hostMounts = null;
        String datastoreName = null;
        for (PropertyValue propertyValue : propertyValues) {
            if ("name".equals(propertyValue.propertyName)) {
                datastoreName = (String)propertyValue.value;
                continue;
            }
            if (!HOST_MOUNT_PROPERTY.equals(propertyValue.propertyName)) continue;
            hostMounts = (Datastore.HostMount[])propertyValue.value;
        }
        if (ArrayUtil.isNullOrEmpty(hostMounts) || datastoreName == null) {
            return null;
        }
        String hostName = this.getAccessibleConnectedHostName(hostMounts);
        if (hostName == null) {
            this.addProxyEndpoints(datastore, fileSpec, endpoints);
        } else {
            this.addEndpoints(datastore, fileSpec, hostName, datastoreName, endpoints);
        }
        return endpoints.toArray(new FileTransferEndpoint[endpoints.size()]);
    }

    private void addProxyEndpoints(ManagedObjectReference datastore, DatastoreFilePathsSpec fileSpec, List<FileTransferEndpoint> endpoints) throws Exception {
        String[] proxyUrls = this.getFilesUrls(datastore, fileSpec);
        if (proxyUrls == null) {
            return;
        }
        for (String proxyUrl : proxyUrls) {
            endpoints.add(new FileTransferEndpoint(proxyUrl, null));
        }
    }

    private void addEndpoints(ManagedObjectReference datastore, DatastoreFilePathsSpec fileSpec, String hostName, String datastoreName, List<FileTransferEndpoint> endpoints) throws URISyntaxException {
        for (String datastorePath : fileSpec.datastorePaths) {
            String filePath = DatastorePropertyProvider.getFilePath(datastorePath);
            String fileUrl = DatastorePropertyProvider.createFileUrl(ESX_ENDPOINT_PROTOCOL + hostName, ESX_DATACENTER_NAME, datastoreName, filePath);
            String ticket = this.requestTicket(fileUrl, datastore.getServerGuid());
            endpoints.add(new FileTransferEndpoint(fileUrl, ticket));
        }
    }

    private String requestTicket(String remoteURL, String serverUuid) {
        SessionManager.GenericServiceTicket ticket;
        try {
            ticket = VcServiceUtil.acquireGenericServiceTicket(null, (String)remoteURL, (String)serverUuid);
        }
        catch (Exception e) {
            _logger.error((Object)"Not able to acquire generic service ticket for the purpose of file transfer", (Throwable)e);
            return null;
        }
        return ticket != null ? ticket.getId() : null;
    }

    private String getAccessibleConnectedHostName(Datastore.HostMount[] hostMounts) throws Exception {
        Object[] accessibleHosts = this.getAccessibleHosts(hostMounts);
        if (ArrayUtil.isNullOrEmpty((Object[])accessibleHosts)) {
            return null;
        }
        return this.getConnectedHostName((ManagedObjectReference[])accessibleHosts);
    }

    private ManagedObjectReference[] getAccessibleHosts(Datastore.HostMount[] hostMounts) throws Exception {
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        for (Datastore.HostMount hostMount : hostMounts) {
            if (!hostMount.getMountInfo().accessible.booleanValue()) continue;
            result.add(hostMount.key);
        }
        return result.toArray(new ManagedObjectReference[result.size()]);
    }

    private String getConnectedHostName(ManagedObjectReference[] hosts) throws Exception {
        String[] propertyNames = new String[]{"name", HOST_VERSION_PROPERTY, HOST_CONNECTION_STATE_PROPERTY};
        PropertyValue[] propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object[])hosts, (String[])propertyNames);
        HashMap<ManagedObjectReference, HashMap<String, Object>> propertiesByHost = new HashMap<ManagedObjectReference, HashMap<String, Object>>();
        for (PropertyValue propertyValue : propertyValues) {
            ManagedObjectReference host = (ManagedObjectReference)propertyValue.resourceObject;
            HashMap<String, Object> properties = (HashMap<String, Object>)propertiesByHost.get(host);
            if (properties == null) {
                properties = new HashMap<String, Object>();
                propertiesByHost.put(host, properties);
            }
            properties.put(propertyValue.propertyName, propertyValue.value);
        }
        for (ManagedObjectReference host : propertiesByHost.keySet()) {
            Map properties = (Map)propertiesByHost.get(host);
            String hostVersion = (String)properties.get(HOST_VERSION_PROPERTY);
            HostSystem.ConnectionState hostConnectionState = (HostSystem.ConnectionState)properties.get(HOST_CONNECTION_STATE_PROPERTY);
            if (!this.isConnected(hostConnectionState) || !this.isDirectTransferSupported(hostVersion)) continue;
            return (String)properties.get("name");
        }
        return null;
    }

    private boolean isConnected(HostSystem.ConnectionState hostConnectionState) {
        return hostConnectionState == HostSystem.ConnectionState.connected;
    }

    private boolean isDirectTransferSupported(String esxVersion) {
        return new Version(esxVersion).compareTo(VERSION_65) >= 0;
    }

    private String getServiceUrl(String vcServiceGuid) {
        String vcServiceURL = VimSessionUtil.getService((String)vcServiceGuid).getServiceUrl();
        return vcServiceURL;
    }

    private String getInventoryPath(ManagedObjectReference entity) throws Exception {
        StringBuilder datacenterPath = new StringBuilder();
        PropertyValue[] propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object)entity, (String[])new String[]{"name", PARENT});
        String name = null;
        ManagedObjectReference parent = null;
        for (PropertyValue value : propertyValues) {
            if ("name".equals(value.propertyName) && value.value != null) {
                name = value.value.toString();
                continue;
            }
            if (!PARENT.equals(value.propertyName) || !(value.value instanceof ManagedObjectReference)) continue;
            parent = (ManagedObjectReference)value.value;
        }
        if (parent != null && !ManagedObjectUtil.isRootFolder(parent)) {
            datacenterPath.append(this.getInventoryPath(parent));
            datacenterPath.append("/");
        }
        datacenterPath.append(name);
        return datacenterPath.toString();
    }

    private String getDatastoreName(ManagedObjectReference datastore) throws Exception {
        String datastoreName = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)datastore, (String)"name");
        return datastoreName;
    }

    private static String getFilePath(String datastorePath) {
        String filePath = null;
        Matcher matcher = DATASTORE_PATH_PATTERN.matcher(datastorePath);
        if (matcher.matches()) {
            filePath = matcher.group(FILE_PATH_GROUP).trim();
        }
        return filePath;
    }

    private static String createFileUrl(String vcServiceUrl, String datacenterPath, String datastoreName, String filePath) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(vcServiceUrl);
        uriBuilder.setPath(FOLDER_ENDPOINT.concat(filePath));
        uriBuilder.setParameter(DC_PATH_PARAM, datacenterPath);
        uriBuilder.setParameter(DS_NAME_PARAM, datastoreName);
        return uriBuilder.toString();
    }
}

