/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.util;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.InternalServiceInstanceContent;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.VasaVvolManager;
import com.vmware.vim.binding.vim.VimVasaProviderInfo;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.DatastoreSystem;
import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vim.binding.vim.host.MultipathInfo;
import com.vmware.vim.binding.vim.host.MultipathStateInfo;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.RuntimeInfo;
import com.vmware.vim.binding.vim.host.ScsiDisk;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vim.host.VFlashManager;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import com.vmware.vim.binding.vim.host.VmfsDatastoreOption;
import com.vmware.vim.binding.vim.host.VmfsVolume;
import com.vmware.vim.binding.vim.host.VvolVolume;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.storage.DiagnosticPartitionType;
import com.vmware.vsphere.client.storage.adapters.PortGroupType;
import com.vmware.vsphere.client.storage.adapters.StorageDeviceTransport;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;
import com.vmware.vsphere.client.storage.util.HostStoragePropertyCache;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StorageUtil {
    public static final String DIAGNOSTIC_TYPE_SINGLE_HOST = "singleHost";
    public static final String DIAGNOSTIC_TYPE_MULTI_HOST = "multiHost";
    public static final String STORAGE_TYPE_DIRECT_ATTACHED = "directAttached";
    public static final String STORAGE_TYPE_NETWORK_ATTACHED = "networkAttached";
    public static final String STORAGE_MGR_CONFIGURE_SIOC_TASK_NAME = "ConfigureDatastoreIORM_Task";
    private static final String RESOURCE_BUNDLE_NAME = "StorageService";
    private static final Log _logger = LogFactory.getLog(StorageUtil.class);
    private static final long BLOCK_SIZE_DEFAULT = 512L;
    private static final int INVALID_LUN_NUMBER = -1;
    private static final String MASK_PATH_PLUGIN = "MASK_PATH";
    private static final int VMFS_5_VERSION = 5;

    public static Boolean isForceMountedVMFSDatastore(Datastore.Info dsInfo) {
        if (dsInfo != null && dsInfo instanceof VmfsDatastoreInfo) {
            return ((VmfsDatastoreInfo)dsInfo).vmfs.forceMountedInfo != null;
        }
        return false;
    }

    public static String getVmfsDatastoreUuid(Datastore.Info dsInfo) {
        if (dsInfo == null || !(dsInfo instanceof VmfsDatastoreInfo)) {
            return "";
        }
        VmfsDatastoreInfo vmfsDsInfo = (VmfsDatastoreInfo)dsInfo;
        if (vmfsDsInfo.vmfs != null) {
            return vmfsDsInfo.vmfs.uuid;
        }
        return "";
    }

    public static String getVmfsDeviceName(VmfsVolume vmfsVolume) {
        String deviceName = "";
        if (vmfsVolume.extent != null && vmfsVolume.extent.length > 0) {
            ScsiDisk.Partition primary = vmfsVolume.extent[0];
            deviceName = StorageUtil.getLocalizedString("deviceName.format", new String[]{primary.diskName, Integer.toString(primary.partition)});
        }
        return deviceName;
    }

    public static String getVvolDeviceName(VvolVolume vvolVolume) {
        String deviceName = null;
        if (vvolVolume != null) {
            VimVasaProviderInfo[] providersInfo = vvolVolume.vasaProviderInfo;
            deviceName = StorageUtil.getCurrentVendorProvider(providersInfo);
        }
        return deviceName;
    }

    private static String getCurrentVendorProvider(VimVasaProviderInfo[] providersInfo) {
        String currentVPName = null;
        if (ArrayUtil.isNullOrEmpty((Object[])providersInfo)) {
            _logger.error((Object)"getVendorProvider: the vendor providers list is null or empty.");
            return currentVPName;
        }
        for (VimVasaProviderInfo providerInfo : providersInfo) {
            if (providerInfo == null || providerInfo.arrayState == null || providerInfo.arrayState.length <= 0 || !providerInfo.arrayState[0].active) continue;
            currentVPName = providerInfo.provider.name;
            break;
        }
        return currentVPName;
    }

    public static VFlashManager getHostVFlashManager(ManagedObjectReference hostRef) throws Exception {
        HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
        ConfigManager cfgManager = host.getConfigManager();
        if (cfgManager == null) {
            _logger.error((Object)"getHostDatastoreSystem: failed to retrieve host's ConfigManager.");
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        ManagedObjectReference vFlashManagerRef = cfgManager.getVFlashManager();
        if (vFlashManagerRef == null) {
            return null;
        }
        return (VFlashManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vFlashManagerRef);
    }

    public static boolean isVmfsExtentExpansionSupported(DatastoreSystem datastoreSystem) {
        if (datastoreSystem != null) {
            try {
                DatastoreSystem.Capabilities datastoreSystemCapabilities = datastoreSystem.getCapabilities();
                if (datastoreSystemCapabilities != null) {
                    return datastoreSystemCapabilities.vmfsExtentExpansionSupported;
                }
            }
            catch (Exception ex) {
                _logger.error((Object)"Failed to retrieve datastoreSystem.capabilities: ", (Throwable)ex);
            }
        }
        return false;
    }

    public static Boolean isHostConnected(ManagedObjectReference hostRef) {
        HostSystem host = null;
        try {
            host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            return false;
        }
        RuntimeInfo runtime = host.getRuntime();
        if (runtime != null && runtime.getConnectionState() == HostSystem.ConnectionState.connected) {
            return true;
        }
        return false;
    }

    public static MethodFault getFault(String errorMsgKey) {
        String errorMsg = StorageUtil.getLocalizedString(errorMsgKey);
        IllegalArgumentException ex = new IllegalArgumentException(errorMsg);
        MethodFault fault = MixedUtil.getMethodFault((Throwable)ex);
        return fault;
    }

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)StorageUtil.class.getClassLoader());
    }

    public static String getLocalizedString(String key, String[] params) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (String[])params, (ClassLoader)StorageUtil.class.getClassLoader());
    }

    public static DiskPartitionInfo.BlockRange findBlockRange(long partitionIndex, DiskPartitionInfo.BlockRange[] ranges) {
        for (DiskPartitionInfo.BlockRange blockRange : ranges) {
            if (blockRange == null || blockRange.partition == null || (long)blockRange.partition.intValue() != partitionIndex) continue;
            return blockRange;
        }
        return null;
    }

    public static long getSizeOfBlockRange(DiskPartitionInfo.BlockRange blockRange) {
        long blockSize = 512L;
        if (blockRange.start.blockSize != 0) {
            blockSize = blockRange.start.blockSize;
        }
        long numberOfBlocks = StorageUtil.getNumberOfBlocks(blockRange);
        return numberOfBlocks * blockSize;
    }

    public static long getNumberOfBlocks(DiskPartitionInfo.BlockRange blockRange) {
        return blockRange.end.block - blockRange.start.block + 1L;
    }

    public static long getNumberOfBlocksForDatastore(long datastoreSize, long blockSize, long availableBlocks) {
        long result;
        if (blockSize == 0L) {
            blockSize = 512L;
        }
        if ((result = (long)Math.ceil((double)datastoreSize / (double)blockSize)) > availableBlocks) {
            result = availableBlocks;
        }
        return result;
    }

    public static long getEndBlockAddress(long startBlock, long numberOfBlocks) {
        return startBlock + numberOfBlocks - 1L;
    }

    public static DiskPartitionInfo.BlockRange[] getOptionInfoExtents(VmfsDatastoreOption.Info info) {
        if (info instanceof VmfsDatastoreOption.SingleExtentInfo) {
            return new DiskPartitionInfo.BlockRange[]{((VmfsDatastoreOption.SingleExtentInfo)info).vmfsExtent};
        }
        if (info instanceof VmfsDatastoreOption.MultipleExtentInfo) {
            return ((VmfsDatastoreOption.MultipleExtentInfo)info).vmfsExtent;
        }
        return new DiskPartitionInfo.BlockRange[0];
    }

    public static int getLunNumber(PlugStoreTopology.Device device, HashMap<String, PlugStoreTopology.Path> pstPaths) {
        int lunNumber = -1;
        if (device != null && device.path != null && device.path.length > 0) {
            PlugStoreTopology.Path devicePath = pstPaths.get(device.path[0]);
            if (devicePath.lunNumber != null) {
                lunNumber = devicePath.lunNumber;
            }
        }
        return lunNumber;
    }

    public static StorageDeviceTransport[] getTransportForDevice(PlugStoreTopology.Device device, HashMap<String, PlugStoreTopology.Path> pstPaths, HashMap<String, PlugStoreTopology.Target> pstTargets) {
        HashSet<StorageDeviceTransport> transports = new HashSet<StorageDeviceTransport>();
        if (device == null || device.path == null) {
            return new StorageDeviceTransport[0];
        }
        for (String pathStr : device.path) {
            PlugStoreTopology.Path path = pstPaths.get(pathStr);
            if (path.target == null) continue;
            PlugStoreTopology.Target target = pstTargets.get(path.target);
            if (target.transport == null) continue;
            transports.add(StorageDeviceTransport.getTransport(target));
        }
        StorageDeviceTransport[] result = new StorageDeviceTransport[transports.size()];
        return transports.toArray(result);
    }

    public static String getOwnerPluginForDevice(PlugStoreTopology.Device device, PlugStoreTopology pst) {
        for (PlugStoreTopology.Plugin plugin : pst.plugin) {
            if (plugin.device == null) continue;
            for (String pluginDeviceKey : plugin.device) {
                if (!pluginDeviceKey.equals(device.key)) continue;
                return plugin.name;
            }
        }
        return "";
    }

    public static String getLunPluginName(HostStoragePropertyCache cache, ScsiLun scsiLun) {
        for (PlugStoreTopology.Plugin plugin : cache.storageDeviceInfo.plugStoreTopology.plugin) {
            if (plugin.device == null) continue;
            for (String storageDeviceKey : plugin.device) {
                PlugStoreTopology.Device topologyDevice = cache.pstDevices.get(storageDeviceKey);
                if (topologyDevice == null || !topologyDevice.lun.equals(scsiLun.key)) continue;
                return plugin.name;
            }
        }
        return "";
    }

    public static MultipathInfo.LogicalUnit getMultiPathLogicalUnit(StorageDeviceInfo deviceInfo, String lunKey) {
        if (deviceInfo.multipathInfo == null) {
            return null;
        }
        for (MultipathInfo.LogicalUnit lu : deviceInfo.multipathInfo.lun) {
            if (!lu.lun.equals(lunKey)) continue;
            return lu;
        }
        return null;
    }

    public static StoragePathData buildStoragePathData(String pathKey, HostStoragePropertyCache cache) {
        MultipathInfo.Path nmpMultiPath;
        MultipathInfo.LogicalUnit lu = null;
        ScsiLun lun = null;
        PlugStoreTopology.Path path = cache.pstPaths.get(pathKey);
        if (path.device != null) {
            PlugStoreTopology.Device device = cache.pstDevices.get(path.device);
            lun = cache.luns.get(device.lun);
            lu = StorageUtil.getMultiPathLogicalUnit(cache.storageDeviceInfo, lun.key);
        }
        StoragePathData pathData = new StoragePathData();
        pathData.path = path;
        pathData.pathLun = lun;
        if (path.adapter != null) {
            PlugStoreTopology.Adapter pstAdapter = cache.pstAdapters.get(path.adapter);
            pathData.pathHba = cache.hostBusAdapters.get(pstAdapter.adapter);
        }
        pathData.pathTarget = cache.pstTargets.get(path.target);
        MultipathStateInfo.Path multiPath = cache.getMultipathStateInfo().get(path.name);
        if (multiPath != null) {
            pathData.pathState = multiPath.pathState;
        }
        if ((nmpMultiPath = StorageUtil.findNativeMultiPath(lu, path.name)) != null) {
            if (pathData.pathState == null) {
                pathData.pathState = nmpMultiPath.pathState;
            }
            pathData.isWorkingPath = nmpMultiPath.isWorkingPath;
        }
        return pathData;
    }

    public static MultipathInfo.Path findNativeMultiPath(MultipathInfo.LogicalUnit lu, String pathName) {
        MultipathInfo.Path nmpMultiPath = null;
        if (lu != null) {
            for (MultipathInfo.Path path : lu.path) {
                if (!path.name.equals(pathName)) continue;
                nmpMultiPath = path;
                break;
            }
        }
        return nmpMultiPath;
    }

    public static boolean isPathMasked(String path, PlugStoreTopology.Plugin[] pstPlugins) {
        for (PlugStoreTopology.Plugin plugin : pstPlugins) {
            if (!plugin.name.equals(MASK_PATH_PLUGIN) || plugin.claimedPath == null) continue;
            for (String maskedPath : plugin.claimedPath) {
                if (!path.equals(maskedPath)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getDiskLunNumber(StorageDeviceInfo deviceInfo, String diskCanonicalName) {
        ScsiLun diskLun = null;
        for (ScsiLun lun : deviceInfo.scsiLun) {
            if (!lun.canonicalName.equals(diskCanonicalName)) continue;
            diskLun = lun;
            break;
        }
        if (diskLun == null) {
            return -1;
        }
        String diskPathId = null;
        for (PlugStoreTopology.Device device : deviceInfo.plugStoreTopology.device) {
            if (!device.lun.equals(diskLun.key)) continue;
            if (device.path == null || device.path.length <= 0) break;
            diskPathId = device.path[0];
            break;
        }
        if (diskPathId == null) {
            return -1;
        }
        for (PlugStoreTopology.Device device : deviceInfo.plugStoreTopology.path) {
            if (!device.key.equals(diskPathId)) continue;
            return device.lunNumber;
        }
        return -1;
    }

    public static String getDiagnosticType(DiagnosticPartitionType partitionType) {
        switch (partitionType) {
            case privateLocal: 
            case privateLun: {
                return DIAGNOSTIC_TYPE_SINGLE_HOST;
            }
            case publicLun: {
                return DIAGNOSTIC_TYPE_MULTI_HOST;
            }
        }
        return null;
    }

    public static String getStorageType(DiagnosticPartitionType partitionType) {
        switch (partitionType) {
            case privateLocal: {
                return STORAGE_TYPE_DIRECT_ATTACHED;
            }
            case privateLun: 
            case publicLun: {
                return STORAGE_TYPE_NETWORK_ATTACHED;
            }
        }
        return null;
    }

    public static boolean hostSupportsVmfs5(int[] supportedVersions) {
        for (int supportedVersion : supportedVersions) {
            if (supportedVersion < 5) continue;
            return true;
        }
        return false;
    }

    public static int retrieveMajorEsxApiVersion(String apiVersion) {
        int majorVersion = 0;
        String[] splitApiVersion = apiVersion.split("\\.");
        if (splitApiVersion.length == 0) {
            _logger.error((Object)"ESX API version is not valid.");
            return majorVersion;
        }
        try {
            majorVersion = Integer.parseInt(splitApiVersion[0]);
        }
        catch (NumberFormatException ex) {
            _logger.error((Object)"ESX API version is not a number.");
        }
        return majorVersion;
    }

    public static PortGroupType getPortGroupType(String pgName, NetworkInfo networkInfo) {
        PortGroupType result = PortGroupType.VIRTUALMACHINE;
        if (networkInfo == null) {
            return result;
        }
        if (networkInfo.vnic != null) {
            for (VirtualNic vnic : networkInfo.vnic) {
                if (!pgName.equals(vnic.portgroup)) continue;
                result = PortGroupType.VMOTION;
                return result;
            }
        }
        if (networkInfo.consoleVnic != null) {
            for (VirtualNic svnic : networkInfo.consoleVnic) {
                if (!pgName.equals(svnic.portgroup)) continue;
                result = PortGroupType.SERVICECONSOLE;
                return result;
            }
        }
        return result;
    }

    public static StorageResourceManager getStorageManager(ManagedObjectReference moRef) throws Exception {
        if (moRef == null) {
            _logger.error((Object)"Null moRef encountered.");
            return null;
        }
        ServiceInstanceContent serviceContent = StorageUtil.getServiceInstanceContent(moRef);
        if (serviceContent == null) {
            _logger.error((Object)"Could not retrieve ServiceInstanceContent");
            return null;
        }
        return (StorageResourceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceContent.getStorageResourceManager());
    }

    public static VasaVvolManager getVasaVvolManager(String serviceGuid) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)serviceGuid);
        if (vcService == null) {
            return null;
        }
        ServiceInstance serviceInstance = vcService.getServiceInstance();
        if (serviceInstance == null) {
            return null;
        }
        InternalServiceInstanceContent internalContent = serviceInstance.retrieveInternalContent();
        if (internalContent == null || internalContent.vasaManager == null) {
            return null;
        }
        return (VasaVvolManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)internalContent.vasaManager);
    }

    public static ServiceInstanceContent getServiceInstanceContent(ManagedObjectReference moRef) throws Exception {
        if (moRef == null) {
            _logger.error((Object)"Null moRef encountered.");
            return null;
        }
        VcService service = VimSessionUtil.getService((String)moRef.getServerGuid());
        if (service == null) {
            _logger.error((Object)"Could not retrieve VcService");
            return null;
        }
        return service.getServiceInstanceContent();
    }

    public static PropertyValue createPropValue(String propertyName, Object value, Object provider) {
        PropertyValue pv = new PropertyValue();
        pv.propertyName = propertyName;
        pv.value = value;
        pv.resourceObject = provider;
        return pv;
    }
}

