/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.common.compositecommand;

import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.common.compositecommand.BaseCommand;
import com.vmware.vsphere.client.common.compositecommand.BaseCommandSpec;
import com.vmware.vsphere.client.common.compositecommand.CommandDebugUtil;
import com.vmware.vsphere.client.common.compositecommand.CommandFactory;
import com.vmware.vsphere.client.common.compositecommand.CommandState;
import com.vmware.vsphere.client.common.compositecommand.FutureCommand;
import com.vmware.vsphere.client.common.compositecommand.TaskCommand;
import com.vmware.vsphere.client.util.ServerModulesCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandExecutionEngine {
    private static final Log _logger = LogFactory.getLog(CommandExecutionEngine.class);
    private static final int DEFAULT_MAX_NUMBER_OF_PARALLEL_TASKS = 16;
    private static final int DEFAULT_POLL_INTERVAL = 1000;
    private BaseCommandSpec _rootSpec;
    private DataService _dataService;
    private CommandFactory _commandFactory;
    private Boolean _executionStarted = false;
    private Queue<BaseCommand> _pendingCommands;
    private List<BaseCommand> _runningCommands;
    private List<BaseCommand> _completeCommands;
    private OperationResult _result;
    private List<Exception> _commandErrors;
    private Set<ManagedObjectReference> _affectedEntities;

    public CommandExecutionEngine(BaseCommandSpec rootSpec, DataService dataService, CommandFactory commandFactory, OperationResult result) {
        this._rootSpec = rootSpec;
        if (dataService == null) {
            throw new IllegalArgumentException("Invalid argument: dataService can't be null!");
        }
        if (commandFactory == null) {
            throw new IllegalArgumentException("Invalid argument: commandFactory can't be null!");
        }
        this._dataService = dataService;
        this._commandFactory = commandFactory;
        this._result = result != null ? result : new OperationResult();
    }

    public CommandExecutionEngine(BaseCommandSpec rootSpec, DataService dataService, CommandFactory commandFactory) {
        this(rootSpec, dataService, commandFactory, new OperationResult());
    }

    public void execute() {
        if (this._executionStarted.booleanValue()) {
            return;
        }
        this._executionStarted = true;
        UUID executionUuid = UUID.randomUUID();
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)String.format("Running command tree execution {%s}", executionUuid.toString()));
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("Executing command tree for spec%n%s", CommandDebugUtil.dumpCommandSpec(this._rootSpec, true)));
        }
        try {
            this.initEngine();
            this._pendingCommands.addAll(this.getCommandFromSpec(new BaseCommandSpec[]{this._rootSpec}, null));
            while (!this._pendingCommands.isEmpty() || !this._runningCommands.isEmpty()) {
                this.runPendingCommands();
                Thread.sleep(1000L);
                this.updateRunningCommandsProgress();
                this.processCompleteCommands();
            }
        }
        catch (Exception ex) {
            if (_logger.isErrorEnabled()) {
                String message = String.format("Generic error in command tree execution {%s} for spec:%n%s", executionUuid.toString(), CommandDebugUtil.dumpCommandSpec(this._rootSpec, true));
                _logger.error((Object)message, (Throwable)ex);
            }
            this._result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        this.processResult();
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)String.format("Finished command tree execution {%s}", executionUuid.toString()));
        }
    }

    private void runPendingCommands() throws Exception {
        while (!this._pendingCommands.isEmpty() && this._runningCommands.size() < 16) {
            boolean isFirstCommand = this._completeCommands.isEmpty() && this._runningCommands.isEmpty();
            BaseCommand newCommand = this._pendingCommands.remove();
            try {
                this.runCommand(newCommand);
                if (!isFirstCommand) continue;
                this._result.entity = newCommand.runtimeInfo.mutatedMor;
            }
            catch (Exception ex) {
                this.failCommand(newCommand, ex);
            }
        }
    }

    public OperationResult getResult() {
        return this._result;
    }

    public Collection<Exception> getCommandExecutionErrors() {
        return Collections.unmodifiableCollection(this._commandErrors);
    }

    public boolean isExecutionSuccessful() {
        for (BaseCommand command : this._completeCommands) {
            if (command.runtimeInfo.state == CommandState.SUCCEEDED) continue;
            return false;
        }
        return true;
    }

    private void initEngine() {
        this._pendingCommands = new LinkedList<BaseCommand>();
        this._runningCommands = new ArrayList<BaseCommand>();
        this._completeCommands = new ArrayList<BaseCommand>();
        this._affectedEntities = new HashSet<ManagedObjectReference>();
    }

    private List<BaseCommand> getCommandFromSpec(BaseCommandSpec[] spec, BaseCommand parentCommand) {
        if (spec == null || spec.length == 0) {
            return null;
        }
        ArrayList<BaseCommand> commands = new ArrayList<BaseCommand>();
        for (int i = 0; i < spec.length; ++i) {
            if (spec[i] == null) {
                _logger.warn((Object)"Empty command specification is not expected");
                continue;
            }
            BaseCommand command = this._commandFactory.createCommand(spec[i], parentCommand, this._dataService);
            if (command != null) {
                commands.add(command);
                continue;
            }
            _logger.warn((Object)("Command cannot be created for command specification: " + ((Object)((Object)spec[i])).toString()));
        }
        return commands;
    }

    private void runCommand(BaseCommand command) throws Exception {
        command.run();
        this._runningCommands.add(command);
    }

    private void failCommand(BaseCommand command, Exception ex) {
        if (_logger.isErrorEnabled()) {
            String specDump = CommandDebugUtil.dumpCommandSpec(command.getCommandSpec(), false);
            String message = String.format("Error thrown while executing command:%n%s%n", specDump);
            _logger.error((Object)message, (Throwable)ex);
        }
        command.runtimeInfo.state = CommandState.FAILED;
        command.runtimeInfo.error = ex;
        this._completeCommands.add(command);
    }

    private List<TaskCommand> getRunningTaskCommands() {
        LinkedList<TaskCommand> commands = new LinkedList<TaskCommand>();
        if (this._runningCommands != null) {
            for (BaseCommand command : this._runningCommands) {
                if (!(command instanceof TaskCommand)) continue;
                commands.add((TaskCommand)command);
            }
        }
        return commands;
    }

    private List<FutureCommand> getRunningFutureCommands() {
        LinkedList<FutureCommand> commands = new LinkedList<FutureCommand>();
        if (this._runningCommands != null) {
            for (BaseCommand command : this._runningCommands) {
                if (!(command instanceof FutureCommand)) continue;
                commands.add((FutureCommand)command);
            }
        }
        return commands;
    }

    private void updateRunningCommandsProgress() {
        this.updateRunningTaskCommandsProgress();
        this.updateRunningFutureTaskCommandsProgress();
    }

    private void updateRunningTaskCommandsProgress() {
        List<TaskCommand> taskCommands = this.getRunningTaskCommands();
        if (!taskCommands.isEmpty()) {
            Map<ManagedObjectReference, TaskCommand> morCommandMap = this.buildTaskCommandByMorMap(taskCommands);
            try {
                Map<ManagedObjectReference, TaskInfo> taskInfoMap = this.retrieveTaskInfos(morCommandMap.keySet());
                for (Map.Entry<ManagedObjectReference, TaskInfo> entry : taskInfoMap.entrySet()) {
                    ManagedObjectReference mor = entry.getKey();
                    TaskCommand taskCommand = morCommandMap.get(mor);
                    TaskInfo taskInfo = entry.getValue();
                    if (taskCommand == null || taskInfo == null) continue;
                    taskCommand.updateRuntimeInfo(taskInfo);
                }
            }
            catch (Exception ex) {
                _logger.error((Object)"Data for running tasks' state was not retrieved!", (Throwable)ex);
            }
        }
    }

    private Map<ManagedObjectReference, TaskInfo> retrieveTaskInfos(Collection<ManagedObjectReference> moRefList) throws Exception {
        if (moRefList == null) {
            return null;
        }
        Object[] moRefs = moRefList.toArray(new ManagedObjectReference[moRefList.size()]);
        PropertyValue[] result = QueryUtil.getProperty((DataService)this._dataService, (Object[])moRefs, (String)"info");
        HashMap<ManagedObjectReference, TaskInfo> map = new HashMap<ManagedObjectReference, TaskInfo>();
        if (result != null) {
            for (PropertyValue pv : result) {
                ManagedObjectReference mor = (ManagedObjectReference)pv.resourceObject;
                TaskInfo taskInfo = (TaskInfo)pv.value;
                map.put(mor, taskInfo);
            }
        }
        return map;
    }

    private void updateRunningFutureTaskCommandsProgress() {
        List<FutureCommand> futureCommands = this.getRunningFutureCommands();
        for (FutureCommand futureCommand : futureCommands) {
            futureCommand.updateRuntimeInfo();
        }
    }

    private Map<ManagedObjectReference, TaskCommand> buildTaskCommandByMorMap(List<TaskCommand> taskCommands) {
        HashMap<ManagedObjectReference, TaskCommand> morCommandMap = new HashMap<ManagedObjectReference, TaskCommand>();
        for (TaskCommand taskCommand : taskCommands) {
            Task task = taskCommand.getTask();
            if (task == null) continue;
            morCommandMap.put(task._getRef(), taskCommand);
        }
        return morCommandMap;
    }

    private void processCompleteCommands() {
        List<BaseCommand> completeCommands = this.removeCompleteCommands();
        if (completeCommands.size() > 0) {
            for (BaseCommand command : completeCommands) {
                this._completeCommands.add(command);
                if (command.runtimeInfo.state != CommandState.SUCCEEDED) continue;
                this.enqueueDependentCommands(command);
            }
        }
    }

    private void enqueueDependentCommands(BaseCommand command) {
        List<BaseCommand> nextCommands;
        BaseCommandSpec[] dependentSpecs = ((BaseCommandSpec)((Object)command.getCommandSpec())).dependentSpecs;
        if (dependentSpecs != null && (nextCommands = this.getCommandFromSpec(dependentSpecs, command)) != null) {
            this._pendingCommands.addAll(nextCommands);
        }
    }

    private List<BaseCommand> removeCompleteCommands() {
        LinkedList<BaseCommand> completeCommands = new LinkedList<BaseCommand>();
        for (BaseCommand command : this._runningCommands) {
            if (!command.isComplete()) continue;
            completeCommands.add(command);
            if (command.runtimeInfo == null) continue;
            if (command.runtimeInfo.createdMor != null) {
                this._affectedEntities.add(command.runtimeInfo.createdMor);
            }
            if (command.runtimeInfo.mutatedMor == null) continue;
            this._affectedEntities.add(command.runtimeInfo.mutatedMor);
        }
        if (completeCommands.size() > 0) {
            this._runningCommands.removeAll(completeCommands);
        }
        return completeCommands;
    }

    private void processResult() {
        this.aggregateCommandErrors();
        this.aggregateAffectedEntities();
        this.aggregateTasks();
    }

    private void aggregateCommandErrors() {
        boolean successfulTasksFound = false;
        this._commandErrors = new ArrayList<Exception>();
        for (BaseCommand command : this._completeCommands) {
            if (command.runtimeInfo.state == CommandState.FAILED) {
                this._commandErrors.add((Exception)MixedUtil.getMethodFault((Throwable)command.runtimeInfo.error));
                continue;
            }
            if (command.runtimeInfo.state != CommandState.SUCCEEDED) continue;
            successfulTasksFound = true;
        }
        if (!this._commandErrors.isEmpty()) {
            if (!successfulTasksFound) {
                this._result.error = MixedUtil.getMethodFault((Throwable)this._commandErrors.get(0));
            } else {
                String message = ServerModulesCommonUtil.text("commandExecutionEngine.nestedCommandErrorMessage", new String[0]);
                this._result.error = MixedUtil.getMethodFault((Throwable)new Exception(message));
            }
        }
    }

    private void aggregateAffectedEntities() {
        if (this._affectedEntities != null && this._affectedEntities.size() > 0) {
            OperationEffect operationEffect = new OperationEffect();
            operationEffect.affectedEntites = this._affectedEntities.toArray(new Object[this._affectedEntities.size()]);
            this._result.effect = operationEffect;
        }
    }

    private void aggregateTasks() {
        ManagedObjectReference taskRef = null;
        TaskCommand lastCommand = null;
        for (BaseCommand command : this._completeCommands) {
            if (!(command instanceof TaskCommand)) continue;
            lastCommand = (TaskCommand)command;
            if (command.getCommandSpec() == null || !((BaseCommandSpec)((Object)command.getCommandSpec())).isResultTaskProvider || lastCommand.getTask() == null) continue;
            taskRef = lastCommand.getTask()._getRef();
            break;
        }
        if (taskRef != null) {
            this._result.task = taskRef;
        } else if (lastCommand != null && lastCommand.getTask() != null) {
            this._result.task = lastCommand.getTask()._getRef();
        }
    }
}

