/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.common.compositecommand;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.vim.data.QueryDataUtil;
import com.vmware.vsphere.client.common.compositecommand.BaseCommand;
import com.vmware.vsphere.client.common.compositecommand.BaseCommandSpec;

public abstract class CommandFactory {
    public abstract BaseCommand createCommand(BaseCommandSpec var1, BaseCommand var2, DataService var3);

    public void resolveCommandSpec(BaseCommandSpec commandSpec, BaseCommand parentCommand, String[] allowedMorTypes) throws IllegalArgumentException {
        if (commandSpec == null) {
            throw new IllegalArgumentException("commandSpec is required");
        }
        ManagedObjectReference mor = null;
        if (commandSpec.mor == null) {
            if (parentCommand == null) {
                throw new IllegalArgumentException("parentCommand is required.");
            }
            if (parentCommand.runtimeInfo.createdMor != null) {
                mor = parentCommand.runtimeInfo.createdMor;
            } else if (parentCommand.runtimeInfo.mutatedMor != null) {
                mor = parentCommand.runtimeInfo.mutatedMor;
            } else if (((BaseCommandSpec)((Object)parentCommand.getCommandSpec())).mor != null) {
                mor = ((BaseCommandSpec)((Object)parentCommand.getCommandSpec())).mor;
            }
        } else {
            mor = commandSpec.mor;
        }
        if (mor == null) {
            throw new IllegalArgumentException("Managed Object is required.");
        }
        String wsdlSpecMorType = mor.getType();
        String specMorType = "";
        Class specMorClass = QueryDataUtil.wsdlNameToJavaType((String)wsdlSpecMorType);
        if (specMorClass != null) {
            specMorType = specMorClass.getSimpleName();
        }
        boolean isSpecMorTypeAllowed = false;
        if (allowedMorTypes != null) {
            for (String allowedMorType : allowedMorTypes) {
                if (!allowedMorType.equalsIgnoreCase(specMorType)) continue;
                isSpecMorTypeAllowed = true;
                break;
            }
        } else {
            isSpecMorTypeAllowed = true;
        }
        if (!isSpecMorTypeAllowed) {
            throw new IllegalArgumentException("Managed Object should be of one of the following types: " + this.joinStringArray(allowedMorTypes));
        }
        commandSpec.mor = mor;
    }

    private String joinStringArray(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean isFirst = true;
        for (String stringItem : stringArray) {
            if (!isFirst) {
                stringBuffer.append(", ");
            } else {
                isFirst = false;
            }
            stringBuffer.append(stringItem);
        }
        return stringBuffer.toString();
    }
}

