/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storagedrs.rules;

import com.vmware.vim.binding.vim.cluster.AffinityRuleSpec;
import com.vmware.vim.binding.vim.cluster.AntiAffinityRuleSpec;
import com.vmware.vim.binding.vim.cluster.DependencyRuleInfo;
import com.vmware.vim.binding.vim.cluster.RuleInfo;
import com.vmware.vim.binding.vim.cluster.VmHostRuleInfo;
import com.vmware.vim.binding.vim.storageDrs.VirtualDiskAntiAffinityRuleSpec;
import com.vmware.vsphere.client.storagedrs.rules.RuleType;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRuleInfo;
import com.vmware.vsphere.client.storagedrs.rules.VirtualDiskAffinityRuleSpec;

public abstract class RulesUtil {
    public static SdrsRuleInfo createSdrsRuleInfo(RuleInfo rule) {
        SdrsRuleInfo ruleInfoEx = new SdrsRuleInfo();
        ruleInfoEx.rule = rule;
        ruleInfoEx.ruleType = RulesUtil.getRuleType(rule);
        return ruleInfoEx;
    }

    public static RuleType getRuleType(RuleInfo ruleInfo) {
        RuleType ruleType = RuleType.UNKNOWN_RULE_TYPE;
        if (ruleInfo instanceof AffinityRuleSpec) {
            ruleType = RuleType.VM_AFFINITY_RULE_TYPE;
        } else if (ruleInfo instanceof AntiAffinityRuleSpec) {
            ruleType = RuleType.VM_ANTIAFFINITY_RULE_TYPE;
        } else if (ruleInfo instanceof VmHostRuleInfo) {
            ruleType = RuleType.VM_HOST_GROUP_RULE_TYPE;
        } else if (ruleInfo instanceof DependencyRuleInfo) {
            ruleType = RuleType.VM_DEPENDENCY_RULE_TYPE;
        } else if (ruleInfo instanceof VirtualDiskAffinityRuleSpec) {
            ruleType = RuleType.VIRTUAL_DISK_AFFINITY_RULE_TYPE;
        } else if (ruleInfo instanceof VirtualDiskAntiAffinityRuleSpec) {
            ruleType = RuleType.VIRTUAL_DISK_ANTI_AFFINITY_RULE_TYPE;
        }
        return ruleType;
    }
}

