/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.telemetry.osgi;

import com.vmware.ph.ceip.authentication.DsSessionSimulator;
import com.vmware.ph.ceip.authentication.SessionSimulationException;
import com.vmware.ph.ceip.authentication.solutionuser.SolutionUserAuthenticationConfig;
import com.vmware.vise.extensionfw.OsgiUsageValidationListener;
import com.vmware.vise.extensionfw.OsgiWarningInfo;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.telemetry.TelemetryLoggingService;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.scheduling.TaskScheduler;

public class OsgiValidationTelemetryLogger
implements OsgiUsageValidationListener {
    private static final Log _logger = LogFactory.getLog(OsgiValidationTelemetryLogger.class);
    private static final int SIMULATED_SESSION_LIFETIME = 5;
    private static final String TELEMETRY_DATA_KEY = "data";
    private static final String TELEMETRY_DATA_TYPE_KEY = "type";
    private static final String OSGI_VALIDATION_TELEMETRY_TYPE = "osgivalidation";
    private final String PLUGIN_PACKAGE_ID_KEY = "pluginPackageId";
    private final String VALIDATION_CHECK_KEY = "validationCheck";
    private final String SOURCE_TYPE_KEY = "sourceType";
    private final String SOURCE_ID_KEY = "sourceId";
    private final String TARGET_TYPE_KEY = "targetType";
    private final String TARGET_IDS_KEY = "targetIds";
    private final TelemetryLoggingService _telemetryLoggingService;
    private final TaskScheduler _sessionDestructionScheduler;
    private final DsSessionSimulator _sessionSimulator;
    private final SolutionUserAuthenticationConfig _authConfig;
    private HttpServletRequest _httpRequest;
    private boolean _sessionSimulated;

    public OsgiValidationTelemetryLogger(TelemetryLoggingService telemetryLoggingService, TaskScheduler taskScheduler, DsSessionSimulator dsSessionSimulator, SolutionUserAuthenticationConfig solutionUserAuthenticationConfig) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{telemetryLoggingService, taskScheduler, dsSessionSimulator, solutionUserAuthenticationConfig});
        this._telemetryLoggingService = telemetryLoggingService;
        this._sessionDestructionScheduler = taskScheduler;
        this._sessionSimulator = dsSessionSimulator;
        this._authConfig = solutionUserAuthenticationConfig;
    }

    public void validationCheckFailed(OsgiWarningInfo osgiWarningInfo) {
        try {
            if (this.ensureSessionExists() && this._telemetryLoggingService.isEnabled()) {
                Map<String, Object> map = this.buildOsgiValidationTelemetryData(osgiWarningInfo);
                this._telemetryLoggingService.logTelemetry(new Map[]{map});
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("OSGi warning logged to Telemetry: " + osgiWarningInfo.toString()));
                }
            }
        }
        catch (RuntimeException runtimeException) {
            _logger.error((Object)"Could not log OSGi warnings to Telemetry.", (Throwable)runtimeException);
        }
    }

    private Map<String, Object> buildOsgiValidationTelemetryData(OsgiWarningInfo osgiWarningInfo) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{osgiWarningInfo});
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("pluginPackageId", osgiWarningInfo.getPluginPackageRef());
        hashMap.put("validationCheck", osgiWarningInfo.getValidationCheck());
        hashMap.put("sourceType", osgiWarningInfo.getSourceType());
        hashMap.put("sourceId", osgiWarningInfo.getSourceRef());
        hashMap.put("targetType", osgiWarningInfo.getTargetType());
        hashMap.put("targetIds", osgiWarningInfo.getTargetRefs());
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put(TELEMETRY_DATA_TYPE_KEY, OSGI_VALIDATION_TELEMETRY_TYPE);
        hashMap2.put(TELEMETRY_DATA_KEY, hashMap);
        return hashMap2;
    }

    private boolean ensureSessionExists() {
        if (!this._sessionSimulated) {
            this._sessionSimulated = true;
            if (this._httpRequest == null) {
                try {
                    this._httpRequest = this._sessionSimulator.simulate(this._authConfig, "osgi_validation_solution_user_actor_simulation");
                }
                catch (SessionSimulationException | RuntimeException throwable) {
                    _logger.error((Object)"Could not simulate session to check if CEIP is enabled. No OSGi validation data will be sent to telemetry.");
                }
                this.scheduleSimulatedSessionDestruction();
            } else {
                _logger.error((Object)"Simulated session already exists: not simulating a new one.");
            }
        }
        return this._httpRequest != null;
    }

    private void scheduleSimulatedSessionDestruction() {
        SessionDestructionTask sessionDestructionTask = new SessionDestructionTask();
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, 5);
        try {
            this._sessionDestructionScheduler.schedule((Runnable)sessionDestructionTask, calendar.getTime());
        }
        catch (RuntimeException runtimeException) {
            _logger.error((Object)"Couldn't schedule simulated session destruction.", (Throwable)runtimeException);
            _logger.info((Object)"Destroying session immediately.");
            sessionDestructionTask.run();
        }
    }

    private class SessionDestructionTask
    implements Runnable {
        private SessionDestructionTask() {
        }

        @Override
        public void run() {
            if (OsgiValidationTelemetryLogger.this._httpRequest != null) {
                _logger.info((Object)"Destroying session.");
                HttpServletRequest httpServletRequest = OsgiValidationTelemetryLogger.this._httpRequest;
                OsgiValidationTelemetryLogger.this._httpRequest = null;
                OsgiValidationTelemetryLogger.this._sessionSimulated = false;
                OsgiValidationTelemetryLogger.this._sessionSimulator.close(httpServletRequest);
            }
        }
    }
}

