/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.telemetry.ph.impl;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.vsphere.client.telemetry.ph.TelemetryPayloadBuilder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelemetryDataFactory {
    private static final String TELEMETRY_DATA_TYPE_PROPERTY_NAME = "type";
    private static final String TELEMETRY_DATA_PROPERTY_NAME = "data";
    private static final String CUSTOM_TELEMETRY_TYPE_PROPERTY_NAME = "telemetryType";
    private static final String GENERIC_TYPE = "generic";
    private static final String CUSTOM_TELEMETRY_TYPE = "custom";
    private static Map<String, TelemetryPayloadBuilder> knownPayloadBuilders = new HashMap<String, TelemetryPayloadBuilder>();
    private final Log _logger = LogFactory.getLog(TelemetryDataFactory.class);

    public TelemetryDataFactory(TelemetryPayloadBuilder ... telemetryPayloadBuilderArray) {
        for (TelemetryPayloadBuilder telemetryPayloadBuilder : telemetryPayloadBuilderArray) {
            this.addToFactory(telemetryPayloadBuilder);
        }
    }

    public void addToFactory(TelemetryPayloadBuilder telemetryPayloadBuilder) {
        String string = telemetryPayloadBuilder.getType();
        if (knownPayloadBuilders.get(string) != null) {
            this._logger.error((Object)String.format("Payload builder of type %s already exists", string));
            return;
        }
        knownPayloadBuilders.put(string, telemetryPayloadBuilder);
    }

    public static Payload constructPayload(Map<String, Object> map) throws IllegalArgumentException {
        TelemetryPayloadBuilder telemetryPayloadBuilder;
        String string = (String)map.get(TELEMETRY_DATA_TYPE_PROPERTY_NAME);
        if (CUSTOM_TELEMETRY_TYPE.equals(string)) {
            String string2 = TelemetryDataFactory.getCustomTelemetryType(map);
            telemetryPayloadBuilder = knownPayloadBuilders.get(string2);
        } else {
            telemetryPayloadBuilder = knownPayloadBuilders.get(string);
        }
        if (telemetryPayloadBuilder == null) {
            telemetryPayloadBuilder = knownPayloadBuilders.get(GENERIC_TYPE);
        }
        return telemetryPayloadBuilder.contructPayload(map);
    }

    private static String getCustomTelemetryType(Map<String, Object> map) throws IllegalArgumentException {
        if (map == null) {
            throw new IllegalArgumentException("telemetryData cannot be null");
        }
        Object object = map.get(TELEMETRY_DATA_PROPERTY_NAME);
        if (!(object instanceof Map)) {
            throw new IllegalArgumentException("Unexpected data value type!");
        }
        Map map2 = (Map)object;
        Object v = map2.get(CUSTOM_TELEMETRY_TYPE_PROPERTY_NAME);
        if (!(v instanceof String)) {
            throw new IllegalArgumentException("telemetryType should be of type String");
        }
        return (String)v;
    }
}

