/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.telemetry.ph.impl;

import com.vmware.ph.client.api.PhClient;
import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.dimensions.Collector;
import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.ph.client.api.impl.PhClientBuilder;
import com.vmware.ph.client.common.extensions.ps.AutodiscoveredProxySettingsProvider;
import com.vmware.ph.common.net.ProxySettingsProvider;
import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vsphere.client.telemetry.ITelemetryLogger;
import com.vmware.vsphere.client.telemetry.TelemetryConfiguration;
import com.vmware.vsphere.client.telemetry.ph.impl.PhPlatformAuditStrategy;
import com.vmware.vsphere.client.telemetry.ph.impl.TelemetryDataFactory;
import com.vmware.vsphere.client.telemetry.util.AnonymizationUtil;
import com.vmware.vsphere.client.telemetry.util.StorageUtil;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelemetryPhLogger
implements ITelemetryLogger {
    private static final String COLLECTOR_ID = "ngc.6_5";
    private static final String NGC_PRODUCT_ID = "com.vmware.cis";
    private static final String NGC_TYPE_ID = "vsphereclient";
    private volatile PhClient _phClient;
    private final ComponentManagerService _cmService;
    private final CeipConfigProvider _ceipConfigProvider;
    private final TelemetryConfiguration _telemetryConfiguration;
    private static final Log _logger = LogFactory.getLog(TelemetryPhLogger.class);
    private static final URI CONNECTION_TEST_URI = URI.create("https://vcsa.vmware.com/ph/api/v1/server_time");
    private static final int FRESH_PERIOD_MILLI_SECONDS = 3600000;

    public TelemetryPhLogger(ComponentManagerService componentManagerService, CeipConfigProvider ceipConfigProvider, TelemetryConfiguration telemetryConfiguration) {
        this._cmService = componentManagerService;
        this._ceipConfigProvider = ceipConfigProvider;
        this._telemetryConfiguration = telemetryConfiguration;
    }

    @Override
    public void logTelemetryData(Map<String, Object> map) {
        try {
            this.sendData(map);
        }
        catch (Exception exception) {
            _logger.error((Object)"Could not send telemetry data!", (Throwable)exception);
        }
    }

    @Override
    public boolean isCeipEnabled() {
        if (this._ceipConfigProvider != null) {
            return this._ceipConfigProvider.isCeipEnabled();
        }
        return false;
    }

    private String getInstanceId() {
        String string = null;
        ServiceTypeImpl serviceTypeImpl = new ServiceTypeImpl();
        serviceTypeImpl.setProductId(NGC_PRODUCT_ID);
        serviceTypeImpl.setTypeId(NGC_TYPE_ID);
        SearchCriteriaImpl searchCriteriaImpl = new SearchCriteriaImpl();
        searchCriteriaImpl.setServiceType((ServiceType)serviceTypeImpl);
        String string2 = null;
        try {
            Object object;
            Object[] objectArray;
            if (this._cmService != null && !ArrayUtil.isNullOrEmpty((Object[])(objectArray = this._cmService.search((SearchCriteria)searchCriteriaImpl))) && (object = objectArray[0]) != null) {
                string2 = object.getServiceId();
            }
        }
        catch (ComponentManagerFault componentManagerFault) {
            _logger.info((Object)"An error occurred while retrieving web client serviceId", (Throwable)componentManagerFault);
        }
        if (string2 == null) {
            string2 = UUID.randomUUID().toString();
        }
        string = AnonymizationUtil.getAnonymizedString(string2);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhClient getPhClient() {
        PhClient phClient = this._phClient;
        if (phClient == null) {
            TelemetryPhLogger telemetryPhLogger = this;
            synchronized (telemetryPhLogger) {
                phClient = this._phClient;
                if (phClient == null) {
                    this._phClient = phClient = this.createPhClient();
                }
            }
        }
        return phClient;
    }

    private PhClient createPhClient() {
        Collector collector = new Collector(COLLECTOR_ID, this.getInstanceId());
        PhClientBuilder phClientBuilder = PhClientBuilder.create((PhClientBuilder.Environment)PhClientBuilder.Environment.PRODUCTION, (Collector)collector);
        phClientBuilder.setProxyProvider((ProxySettingsProvider)new AutodiscoveredProxySettingsProvider(3600000L, CONNECTION_TEST_URI));
        new PhPlatformAuditStrategy().setAuditFileConfig(phClientBuilder);
        phClientBuilder.setBufferFolder(StorageUtil.getBufferingDirectory());
        int n = this._telemetryConfiguration.getBufferUploadPeriodSeconds();
        if (n != -1) {
            phClientBuilder.setBufferUploadPeriodMillis((long)(n * 1000));
        }
        phClientBuilder.setCeipConfigProvider(this._ceipConfigProvider);
        return phClientBuilder.build();
    }

    private void sendData(Map<String, Object> map) throws IllegalArgumentException {
        Payload payload = TelemetryDataFactory.constructPayload(map);
        this.addPayload(payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPayload(Payload payload) {
        if (payload == null) {
            _logger.debug((Object)"Unexpected null payload!");
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            for (Resource resource : payload.getResources()) {
                this.getPhClient().add(new CdfAble[]{resource});
            }
            for (Resource resource : payload.getFreeforms()) {
                this.getPhClient().add(new CdfAble[]{resource});
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }
}

