/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.common.sso;

import com.vmware.cis.common.sso.SsoOverRestRequest;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.http.AuthCalculator;
import com.vmware.vim.sso.http.AuthCalculatorFactory;
import com.vmware.vim.sso.http.Request;
import com.vmware.vim.sso.http.SignatureAlgorithm;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;

public class SsoOverRestHelper {
    public static final String TOKEN_NUM_PARTS_HEADER = "TokenParts";
    public static final String TOKEN_EACH_PART_HEADER = "TokenPart";

    public static Map<String, String> calcAuthHeader(SsoOverRestRequest request, PrivateKey key, SamlToken token, int headerChunkSize) throws SsoOverRestHelperException {
        if (headerChunkSize <= 0) {
            throw new IllegalArgumentException("Invalid header chunk size!");
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        try {
            AuthCalculator calc = AuthCalculatorFactory.instance((SignatureAlgorithm)SignatureAlgorithm.RSA_SHA256, (int)headerChunkSize);
            String[] authHeaders = calc.computeToken((Request)request, key, token.toXml());
            for (int i = 0; i < authHeaders.length; ++i) {
                headerMap.put(TOKEN_EACH_PART_HEADER + i, authHeaders[i]);
            }
            headerMap.put(TOKEN_NUM_PARTS_HEADER, String.valueOf(authHeaders.length));
        }
        catch (Exception e) {
            throw new SsoOverRestHelperException(e);
        }
        return headerMap;
    }

    public static class SsoOverRestHelperException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private SsoOverRestHelperException(Throwable cause) {
            super(cause);
        }

        private SsoOverRestHelperException(String message, Throwable cause) {
            super(message, cause);
        }

        private SsoOverRestHelperException(String message) {
            super(message);
        }

        private SsoOverRestHelperException() {
        }
    }
}

