/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.common.sso;

import com.vmware.vim.sso.http.Request;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;

public class SsoOverRestRequest
implements Request {
    private final Request.Method _method;
    private final String _uri;
    private final String _host;
    private final int _port;
    private final String _payload;

    public SsoOverRestRequest(Request.Method method, String uri, String host, int port, String payload) {
        this._method = method;
        this._uri = uri;
        this._host = host;
        this._port = port;
        this._payload = payload != null ? payload : "";
    }

    public SsoOverRestRequest(Request.Method method, URL url, String payload) {
        this(method, url.getPath().equals("") ? "/" : url.getPath(), url.getHost(), SsoOverRestRequest.getEffectivePort(url), payload);
    }

    public static int getEffectivePort(URL url) {
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        return port;
    }

    public SsoOverRestRequest(HttpPost post) throws IOException {
        this(Request.Method.POST, post.getURI().toURL(), IOUtils.toString((InputStream)post.getEntity().getContent(), (String)SsoOverRestRequest.getCharset(post)));
    }

    public SsoOverRestRequest(HttpGet get) throws IOException {
        this(Request.Method.GET, get.getURI().toURL(), null);
    }

    public Request.Method method() {
        return this._method;
    }

    public String requestURI() {
        return this._uri;
    }

    public String hostName() {
        return this._host;
    }

    public int port() {
        return this._port;
    }

    public InputStream payload() {
        return new ByteArrayInputStream(this._payload.getBytes(Charset.forName("utf-8")));
    }

    private static String getCharset(HttpPost post) throws IllegalArgumentException {
        String contentType = post.getFirstHeader("Content-type").getValue();
        String[] strings = contentType.split("charset\\s*=\\s*");
        if (strings.length < 2) {
            throw new IllegalArgumentException("Character set not found in header!");
        }
        return strings[1];
    }
}

