/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cm.common;

import com.vmware.cis.cm.common.LocalizationUtil;
import com.vmware.cis.cm.common.jaxb.healthstatus.HealthMessage;
import com.vmware.cis.cm.common.jaxb.healthstatus.ObjectFactory;
import com.vmware.vim.binding.impl.vmodl.LocalizableMessageImpl;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HealthStatusUtil {
    private static final ObjectFactory _hmFactory = new ObjectFactory();

    public static LocalizableMessage newLocalizableMessage(String messageKey, String defaultMessage, Object[] params) {
        if (messageKey == null && defaultMessage == null) {
            throw new IllegalArgumentException("Message key and default message cannot both be null!");
        }
        LocalizableMessageImpl lMessage = new LocalizableMessageImpl();
        lMessage.setKey(messageKey);
        lMessage.setMessage(defaultMessage);
        lMessage.setArg(LocalizationUtil.toLocalizableMessageArgs(Arrays.asList(params)));
        return lMessage;
    }

    public static LocalizableMessage[] toLocalizableMessages(List<HealthMessage> jaxbHealthMesssages) {
        ArrayList<LocalizableMessage> lMessages = new ArrayList<LocalizableMessage>();
        for (HealthMessage hm : jaxbHealthMesssages) {
            lMessages.add(HealthStatusUtil.toLocalizableMessage(hm));
        }
        return lMessages.toArray(new LocalizableMessage[lMessages.size()]);
    }

    public static List<HealthMessage> toJaxbMessages(LocalizableMessage[] localizableMessages) {
        ArrayList<HealthMessage> healthMessages = new ArrayList<HealthMessage>();
        if (localizableMessages != null) {
            for (LocalizableMessage lm : localizableMessages) {
                healthMessages.add(HealthStatusUtil.toJaxbMessage(lm));
            }
        }
        return healthMessages;
    }

    private static LocalizableMessage toLocalizableMessage(HealthMessage jaxbHealthMessage) {
        LocalizableMessageImpl msg = new LocalizableMessageImpl();
        msg.setKey(jaxbHealthMessage.getMessageKey());
        msg.setMessage(jaxbHealthMessage.getDefaultMessage());
        if (jaxbHealthMessage.getParam() != null) {
            msg.setArg(LocalizationUtil.toLocalizableMessageArgs(jaxbHealthMessage.getParam()));
        }
        return msg;
    }

    private static HealthMessage toJaxbMessage(LocalizableMessage lm) {
        HealthMessage hm = _hmFactory.createHealthMessage();
        hm.setMessageKey(lm.getKey());
        hm.setDefaultMessage(lm.getMessage());
        hm.getParam().addAll(HealthStatusUtil.toJaxbMessageArgs(lm.getArg()));
        return hm;
    }

    private static List<Object> toJaxbMessageArgs(KeyAnyValue[] args) {
        ArrayList<Object> res = new ArrayList<Object>();
        if (args != null) {
            for (KeyAnyValue arg : args) {
                res.add(HealthStatusUtil.toJaxbMessageArg(arg));
            }
        }
        return res;
    }

    private static Object toJaxbMessageArg(KeyAnyValue kv) {
        if (kv.getValue() == null) {
            throw new IllegalArgumentException("Message argument cannot be null");
        }
        return kv.getValue();
    }
}

