/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cm.common.endpoint;

import com.vmware.cis.cm.common.HealthStatusUtil;
import com.vmware.cis.cm.common.endpoint.ServletHelper;
import com.vmware.cis.cm.common.jaxb.healthstatus.HealthStatus;
import com.vmware.cis.cm.common.jaxb.healthstatus.ObjectFactory;
import com.vmware.cis.services.common.sso.SsoOverRestVerifierUtil;
import com.vmware.cis.services.common.sso.StsCertManager;
import com.vmware.vim.binding.cis.cm.monitor.HealthStatus;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HealthStatusServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final ObjectFactory _statusFactory = new ObjectFactory();
    private final transient Callable<StatusInfo> _statusGetter;
    private final transient ServletHelper _helper;

    public HealthStatusServlet(Callable<StatusInfo> statusGetter, StsCertManager stsCertManager, ServletHelper.SamlTokenPolicy policy) {
        this._statusGetter = statusGetter;
        this._helper = new ServletHelper(stsCertManager, policy);
    }

    public HealthStatusServlet(Callable<StatusInfo> statusGetter, ServletHelper helper) {
        this._statusGetter = statusGetter;
        this._helper = helper;
    }

    @Deprecated
    public HealthStatusServlet(Callable<StatusInfo> statusGetter, List<X509Certificate> stsCerts, ServletHelper.SamlTokenPolicy policy) {
        this._statusGetter = statusGetter;
        this._helper = new ServletHelper(stsCerts, policy);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        try {
            ServletHelper.RequestContext ctx = this._helper.requestPrologue(req, resp);
            StatusInfo si = this._statusGetter.call();
            HealthStatus jaxbHs = _statusFactory.createHealthStatus();
            jaxbHs.setSchemaVersion("1.0");
            jaxbHs.setStatus(si._statusCode.toString());
            jaxbHs.getMessage().addAll(HealthStatusUtil.toJaxbMessages(si._messages));
            this._helper.marshalResponse(jaxbHs, ctx, null);
        }
        catch (SsoOverRestVerifierUtil.SsoAuthException e) {
            resp.setStatus(401);
        }
        catch (ServletHelper.SamlTokenPolicyException e) {
            resp.setStatus(401);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            this._helper.requestEpilogue(req);
        }
    }

    public static class StatusInfo {
        public final HealthStatus.Code _statusCode;
        public final LocalizableMessage[] _messages;

        public StatusInfo(HealthStatus.Code statusCode, LocalizableMessage[] messages) {
            this._statusCode = statusCode;
            this._messages = messages == null ? null : Arrays.copyOf(messages, messages.length);
        }
    }
}

