/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cm.common.endpoint;

import com.vmware.cis.services.common.sso.NonRefetchingStsCertManagerImpl;
import com.vmware.cis.services.common.sso.SsoOverRestVerifierUtil;
import com.vmware.cis.services.common.sso.StsCertManager;
import com.vmware.cis.services.common.util.JaxbUtil;
import com.vmware.vim.sso.client.SamlToken;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletHelper {
    private static final Log _log = LogFactory.getLog(ServletHelper.class);
    private static final Charset UTF8 = Charset.forName("utf-8");
    private static final int CLOCK_TOLERANCE_SEC = 300;
    private static final int MAX_REQUEST_AGE_SEC = 3600;
    private final StsCertManager _stsCertManager;
    private final SamlTokenPolicy _samlTokenPolicy;

    public ServletHelper() {
        this((StsCertManager)null, null);
    }

    public ServletHelper(List<X509Certificate> stsCerts) {
        this(stsCerts, null);
    }

    public ServletHelper(List<X509Certificate> stsCerts, SamlTokenPolicy policy) {
        this._stsCertManager = stsCerts != null && stsCerts.size() > 0 ? new NonRefetchingStsCertManagerImpl(stsCerts) : null;
        this._samlTokenPolicy = policy;
    }

    public ServletHelper(StsCertManager stsCertManager, SamlTokenPolicy policy) {
        this._stsCertManager = stsCertManager;
        this._samlTokenPolicy = policy;
    }

    public RequestContext requestPrologue(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Handling HTTP request; method:%s url:%s", req.getMethod(), req.getRequestURL()));
        }
        return new RequestContext(req, resp, ServletHelper.getVerifiedInputStream(req, this._stsCertManager, this._samlTokenPolicy), (OutputStream)resp.getOutputStream());
    }

    public void requestEpilogue(HttpServletRequest req) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Completed HTTP request; method:%s url:%s", req.getMethod(), req.getRequestURL()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unmarshalRequest(Class<T> klass, RequestContext ctx, String schemaFile) throws Exception {
        Object object;
        try {
            object = JaxbUtil.unmarshal((InputStream)ctx._reqStream, klass, (String)schemaFile);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("Request body:%s", ctx.getTeeRequestBody()));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Request body:%s", ctx.getTeeRequestBody()));
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unmarshalRequestWithSchemaStream(Class<T> klass, RequestContext ctx, InputStream schemaStream) throws Exception {
        Object object;
        try {
            object = JaxbUtil.unmarshalWithSchemaStream((InputStream)ctx._reqStream, klass, (InputStream)schemaStream);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("Request body:%s", ctx.getTeeRequestBody()));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Request body:%s", ctx.getTeeRequestBody()));
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void marshalResponse(T obj, RequestContext ctx, String schemaFile) throws Exception {
        ctx._response.setHeader("Content-Type", "application/xml; charset=utf-8");
        try {
            Writer w = ServletHelper.getResponseWriter(ctx);
            JaxbUtil.marshal((Writer)w, obj, (String)schemaFile);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("Response body:%s", ctx.getTeeResponseBody()));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Response body:%s", ctx.getTeeResponseBody()));
        }
    }

    private static InputStream getVerifiedInputStream(HttpServletRequest req, StsCertManager stsCertManager, SamlTokenPolicy policy) throws Exception {
        Object input = null;
        if (stsCertManager != null) {
            try {
                byte[] payload = IOUtils.toByteArray((InputStream)req.getInputStream());
                SamlToken token = SsoOverRestVerifierUtil.verifySecurityHeader((HttpServletRequest)req, (byte[])payload, (StsCertManager)stsCertManager, (int)300, (int)3600);
                if (policy != null) {
                    policy.verifySamlToken(token);
                }
                input = new ByteArrayInputStream(payload);
            }
            catch (SsoOverRestVerifierUtil.SsoAuthException e) {
                _log.error((Object)String.format("SSO verification failed; client:%s", ServletHelper.getClientAddr(req)), (Throwable)e);
                throw e;
            }
            catch (SamlTokenPolicyException e) {
                _log.error((Object)String.format("SAML token policy verification failed; client: %s", ServletHelper.getClientAddr(req)), (Throwable)e);
                throw e;
            }
        } else {
            input = req.getInputStream();
        }
        return input;
    }

    public static Writer getResponseWriter(RequestContext ctx) {
        return new BufferedWriter(new OutputStreamWriter(ctx._respStream, UTF8));
    }

    private static String getClientAddr(HttpServletRequest req) {
        String info = req.getHeader("X-Forwarded-For");
        if (info == null) {
            info = req.getRemoteAddr();
        }
        return info;
    }

    public static class RequestContext {
        private final HttpServletRequest _request;
        private final HttpServletResponse _response;
        private final ByteArrayOutputStream _teeReqStream;
        private final ByteArrayOutputStream _teeRespStream;
        private final InputStream _reqStream;
        private final OutputStream _respStream;

        private RequestContext(HttpServletRequest req, HttpServletResponse resp, InputStream reqStream, OutputStream respStream) {
            this._request = req;
            this._response = resp;
            this._teeReqStream = new ByteArrayOutputStream();
            this._teeRespStream = new ByteArrayOutputStream();
            this._reqStream = new TeeInputStream(reqStream, (OutputStream)this._teeReqStream);
            this._respStream = new TeeOutputStream(respStream, (OutputStream)this._teeRespStream);
        }

        public String getTeeRequestBody() throws UnsupportedEncodingException {
            return this._teeReqStream.toString("UTF-8");
        }

        public String getTeeResponseBody() throws UnsupportedEncodingException {
            return this._teeRespStream.toString("UTF-8");
        }
    }

    public static class SamlTokenPolicyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SamlTokenPolicyException(Throwable cause) {
            super(cause);
        }

        public SamlTokenPolicyException(String message, Throwable cause) {
            super(message, cause);
        }

        public SamlTokenPolicyException(String message) {
            super(message);
        }

        public SamlTokenPolicyException() {
        }
    }

    public static interface SamlTokenPolicy {
        public void verifySamlToken(SamlToken var1) throws SamlTokenPolicyException;
    }
}

