/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cm.common.testhelper;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class TestHelperRequest {
    protected static final ObjectMapper _jsonMapper = new ObjectMapper();
    private static final JsonFactory _jsonFactory = _jsonMapper.getJsonFactory();
    private static final String FIELD_OPID = "opid";
    private static final String FIELD_ARGS = "args";

    public static void serializeRequest(TestHelperRequest req, Writer w) throws IOException {
        JsonGenerator jg = _jsonFactory.createJsonGenerator(w);
        jg.writeStartObject();
        jg.writeStringField(FIELD_OPID, req.getClass().getName());
        jg.writeFieldName(FIELD_ARGS);
        req.serializeArguments(jg);
        jg.writeEndObject();
        jg.close();
    }

    public static TestHelperRequest deserializeRequest(InputStream in) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        JsonParser jp = _jsonFactory.createJsonParser(in);
        jp.nextToken();
        jp.nextToken();
        if (jp.getCurrentName() == null || !jp.getCurrentName().equals(FIELD_OPID)) {
            throw new JsonParseException(String.format("Not found expected field name '%s'", FIELD_OPID), jp.getCurrentLocation());
        }
        jp.nextToken();
        Class<?> klass = TestHelperRequest.class.getClassLoader().loadClass(jp.getText());
        TestHelperRequest req = (TestHelperRequest)klass.newInstance();
        jp.nextToken();
        if (jp.getCurrentName() == null || !jp.getCurrentName().equals(FIELD_ARGS)) {
            throw new JsonParseException(String.format("Not found expected field name '%s'", FIELD_ARGS), jp.getCurrentLocation());
        }
        jp.nextToken();
        req.deserializeArguments(jp);
        jp.nextToken();
        if (jp.nextToken() != null) {
            throw new JsonParseException(String.format("Expected to consume all tokens; got '%s'", jp.getCurrentToken()), jp.getCurrentLocation());
        }
        jp.close();
        return req;
    }

    public abstract void serializeArguments(JsonGenerator var1) throws IOException;

    public abstract void deserializeArguments(JsonParser var1) throws IOException;

    public abstract void execute() throws Exception;
}

