/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcextension.impl;

import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.ext.ManagedByInfo;
import com.vmware.vim.binding.vim.ext.ManagedEntityInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.vcextension.RemoteImageManager;
import com.vmware.vsphere.client.vcextension.RemoteImageSpec;
import com.vmware.vsphere.client.vcextension.common.VcExtensionManagerProxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedByPropertyProvider
implements DerivedPropertyProviderAdapter {
    private static final String PROPERTY_MANAGED_BY_16 = "managedByIcon16";
    private static final String PROPERTY_MANAGED_BY_32 = "managedByIcon32";
    private static final String PROPERTY_MANAGED_INFO = "managedByInfo";
    private static final Map<Class<?>, String> MANAGEDBY_PROPERTY_BY_SUPPORTED_TYPE = new HashMap();
    private static final String[] SUPPORTED_PROPERTIES;
    private static final Log _logger;
    private VcExtensionManagerProxy _extensionManager;

    public ManagedByPropertyProvider(DataServiceExtensionRegistry registry, DataService dataService) {
        Validate.notNull((Object)registry, (String)"extension registry null");
        Validate.notNull((Object)dataService, (String)"data service null");
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    public VcExtensionManagerProxy getExtensionManagerProxy() {
        return this._extensionManager;
    }

    public void setExtensionManagerProxy(VcExtensionManagerProxy extensionManager) {
        this._extensionManager = extensionManager;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>();
        for (Class<?> type2 : MANAGEDBY_PROPERTY_BY_SUPPORTED_TYPE.keySet()) {
            TypeInfo typeInfo = new TypeInfo();
            typeInfo.type = type2.getSimpleName();
            typeInfo.properties = SUPPORTED_PROPERTIES;
            typeInfo.derivedProperties = this.getDerivedPropertyInfos(MANAGEDBY_PROPERTY_BY_SUPPORTED_TYPE.get(type2));
            typeInfos.add(typeInfo);
        }
        return (TypeInfo[])ArrayUtil.toArray(typeInfos, TypeInfo.class);
    }

    private DerivedPropertyInfo[] getDerivedPropertyInfos(String sourceProperty) {
        ArrayList<DerivedPropertyInfo> derivedPropertyInfos = new ArrayList<DerivedPropertyInfo>();
        for (String propertyName : SUPPORTED_PROPERTIES) {
            DerivedPropertyInfo derivedInfo = new DerivedPropertyInfo();
            derivedInfo.propertyName = propertyName;
            derivedInfo.sourcePropertyNames = new String[]{sourceProperty};
            derivedPropertyInfos.add(derivedInfo);
        }
        return derivedPropertyInfos.toArray(new DerivedPropertyInfo[derivedPropertyInfos.size()]);
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        Object[] properties = propertyRequest.properties;
        if (ArrayUtil.isNullOrEmpty((Object[])objects) || ArrayUtil.isNullOrEmpty((Object[])properties)) {
            _logger.warn((Object)"Property provider adapter got a null or empty list of properties or objects");
            return ResultUtil.newEmptyResultSet();
        }
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        ArrayList<ResultItem> results = new ArrayList<ResultItem>();
        Set<String> propertyNames = this.getPropertyNames((PropertySpec[])properties);
        ArrayList<ManagementInfo> infos = new ArrayList<ManagementInfo>();
        for (Object obj : objects) {
            ManagedObjectReference objRef;
            Class managedType;
            String propertyName;
            ManagedByInfo managedByInfo;
            Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(obj);
            if (sourcePropertyValuesMap == null || (managedByInfo = (ManagedByInfo)ManagedByPropertyProvider.getPropertyValue(sourcePropertyValuesMap, propertyName = MANAGEDBY_PROPERTY_BY_SUPPORTED_TYPE.get(managedType = ManagedObjectUtil.getType((ManagedObjectReference)(objRef = (ManagedObjectReference)obj))))) == null) continue;
            ManagementInfo inf = new ManagementInfo();
            inf.managedObject = objRef;
            inf.managedByInfo = managedByInfo;
            infos.add(inf);
        }
        if (this._extensionManager == null) {
            _logger.debug((Object)"No ExtensionManager available");
        } else {
            this.getExtensionInfo(infos);
        }
        for (ManagementInfo managedByObject : infos) {
            if (this._extensionManager != null && managedByObject.extension == null) {
                _logger.warn((Object)(managedByObject.managedObject + " specifies a " + "managedBy relation to an extension with the key " + managedByObject.managedByInfo.extensionKey + " but no such " + "extension is registered"));
            }
            ResultItem item = this.getResultItem(managedByObject, propertyNames);
            results.add(item);
        }
        ResultSet result = new ResultSet();
        result.items = (ResultItem[])ArrayUtil.toArray(results, ResultItem.class);
        return result;
    }

    private static <T> T getPropertyValue(Map<String, Object> propertyValuesMap, String propName) {
        return (T)propertyValuesMap.get(propName);
    }

    private Set<String> getPropertyNames(PropertySpec[] properties) {
        HashSet<String> propertyNames = new HashSet<String>();
        for (PropertySpec spec : properties) {
            for (String propertyName : spec.propertyNames) {
                propertyNames.add(propertyName);
            }
        }
        return propertyNames;
    }

    private Map<String, List<ManagementInfo>> splitByServerGuid(List<ManagementInfo> infos) {
        HashMap<String, List<ManagementInfo>> result = new HashMap<String, List<ManagementInfo>>();
        for (ManagementInfo info : infos) {
            String serverGuid = info.managedObject.getServerGuid();
            if (!result.containsKey(serverGuid)) {
                result.put(serverGuid, new ArrayList());
            }
            ((List)result.get(serverGuid)).add(info);
        }
        return result;
    }

    private void getExtensionInfo(List<ManagementInfo> infos) {
        assert (this._extensionManager != null) : "null extensionmanager proxy";
        Map<String, List<ManagementInfo>> objectsByServer = this.splitByServerGuid(infos);
        Map extensionsByServerGuid = this._extensionManager.getAllExtensionsForServers(objectsByServer.keySet());
        for (String serverGuid : objectsByServer.keySet()) {
            List<ManagementInfo> managedByObjects = objectsByServer.get(serverGuid);
            Collection serverExtensions = (Collection)extensionsByServerGuid.get(serverGuid);
            this.addExtensionInfo(managedByObjects, serverGuid, serverExtensions);
        }
    }

    private void addExtensionInfo(List<ManagementInfo> infos, String serverGuid, Collection<Extension> serverExtensions) {
        assert (infos != null);
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        HashMap<String, Extension> extensionsByKey = new HashMap<String, Extension>();
        for (Extension extension : serverExtensions) {
            extensionsByKey.put(extension.key, extension);
        }
        URI vcUri = URI.create(vcService.getServiceUrl());
        for (ManagementInfo info : infos) {
            assert (info.managedByInfo != null && info.managedObject != null);
            Extension managingExtension = (Extension)extensionsByKey.get(info.managedByInfo.extensionKey);
            info.extensionHost = vcUri.getHost();
            if (managingExtension == null) {
                _logger.error((Object)("The managed-by info on the object " + info.managedObject + " refers to an extension that is unavailable."));
                continue;
            }
            info.extension = managingExtension;
            if (managingExtension.managedEntityInfo == null) continue;
            for (ManagedEntityInfo mei : managingExtension.managedEntityInfo) {
                if (!mei.type.equals(info.managedByInfo.type)) continue;
                info.managedEntityInfo = mei;
            }
        }
    }

    private ResultItem getResultItem(ManagementInfo info, Set<String> requestedProperties) {
        PropertyValue property;
        assert (info != null);
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
        if (requestedProperties.contains(PROPERTY_MANAGED_INFO)) {
            String mbInfoString = this.getManagedByInfoString(info);
            property = ResultUtil.newProperty((String)PROPERTY_MANAGED_INFO, (Object)mbInfoString, (Object)info.managedObject);
            propertyValues.add(property);
        }
        if (requestedProperties.contains(PROPERTY_MANAGED_BY_16)) {
            RemoteImageSpec image16 = this.getManagedBy16ImageSpec(info);
            property = ResultUtil.newProperty((String)PROPERTY_MANAGED_BY_16, (Object)((Object)image16), (Object)info.managedObject);
            propertyValues.add(property);
        }
        if (requestedProperties.contains(PROPERTY_MANAGED_BY_32)) {
            RemoteImageSpec image32 = this.getManagedBy32ImageSpec(info);
            property = ResultUtil.newProperty((String)PROPERTY_MANAGED_BY_32, (Object)((Object)image32), (Object)info.managedObject);
            propertyValues.add(property);
        }
        ResultItem result = new ResultItem();
        result.resourceObject = info.managedObject;
        result.properties = (PropertyValue[])ArrayUtil.toArray(propertyValues, PropertyValue.class);
        return result;
    }

    private String getManagedByInfoString(ManagementInfo info) {
        if (info == null || info.managedByInfo == null) {
            return null;
        }
        if (info.extension == null) {
            _logger.debug((Object)("Unable to find extension with key '" + info.managedByInfo.extensionKey + "' - returning extension key instead of name"));
            return info.managedByInfo.extensionKey;
        }
        return info.extension.description.label;
    }

    private RemoteImageSpec getManagedBy16ImageSpec(ManagementInfo info) {
        String url;
        if (info == null || info.extensionHost == null || info.managedEntityInfo == null) {
            return null;
        }
        if (info.managedEntityInfo.smallIconUrl != null && !info.managedEntityInfo.smallIconUrl.isEmpty()) {
            url = info.managedEntityInfo.smallIconUrl.replace("*", info.extensionHost);
            RemoteImageSpec ris = RemoteImageManager.getInstance().getResized(url, 16, 16);
            if (ris != null) {
                return ris;
            }
        }
        if (info.managedEntityInfo.iconUrl == null || info.managedEntityInfo.iconUrl.isEmpty()) {
            return null;
        }
        url = info.managedEntityInfo.iconUrl.replace("*", info.extensionHost);
        return RemoteImageManager.getInstance().getResized(url, 16, 16);
    }

    private RemoteImageSpec getManagedBy32ImageSpec(ManagementInfo info) {
        if (info == null || info.extensionHost == null || info.managedEntityInfo == null) {
            return null;
        }
        if (info.managedEntityInfo.iconUrl == null || info.managedEntityInfo.iconUrl.isEmpty()) {
            return null;
        }
        String url = info.managedEntityInfo.iconUrl.replace("*", info.extensionHost);
        return RemoteImageManager.getInstance().getResized(url, 32, 32);
    }

    static {
        MANAGEDBY_PROPERTY_BY_SUPPORTED_TYPE.put(VirtualMachine.class, "config.managedBy");
        MANAGEDBY_PROPERTY_BY_SUPPORTED_TYPE.put(VirtualApp.class, "vAppConfig.managedBy");
        SUPPORTED_PROPERTIES = new String[]{PROPERTY_MANAGED_BY_16, PROPERTY_MANAGED_BY_32, PROPERTY_MANAGED_INFO};
        _logger = LogFactory.getLog(ManagedByPropertyProvider.class);
    }

    private class ManagementInfo {
        public ManagedObjectReference managedObject;
        public ManagedByInfo managedByInfo;
        public String extensionHost;
        public Extension extension;
        public ManagedEntityInfo managedEntityInfo;

        private ManagementInfo() {
        }
    }
}

