/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.upload.impl.http.js8;

import com.vmware.ph.common.StringUtil;
import com.vmware.ph.common.net.HttpConnectionConfig;
import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.exceptions.Bug;
import com.vmware.ph.exceptions.Exceptions;
import com.vmware.ph.exceptions.SystemException;
import com.vmware.ph.upload.HttpClientSetup;
import com.vmware.ph.upload.TransferProgressListener;
import com.vmware.ph.upload.exception.HttpUploadFailedException;
import com.vmware.ph.upload.exception.UploadFailedException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Scanner;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jscape8PutFile
implements Callable<Void> {
    private static final Logger log = LoggerFactory.getLogger(Jscape8PutFile.class);
    static final String LOGIN_URL_TEMPLATE = "%s/rest/login";
    static final String LOGOUT_URL_TEMPLATE = "%s/rest/logout";
    static final String UPLOAD_URL_TEMPLATE = "%s/rest/files?directory=%s&offset=%s";
    static final String CREATE_FOLDER_TEMPLATE = "%s/rest/files/directories?path=%s";
    static final String AUTN_TEMPLATE = "{\"domain\":\"%s\",\"username\":\"%s\", \"password\":\"%s\"}";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final String host;
    private final int port;
    private final String address;
    private final String username;
    private final String password;
    private final String domainName;
    private final String remoteDirectoryPath;
    private final String remoteFileName;
    private final InputStream streamToUpload;
    private final ProxySettings proxy;
    private final TransferProgressListener progressListener;
    private final long chunkSize;
    private final int maxAttempts;
    private final boolean shouldCreateFolder;
    private final Jscape8ClientFactory jscape8ClientFactory;
    private final HttpConnectionConfig connectionConfig;

    public Jscape8PutFile(String protocol, String host, int port, String username, String domainName, String password, ProxySettings proxy, InputStream streamToUpload, String remoteDirectoryPath, String remoteFileName, long chunkSize, TransferProgressListener progressListener, int maxResumesBeforeFailure, boolean shouldCreateFolder, HttpConnectionConfig connectionConfig) {
        this(protocol, host, port, username, domainName, password, proxy, streamToUpload, remoteDirectoryPath, remoteFileName, chunkSize, progressListener, maxResumesBeforeFailure, shouldCreateFolder, new Jscape8ClientFactory(), connectionConfig);
    }

    Jscape8PutFile(String protocol, String host, int port, String username, String domainName, String password, ProxySettings proxy, InputStream streamToUpload, String remoteDirectoryPath, String remoteFileName, long chunkSize, TransferProgressListener progressListener, int maxResumesBeforeFailure, boolean shouldCreateFolder, Jscape8ClientFactory jscape8ClientFactory, HttpConnectionConfig connectionConfig) {
        this.host = host;
        this.port = port;
        this.shouldCreateFolder = shouldCreateFolder;
        this.address = protocol + "://" + host + ":" + port;
        this.username = username;
        this.domainName = domainName;
        this.password = password;
        this.streamToUpload = this.getMarkableStream(streamToUpload);
        this.remoteDirectoryPath = remoteDirectoryPath;
        this.remoteFileName = remoteFileName;
        this.proxy = proxy;
        this.chunkSize = chunkSize;
        this.progressListener = progressListener;
        this.maxAttempts = maxResumesBeforeFailure;
        this.connectionConfig = connectionConfig;
        this.jscape8ClientFactory = jscape8ClientFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws UploadFailedException {
        log.debug(">> Starting upload as remote file '{}' at remote folder '{}'", (Object)this.remoteFileName, (Object)this.remoteDirectoryPath);
        Jscape8Client client = this.loginWithRetriesOnError();
        try {
            if (this.shouldCreateFolder) {
                this.createFolderWithReriesOnError(client);
            }
            client = this.uploadWithRetriesForEachChunk(client);
            log.info(">> Successfully uploaded a remote file '{}' at remote folder '{}'", (Object)this.remoteFileName, (Object)this.remoteDirectoryPath);
        }
        catch (Throwable throwable) {
            client.logout(String.format(LOGOUT_URL_TEMPLATE, this.address));
            IOUtils.closeQuietly(client);
            throw throwable;
        }
        client.logout(String.format(LOGOUT_URL_TEMPLATE, this.address));
        IOUtils.closeQuietly(client);
        return null;
    }

    private Jscape8Client loginWithRetriesOnError() {
        return this.executeWithRetry("Login", new Callable<Jscape8Client>(){

            @Override
            public Jscape8Client call() throws Exception {
                Jscape8Client client = Jscape8PutFile.this.loginClient();
                log.info("Login is successful.");
                return client;
            }
        });
    }

    private void createFolderWithReriesOnError(final Jscape8Client client) {
        this.executeWithRetry("Create folder", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String createFolderUrl = String.format(Jscape8PutFile.CREATE_FOLDER_TEMPLATE, Jscape8PutFile.this.address, Jscape8PutFile.this.remoteDirectoryPath);
                client.createFolder(createFolderUrl);
                log.info("Folder {} is successfully created.", (Object)createFolderUrl);
                return null;
            }
        });
    }

    private <T> T executeWithRetry(String taskName, Callable<T> task) {
        for (int attempt = 1; attempt <= this.maxAttempts; ++attempt) {
            log.info("{} - attempt {} of {}", new Object[]{taskName, attempt, this.maxAttempts});
            try {
                return task.call();
            }
            catch (Exception e) {
                this.handleException(attempt, e, taskName);
                continue;
            }
        }
        throw new Bug("handleException should not allow this line to be reached");
    }

    private Jscape8Client uploadWithRetriesForEachChunk(Jscape8Client client) {
        log.info("Start uploading chunk by chunk.");
        long from = 0L;
        long uploadedBytesCount = this.chunkSize;
        block2: while (uploadedBytesCount == this.chunkSize) {
            byte[] lastUploadChunk = null;
            boolean lastUploadFailed = false;
            for (int attempt = 1; attempt <= this.maxAttempts; ++attempt) {
                try {
                    UploadResult uploadResult = this.attemptToUploadChunk(client, from, lastUploadFailed, lastUploadChunk);
                    lastUploadChunk = uploadResult.lastUploadChunk;
                    lastUploadFailed = uploadResult.uploadAttemptFailed;
                    if (uploadResult.hasException()) {
                        throw uploadResult.exception;
                    }
                    uploadedBytesCount = lastUploadChunk.length;
                    this.progressListener.notifyForTransferProgressUpdate(from + uploadedBytesCount - 1L);
                    from += uploadedBytesCount;
                    continue block2;
                }
                catch (Exception e) {
                    this.handleException(attempt, e, "chunk upload");
                    client.logout(String.format(LOGOUT_URL_TEMPLATE, this.address));
                    IOUtils.closeQuietly(client);
                    client = this.loginWithRetriesOnError();
                    continue;
                }
            }
        }
        return client;
    }

    private UploadResult attemptToUploadChunk(Jscape8Client client, long from, boolean lastUploadFailed, byte[] lastUploadChunk) {
        UploadResult result = new UploadResult();
        long to = from + this.chunkSize - 1L;
        String uploadUrl = String.format(UPLOAD_URL_TEMPLATE, this.address, this.remoteDirectoryPath, from);
        if (lastUploadFailed) {
            client.uploadLastChunk(uploadUrl, lastUploadChunk, from, to);
            UploadResult.access$402(result, lastUploadChunk);
        } else {
            try {
                UploadResult.access$402(result, client.uploadChunk(uploadUrl, from, to));
            }
            catch (UploadFailedException e) {
                result.uploadAttemptFailed = true;
                UploadResult.access$402(result, client.getLastReadDataChunk());
                result.exception = e;
            }
        }
        return result;
    }

    private void handleException(int attempt, Exception e, String actionText) {
        if (e instanceof Bug) {
            throw (Bug)e;
        }
        if (attempt >= this.maxAttempts) {
            log.error(">> FAILED " + actionText + " for a remote file '{}' at remote folder '{}'", (Object)this.remoteFileName, (Object)this.remoteDirectoryPath);
            log.error(e.getMessage(), (Throwable)e);
            if (UploadFailedException.class.isAssignableFrom(e.getClass())) {
                throw (UploadFailedException)e;
            }
            throw new UploadFailedException(e);
        }
        log.warn(actionText + " attempt " + attempt + "  of " + this.maxAttempts + " failed. Continuing with next attempt.", (Throwable)e);
    }

    private Jscape8Client loginClient() {
        Jscape8Client client = this.jscape8ClientFactory.createJscape8Client(this.proxy, this.host, this.port, this.domainName, this.username, this.password, this.remoteDirectoryPath, this.remoteFileName, this.streamToUpload, this.connectionConfig);
        String loginAddressUrl = String.format(LOGIN_URL_TEMPLATE, this.address);
        String authenticationString = String.format(AUTN_TEMPLATE, this.domainName, this.username, this.password);
        client.login(loginAddressUrl, authenticationString);
        return client;
    }

    private InputStream getMarkableStream(InputStream stream) {
        InputStream markable = stream.markSupported() ? stream : new BufferedInputStream(stream);
        return markable;
    }

    static class LimitedLengthInputStream
    extends InputStream {
        private final InputStream decorated;
        private final long lengthLimit;
        private long count = 0L;

        public LimitedLengthInputStream(InputStream decorated, long length) {
            this.decorated = decorated;
            this.lengthLimit = length;
        }

        @Override
        public int read() throws IOException {
            if (this.lengthLimit >= 0L && this.count >= this.lengthLimit) {
                return -1;
            }
            int result = this.decorated.read();
            if (result != -1) {
                ++this.count;
            }
            return result;
        }

        public long getCount() {
            return this.count;
        }
    }

    public static class LoginFailedException
    extends SystemException {
        public LoginFailedException() {
        }

        public LoginFailedException(String msg) {
            super(msg);
        }

        public LoginFailedException(String msg, Throwable cause) {
            super(msg, cause);
        }

        public LoginFailedException(Throwable cause) {
            super(cause);
        }

        @Override
        public String getDebugMessage() {
            return null;
        }
    }

    static class Jscape8Executor
    implements Closeable {
        private final CloseableHttpClient client;
        private final ResponseContentReader contentReader;

        public Jscape8Executor(CloseableHttpClient client) {
            this(client, new ResponseContentReader());
        }

        Jscape8Executor(CloseableHttpClient client, ResponseContentReader contentReader) {
            if (client == null) {
                throw new Bug("HttpClient must not be null.");
            }
            this.client = client;
            this.contentReader = contentReader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CloseableHttpResponse executeMethod(HttpRequestBase method) throws IOException, ClientProtocolException {
            log.trace("Executing {} ... ", (Object)method);
            CloseableHttpResponse response = null;
            try {
                response = this.client.execute(method);
                int statusCode = response.getStatusLine().getStatusCode();
                if (200 <= statusCode && statusCode < 300) {
                    log.trace("Executing {} DONE. Response: {}", (Object)method, (Object)response);
                } else {
                    log.trace("Executing {} FAILED. Response: {}", (Object)method, (Object)response);
                    String s = this.contentReader.readResponseContent(response);
                    log.trace("Executing {} FAILED. Response body: {}", (Object)method, (Object)s);
                }
                CloseableHttpResponse closeableHttpResponse = response;
                return closeableHttpResponse;
            }
            finally {
                method.reset();
                IOUtils.closeQuietly(response);
            }
        }

        @Override
        public void close() throws IOException {
            this.client.close();
        }

        static class ResponseContentReader {
            ResponseContentReader() {
            }

            public String readResponseContent(HttpResponse response) throws IOException {
                InputStream content;
                HttpEntity entity = response.getEntity();
                Header contentType = entity.getContentType();
                Charset cs = UTF8;
                if (null != contentType) {
                    String[] split = contentType.getValue().split(";");
                    try {
                        for (String s : split) {
                            String csName;
                            boolean supported;
                            if (!s.toLowerCase().startsWith("charset=") || !(supported = Charset.isSupported(csName = s.substring("charset=".length())))) continue;
                            cs = Charset.forName(csName);
                            break;
                        }
                    }
                    catch (Exception e) {
                        log.warn("Cannot figure out the charset of the error, will default to " + UTF8, (Throwable)e);
                    }
                }
                String result = null != (content = entity.getContent()) ? ResponseContentReader.convertStreamToString(new LimitedLengthInputStream(content, 0x100000L), cs) : "n/a";
                return result;
            }

            public static String convertStreamToString(InputStream is, Charset charset) throws IOException {
                StringWriter writer = new StringWriter();
                IOUtils.copy(is, (Writer)writer, charset);
                String res = writer.toString();
                return res;
            }
        }
    }

    static class Jscape8Client
    implements Closeable {
        private final String remoteDirectoryPath;
        private String sessionId;
        private final String remoteFileName;
        private final InputStream streamToUpload;
        private final Jscape8Executor executor;
        private final LimitedLengthInputStreamFactory streamFactory;
        private byte[] lastReadChunk;

        public Jscape8Client(String remoteDirectoryPath, String remoteFileName, InputStream streamToUpload, CloseableHttpClient client) {
            this(remoteDirectoryPath, remoteFileName, streamToUpload, new Jscape8Executor(client));
        }

        Jscape8Client(String remoteDirectoryPath, String remoteFileName, InputStream streamToUpload, Jscape8Executor executor) {
            this(remoteDirectoryPath, remoteFileName, streamToUpload, null, executor);
        }

        Jscape8Client(String remoteDirectoryPath, String remoteFileName, InputStream streamToUpload, String sessionId, Jscape8Executor executor) {
            this(remoteDirectoryPath, remoteFileName, streamToUpload, sessionId, executor, new LimitedLengthInputStreamFactory());
        }

        Jscape8Client(String remoteDirectoryPath, String remoteFileName, InputStream streamToUpload, String sessionId, Jscape8Executor executor, LimitedLengthInputStreamFactory streamFactory) {
            this.remoteDirectoryPath = remoteDirectoryPath;
            this.remoteFileName = remoteFileName;
            this.streamToUpload = streamToUpload;
            this.sessionId = sessionId;
            this.executor = executor;
            this.streamFactory = streamFactory;
        }

        String getSessionId() {
            return this.sessionId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void login(String addressUrl, String authenticationString) {
            Exceptions.traceEntering(Jscape8PutFile.access$100());
            result = null;
            try {
                url = new URL(addressUrl);
                method = new HttpPost("" + url);
                requestAsJson = authenticationString;
                try {
                    block13: {
                        body = new StringEntity(requestAsJson, Jscape8PutFile.access$800());
                        body.setContentType("application/json");
                        method.setEntity(body);
                        response = null;
                        try {
                            response = this.executor.executeMethod(method);
                            arr$ = cookies = response.getHeaders("Set-Cookie");
                            len$ = arr$.length;
                            i$ = 0;
lbl17:
                            // 2 sources

                            while (i$ < len$) {
                                h = arr$[i$];
                                value = h.getValue();
                                if (value.startsWith("JSESSIONID=")) {
                                    this.sessionId = Jscape8Client.getSessionId(value);
                                    Jscape8PutFile.access$100().debug("Successfully logged in to {}, sessionId={}", (Object)addressUrl, (Object)StringUtil.obfuscate(this.sessionId));
                                    break block13;
                                }
                                ** GOTO lbl-1000
                            }
                            ** GOTO lbl46
                        }
                        catch (Throwable var15_17) {
                            IOUtils.closeQuietly(response);
                            throw var15_17;
                        }
                    }
                    IOUtils.closeQuietly(response);
                    ** GOTO lbl42
                }
                catch (IOException e) {
                    Exceptions.logAsErrorAndThrow(Jscape8PutFile.access$100(), "login FAILED.", new LoginFailedException(e));
                    ** GOTO lbl49
                }
            }
            catch (MalformedURLException e) {
                try {
                    Exceptions.logAsErrorAndThrow(Jscape8PutFile.access$100(), "Login cannot be executed. Failing.", new Bug("URL for login in the code is wrong.", e));
                }
                catch (Throwable var16_18) {
                    Exceptions.traceExitingWithResult(Jscape8PutFile.access$100(), null != result ? "OK" : null);
                    throw var16_18;
                }
lbl42:
                // 1 sources

                Exceptions.traceExitingWithResult(Jscape8PutFile.access$100(), null != result ? "OK" : null);
                return;
lbl-1000:
                // 1 sources

                {
                    ++i$;
                    ** GOTO lbl17
                }
lbl46:
                // 1 sources

                IOUtils.closeQuietly(response);
                message = "Authentication data was not found.";
                Exceptions.logAsErrorAndThrow(Jscape8PutFile.access$100(), message, new Bug(message));
lbl49:
                // 2 sources

                Exceptions.traceExitingWithResult(Jscape8PutFile.access$100(), null != result ? "OK" : null);
                throw new Bug("Exceptions.logAsErrorAndThrow should not allow this line to be reached");
                Exceptions.traceExitingWithResult(Jscape8PutFile.access$100(), null != result ? "OK" : null);
                throw new Bug("Exceptions.logAsErrorAndThrow should not allow this line to be reached");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createFolder(String createFolderUrl) throws IOException {
            Exceptions.traceEnteringWithInput(log, this.remoteDirectoryPath);
            String result = "FAILED!";
            try {
                URL url = new URL(createFolderUrl);
                HttpPut method = new HttpPut("" + url);
                CloseableHttpResponse resp = null;
                try {
                    resp = this.executor.executeMethod(method);
                    result = "OK";
                }
                catch (IOException e) {
                    try {
                        log.error("Could not create folder " + this.remoteDirectoryPath + "! ", (Throwable)e);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(resp);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(resp);
            }
            catch (MalformedURLException e) {
                try {
                    Exceptions.logAsErrorAndThrow(log, "Create folder cannot be executed. Failing.", new Bug("URL for REST call in the code is wrong.", e));
                }
                catch (Throwable throwable) {
                    Exceptions.traceExitingWithResult(log, null != result ? "OK" : null);
                    throw throwable;
                }
                Exceptions.traceExitingWithResult(log, null != result ? "OK" : null);
            }
            Exceptions.traceExitingWithResult(log, null != result ? "OK" : null);
        }

        public void uploadLastChunk(String uploadUrl, byte[] lastChunk, long from, long to) {
            this.uploadInternal(uploadUrl, lastChunk, from, to);
        }

        public byte[] uploadChunk(String uploadUrl, long from, long to) {
            int chunkLength = (int)(to - from + 1L);
            try {
                this.lastReadChunk = this.readInput(this.streamToUpload, chunkLength);
            }
            catch (IOException e) {
                String message = String.format("System error. Upload failed un recovarably. You should try to resend the data again. Reason: Failed to read chunk with offset from %s to %s.", from, to);
                log.warn(message, (Throwable)e);
                throw new Bug(message, e);
            }
            if (this.lastReadChunk.length > 0) {
                this.uploadInternal(uploadUrl, this.lastReadChunk, from, to);
            }
            return this.lastReadChunk;
        }

        byte[] getLastReadDataChunk() {
            return this.lastReadChunk;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void uploadInternal(String uploadUrl, byte[] lastChunk, long from, long to) {
            String sOffset = "offset from " + from + " to " + to;
            Exceptions.traceEnteringWithInput(log, sOffset);
            String result = "FAILED!";
            try {
                URL url = new URL(uploadUrl);
                HttpPut put = new HttpPut("" + url);
                put.addHeader("Cookie", this.sessionId);
                String boundary = Long.toHexString(System.currentTimeMillis());
                MultipartEntityBuilder multiPartBuilder = MultipartEntityBuilder.create();
                multiPartBuilder.setStrictMode().setBoundary(boundary).setCharset(UTF8);
                InputStreamBody body = new InputStreamBody((InputStream)new ByteArrayInputStream(lastChunk), this.remoteFileName);
                multiPartBuilder.addPart("data", body);
                put.setEntity(multiPartBuilder.build());
                CloseableHttpResponse response = null;
                try {
                    boolean success;
                    response = this.executor.executeMethod(put);
                    int statusCode = response.getStatusLine().getStatusCode();
                    boolean bl = success = 200 <= statusCode && statusCode < 300;
                    if (!success) {
                        throw new HttpUploadFailedException("Failed uploading " + sOffset + " of " + this.remoteDirectoryPath + "/" + this.remoteFileName + ". Server response was " + response);
                    }
                    result = "" + response;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(response);
                    throw throwable;
                }
                IOUtils.closeQuietly(response);
            }
            catch (IOException e) {
                String msg = "Failed uploading chunk [" + from + "," + to + ").";
                Exceptions.logAsErrorAndThrow(log, msg + "Wrapping and rethrowing.", new UploadFailedException(msg, e));
            }
            finally {
                Exceptions.traceExitingWithResult(log, result);
            }
        }

        private byte[] readInput(InputStream inputStream, int chunkLength) throws IOException {
            byte[] buff;
            LimitedLengthInputStream llis = this.streamFactory.createStream(inputStream, chunkLength);
            int br = llis.read(buff = new byte[chunkLength]);
            if (br == -1) {
                buff = new byte[]{};
            } else if (br < chunkLength) {
                buff = Arrays.copyOf(buff, br);
            }
            return buff;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logout(String logoutUrl) {
            Exceptions.traceEntering(log);
            try {
                URL url = new URL(logoutUrl);
                HttpPost method = new HttpPost("" + url);
                CloseableHttpResponse resp = null;
                try {
                    resp = this.executor.executeMethod(method);
                    log.trace("Successfully logged out.");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(resp);
                    throw throwable;
                }
                IOUtils.closeQuietly(resp);
            }
            catch (MalformedURLException e) {
                String msg = "Wrong URL template in the code: %s/rest/logout";
                Bug bug = new Bug(msg, e);
                log.error(msg, (Throwable)bug);
                throw bug;
            }
            catch (IOException e) {
                String msg = "Failed logging out. Continuing as if nothing happened ;)";
                log.error(msg, (Throwable)e);
            }
            finally {
                Exceptions.traceExiting(log);
            }
        }

        private static String getSessionId(String cookie) {
            Scanner scanner = new Scanner(cookie);
            String res = scanner.useDelimiter(";").next();
            scanner.close();
            return res;
        }

        @Override
        public void close() throws IOException {
            this.executor.close();
        }

        static class LimitedLengthInputStreamFactory {
            LimitedLengthInputStreamFactory() {
            }

            public LimitedLengthInputStream createStream(InputStream decorated, long length) {
                return new LimitedLengthInputStream(decorated, length);
            }
        }
    }

    static class Jscape8ClientFactory {
        Jscape8ClientFactory() {
        }

        public Jscape8Client createJscape8Client(ProxySettings ps, String host, int port, String domainName, String username, String password, String remoteDirectoryPath, String remoteFileName, InputStream streamToUpload, HttpConnectionConfig connectionConfig) {
            CloseableHttpClient httpClient = Jscape8ClientFactory.createClient(ps, host, port, domainName, username, password, connectionConfig);
            Jscape8Client client = new Jscape8Client(remoteDirectoryPath, remoteFileName, streamToUpload, httpClient);
            return client;
        }

        private static CloseableHttpClient createClient(ProxySettings ps, String host, int port, String domainName, String username, String password, HttpConnectionConfig connectionConfig) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            AuthScope authScope = new AuthScope(host, port, domainName);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
            credentialsProvider.setCredentials(authScope, credentials);
            HttpClientBuilder httpClientBuilder = HttpClientSetup.createHttpClientBuilder(connectionConfig, ps, credentialsProvider);
            return httpClientBuilder.build();
        }
    }

    private static class UploadResult {
        private byte[] lastUploadChunk;
        private Exception exception;
        private boolean uploadAttemptFailed;

        private UploadResult() {
        }

        boolean hasException() {
            return this.exception != null;
        }

        static /* synthetic */ byte[] access$402(UploadResult x0, byte[] x1) {
            x0.lastUploadChunk = x1;
            return x1;
        }
    }
}

