/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.common.net;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ProxySettings {
    public static final List<String> DEFAULT_PROXY_AUTHENTICATION_SCHEMES = Arrays.asList("digest", "basic");
    public static final ProxySettings NO_PROXY = new ProxySettings();
    private String hostname;
    private int port;
    private String username;
    private String password;
    private Collection<String> proxyAuthenticationSchemes = DEFAULT_PROXY_AUTHENTICATION_SCHEMES;

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Collection<String> getProxyAuthenticationSchemes() {
        return this.proxyAuthenticationSchemes;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProxyAuthenticationSchemes(Collection<String> proxyAuthenticationSchemes) {
        this.proxyAuthenticationSchemes = proxyAuthenticationSchemes;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public ProxySettings(String hostname, int port, String username, String password) {
        this.username = username;
        this.password = password;
        this.hostname = hostname;
        this.port = port;
    }

    public ProxySettings() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxySettings)) {
            return false;
        }
        ProxySettings other = (ProxySettings)obj;
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public String toString() {
        return String.format("%s[hostname=%s, port=%d, username=%s, proxyAuthenticationSchemes=%s]", this.getClass().getSimpleName(), this.hostname, this.port, this.username, this.proxyAuthenticationSchemes);
    }
}

