/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.support.client.api.impl;

import com.vmware.ph.support.client.api.SrUploader;
import com.vmware.ph.upload.service.UploadService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.Future;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SrUploaderImpl
implements SrUploader {
    static final String GSS_SR_FILING_COLLECTOR = "gss.sr.noncollector";
    private static final Logger log = LoggerFactory.getLogger(SrUploaderImpl.class);
    private final UploadService uploadService;
    private final FileSystemOperationsWrapper fileSystemOperationsWrapper;

    public SrUploaderImpl(UploadService uploadService) {
        this(uploadService, new FileSystemOperationsWrapper());
    }

    SrUploaderImpl(UploadService uploadService, FileSystemOperationsWrapper fileSystemOperationsWrapper) {
        this.uploadService = uploadService;
        this.fileSystemOperationsWrapper = fileSystemOperationsWrapper;
    }

    @Override
    public Future<?> attachFileToSr(File fileToUpload, String srNumber) throws FileNotFoundException {
        if (fileToUpload.length() <= 0L) {
            throw new IllegalArgumentException("The file to be uploaded must have size > 0.");
        }
        InputStream stream = this.fileSystemOperationsWrapper.createStream(fileToUpload);
        return this.attachStreamToSr(fileToUpload.getName(), stream, srNumber);
    }

    @Override
    public Future<?> attachStreamToSr(String targetFileName, InputStream stream, String srNumber) {
        Validate.notEmpty(srNumber);
        Validate.notEmpty(targetFileName);
        Validate.notNull(stream);
        String targetFileNameUnique = this.makeRemoteFilename(srNumber, targetFileName);
        String instanceId = UUID.randomUUID().toString();
        String uploadId = UUID.randomUUID().toString();
        int size = 1;
        log.debug("Attaching '{}' file to SR#='{}' with instanceId='{}' and uploadId='{}' and destination name='{}'", new Object[]{targetFileName, srNumber, instanceId, uploadId, targetFileNameUnique});
        return this.uploadService.upload(GSS_SR_FILING_COLLECTOR, instanceId, uploadId, targetFileNameUnique, stream, size);
    }

    private String makeRemoteFilename(String srNumber, String fileName) {
        String folderName = "/" + srNumber;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HHmm-ss.SSS");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        String timeSuffix = "." + format.format(new Date());
        return folderName + "/" + fileName + timeSuffix;
    }

    static class FileSystemOperationsWrapper {
        FileSystemOperationsWrapper() {
        }

        public InputStream createStream(File file) throws FileNotFoundException {
            return new FileInputStream(file);
        }
    }
}

