/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.support.upload.impl.ftp;

import com.vmware.ph.common.net.HttpConnectionConfig;
import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.upload.TransferProgressListener;
import com.vmware.ph.upload.exception.FtpException;
import com.vmware.ph.upload.exception.FtpUploadFailedException;
import com.vmware.ph.upload.exception.UploadAuthenticationException;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.SocketException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUploader
implements Closeable {
    protected FTPClient ftpClient;
    private final String protocol;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final int connection_socket_timeout;
    private static final Logger log = LoggerFactory.getLogger(FtpUploader.class);
    static final int MIN_OFFSET_STEP = 0x100000;

    static FTPClient createFTPClient(ProxySettings proxySettings) {
        FTPClient newClient = null;
        newClient = proxySettings == null || proxySettings.equals(ProxySettings.NO_PROXY) ? new FTPClient() : new FTPHTTPClient(proxySettings.getHostname(), proxySettings.getPort(), proxySettings.getUsername(), proxySettings.getPassword());
        return newClient;
    }

    public FtpUploader(String protocol, String hostname, int port, String username, String password, ProxySettings proxySettings, HttpConnectionConfig connectionConfig) {
        this(protocol, hostname, port, username, password, connectionConfig, FtpUploader.createFTPClient(proxySettings));
    }

    FtpUploader(String protocol, String hostname, int port, String username, String password, HttpConnectionConfig connectionConfig, FTPClient ftpClient) {
        this.protocol = protocol;
        this.host = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.connection_socket_timeout = connectionConfig.getConnectionTimeout();
        this.ftpClient = ftpClient;
    }

    public void uploadFile(InputStream streamToUpload, final String remotePathName, long startOffset, TransferProgressListener progressListener) throws IOException, FtpException, IllegalStateException {
        final InputStream markableStreamToUpload = this.getMarkableStream(streamToUpload);
        startOffset = Math.max(0L, startOffset - 0x100000L);
        log.info("Entering " + this.getClass() + ".uploadFile(remoteFile=" + remotePathName + ", startOffset=" + startOffset + ") ");
        if (null == this.ftpClient) {
            throw new IllegalStateException("ftpClient is null");
        }
        this.ensureParentFolderExists(remotePathName);
        try {
            boolean success;
            if (0L < startOffset) {
                this.ftpClient.setRestartOffset(startOffset);
                markableStreamToUpload.skip(startOffset);
            }
            if (progressListener != null) {
                this.ftpClient.setCopyStreamListener(this.wrapProgressListener(progressListener, startOffset));
            }
            if (!(success = this.executeFtpCommandWithBoolResult("Uploading " + remotePathName, log, this.ftpClient, new BoolCommandExecutor(){

                @Override
                public boolean exec() throws IOException {
                    return FtpUploader.this.ftpClient.storeFile(remotePathName, markableStreamToUpload);
                }
            }))) {
                throw new FtpUploadFailedException("Could not upload file to remote path " + remotePathName);
            }
            log.info("Successfully uploaded {} file", (Object)remotePathName);
        }
        catch (IOException e) {
            log.error("Failed uploading file '" + remotePathName + "'.", (Throwable)e);
            throw e;
        }
        finally {
            this.ftpClient.setCopyStreamListener(null);
            IOUtils.closeQuietly(markableStreamToUpload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (null != this.ftpClient && !this.ftpClient.logout()) {
                log.error("Can't logout. Continuing.");
            }
        }
        finally {
            try {
                if (null != this.ftpClient && this.ftpClient.isConnected()) {
                    this.ftpClient.disconnect();
                }
            }
            finally {
                this.ftpClient = null;
            }
        }
    }

    protected void connect() throws SocketException, IOException {
        String msg = "Connecting to " + this.protocol + "://" + this.host + ":" + this.port;
        log.trace(msg + " ...");
        this.ftpClient.setDefaultTimeout(this.connection_socket_timeout);
        this.ftpClient.setConnectTimeout(this.ftpClient.getDefaultTimeout());
        this.ftpClient.setDataTimeout(this.ftpClient.getDefaultTimeout());
        this.ftpClient.setControlKeepAliveTimeout(20L);
        this.ftpClient.setControlKeepAliveReplyTimeout(3000);
        this.ftpClient.connect(this.host, this.port);
        log.trace(msg + " SUCCESS");
    }

    protected boolean connectLoginAndInit() throws UploadAuthenticationException, SocketException, IOException {
        this.connect();
        boolean success = this.executeFtpCommandWithBoolResult("Logging in", log, this.ftpClient, new BoolCommandExecutor(){

            @Override
            public boolean exec() throws IOException {
                return FtpUploader.this.ftpClient.login(FtpUploader.this.username, FtpUploader.this.password);
            }
        });
        if (!success) {
            throw new UploadAuthenticationException("Authentication failed for user " + this.username);
        }
        boolean res = this.executeFtpCommandWithBoolResult("Configuring client", log, this.ftpClient, new BoolCommandExecutor(){

            @Override
            public boolean exec() throws IOException {
                Logger ftpCommandsLogger = LoggerFactory.getLogger((String)(FtpUploader.class.getName() + ".wire"));
                LogOutputStream streamToLogger = new LogOutputStream(ftpCommandsLogger);
                PrintWriter writer = new PrintWriter(streamToLogger);
                PrintCommandListener listener = new PrintCommandListener(writer, true);
                FtpUploader.this.ftpClient.addProtocolCommandListener(listener);
                boolean success = FtpUploader.this.ftpClient.setFileType(2);
                FtpUploader.this.ftpClient.enterLocalPassiveMode();
                return success;
            }
        });
        return res;
    }

    CopyStreamListener wrapProgressListener(final TransferProgressListener listener, final long startingOffset) {
        return new CopyStreamListener(){

            @Override
            public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                listener.notifyForTransferProgressUpdate(startingOffset + totalBytesTransferred);
                int mb = 0x100000;
                if (0L == totalBytesTransferred % 0x100000L) {
                    log.info("Read " + totalBytesTransferred / 0x100000L + " MB from the file which is being uploaded over FTP. (may not be transferred yet, those are bytes sent to the socket.)");
                }
            }

            @Override
            public void bytesTransferred(CopyStreamEvent event) {
                this.bytesTransferred(event.getTotalBytesTransferred(), event.getBytesTransferred(), event.getStreamSize());
            }
        };
    }

    private boolean ensureParentFolderExists(String remoteFilePahtName) throws IOException {
        int idx = remoteFilePahtName.lastIndexOf("/");
        if (-1 != idx) {
            final String dir = remoteFilePahtName.substring(0, idx);
            return this.executeFtpCommandWithBoolResult("Creating folder ", log, this.ftpClient, new BoolCommandExecutor(){

                @Override
                public boolean exec() throws IOException {
                    int reply = FtpUploader.this.ftpClient.mkd(dir);
                    return FTPReply.isPositiveCompletion(reply);
                }
            });
        }
        return true;
    }

    private boolean executeFtpCommandWithBoolResult(String actionBeingPerformed, Logger log, FTPClient ftp, BoolCommandExecutor c) {
        try {
            return this.executeFtpCommandWithReply(actionBeingPerformed, log, ftp, c);
        }
        catch (Exception e) {
            log.error(actionBeingPerformed + " FAILED", (Throwable)e);
            return false;
        }
    }

    private <T extends Exception> boolean executeFtpCommandWithReply(String actionBeingPerformed, Logger log, FTPClient ftp, BoolCommandExecutor c) throws T {
        boolean success;
        log.trace(actionBeingPerformed + " ...");
        try {
            success = c.exec();
        }
        catch (IOException e) {
            log.error(actionBeingPerformed + " FAILED", (Throwable)e);
            success = false;
        }
        int reply = ftp.getReplyCode();
        if (!success) {
            log.error(actionBeingPerformed + " FAILED (" + reply + ")");
        } else {
            log.trace(actionBeingPerformed + " SUCCESS (" + reply + ")");
        }
        return success;
    }

    private InputStream getMarkableStream(InputStream stream) {
        InputStream markable = stream.markSupported() ? stream : new BufferedInputStream(stream);
        return markable;
    }

    static class LogOutputStream
    extends OutputStream {
        final Logger log;
        private final String lineSeparator;
        private final StringBuffer buffer;

        public LogOutputStream(Logger logger) {
            this.log = logger;
            this.lineSeparator = System.getProperty("line.separator");
            this.buffer = new StringBuffer();
        }

        @Override
        public void write(int b) throws IOException {
            boolean endsWithNewLine;
            char ch = (char)b;
            this.buffer.append(ch);
            boolean bl = endsWithNewLine = this.endsWithLineSeparator() || 10 == b || 13 == b;
            if (endsWithNewLine) {
                this.log.trace(this.buffer.toString().trim());
                this.buffer.setLength(0);
            }
        }

        private boolean endsWithLineSeparator() {
            int bufLen = this.buffer.length();
            int newLineLen = this.lineSeparator.length();
            if (newLineLen <= bufLen) {
                for (int i = 0; i < newLineLen; ++i) {
                    char cSep;
                    char cBuff = this.buffer.charAt(bufLen - newLineLen + i);
                    if (cBuff == (cSep = this.lineSeparator.charAt(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static interface BoolCommandExecutor {
        public boolean exec() throws IOException;
    }
}

