/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.support.upload.impl.ftp;

import com.vmware.ph.common.net.HttpConnectionConfig;
import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.support.upload.impl.ftp.FtpUploader;
import com.vmware.ph.upload.AbstractUploader;
import com.vmware.ph.upload.TransferProgressListener;
import java.io.File;
import java.io.InputStream;

public class UploaderImpl
extends AbstractUploader {
    private final HttpConnectionConfig connectionConfig;

    public UploaderImpl(String protocol, String host, int port, String username, String password, long chunkSize, ProxySettings ps, TransferProgressListener progressListener, int maxResumesBeforeFailure, HttpConnectionConfig connectionConfig) {
        super(protocol, host, port, username, password, chunkSize, ps, "", progressListener, maxResumesBeforeFailure);
        this.connectionConfig = connectionConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void uploadOverride(InputStream streamToUpload, File destFile, boolean shouldCreateFolder, ProxySettings ps) throws Exception {
        try (FtpUploader ftpUploader = null;){
            ftpUploader = this.getFtpUploader();
            ftpUploader.connectLoginAndInit();
            String unixPathName = this.toUnixPathIfNeeded(destFile.getPath());
            ftpUploader.uploadFile(streamToUpload, unixPathName, this.uploadState.getUploadProgress(), this.uploadState);
        }
    }

    FtpUploader getFtpUploader() {
        return new FtpUploader(this.protocol, this.host, this.port, this.username, this.password, this.proxySettings, this.connectionConfig);
    }
}

