/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.support.upload.impl.http.js7;

import com.vmware.ph.common.net.HttpConnectionConfig;
import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.exceptions.Exceptions;
import com.vmware.ph.support.upload.impl.http.js7.JscapeWebSession;
import com.vmware.ph.support.upload.impl.http.js7.Session;
import com.vmware.ph.upload.TransferProgressListener;
import com.vmware.ph.upload.exception.UploadAuthenticationException;
import com.vmware.ph.upload.exception.UploadFailedException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUploader {
    private static final Logger log = LoggerFactory.getLogger(HttpUploader.class);
    private final String host;
    private final String username;
    private final String password;
    private final ProxySettings proxySettings;
    private final String domain;
    private final HttpConnectionConfig connectionConfig;

    public HttpUploader(String host, int port, String username, String domain, String password, ProxySettings proxySettings, HttpConnectionConfig connectionConfig) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.domain = domain;
        this.connectionConfig = connectionConfig;
        this.proxySettings = proxySettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void upload(InputStream streamToUpload, String remoteFolder, String remoteFileName, TransferProgressListener iTransferProgressListener) throws IOException, UploadAuthenticationException, UploadFailedException {
        Exceptions.traceEnteringWithInput(log, "remoteFolder=" + remoteFolder + ", remoteName=" + remoteFileName);
        InputStream markableStreamToUpload = this.getMarkableStream(streamToUpload);
        Session session = this.createFtpsiteWebSession();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            session.mkdir(remoteFolder);
            session.cwd(remoteFolder);
            if (null != iTransferProgressListener) {
                iTransferProgressListener.notifyForTransferProgressUpdate(0L);
            }
            Callable<Void> callable = this.makeUploadTask(session, markableStreamToUpload, remoteFileName, iTransferProgressListener);
            Future<Void> task = executor.submit(callable);
            while (!task.isDone()) {
                try {
                    task.get(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    String msg = "Upload thread failed.";
                    if (e.getCause() instanceof IOException) {
                        log.error(msg, (Throwable)e);
                        throw (IOException)e.getCause();
                    }
                    if (e.getCause() instanceof TimeoutException) {
                        msg = "Still waiting for upload to complete...";
                    } else if (e.getCause() instanceof InterruptedException) {
                        msg = "Waiting for upload interrupted.";
                    }
                    log.error(msg, (Throwable)e);
                    throw new IOException(msg, e);
                    return;
                }
            }
        }
        finally {
            Exceptions.traceExiting(log);
            IOUtils.closeQuietly(session);
            executor.shutdownNow();
        }
    }

    Session createFtpsiteWebSession() throws UploadAuthenticationException {
        return new JscapeWebSession(this.host, this.username, this.password, this.domain, true, this.proxySettings, this.connectionConfig);
    }

    private Callable<Void> makeUploadTask(final Session session, final InputStream streamToUpload, final String remoteFileName, final TransferProgressListener iTransferProgressListener) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                session.upload(streamToUpload, remoteFileName, iTransferProgressListener);
                return null;
            }
        };
    }

    private InputStream getMarkableStream(InputStream stream) {
        InputStream markable = stream.markSupported() ? stream : new BufferedInputStream(stream);
        return markable;
    }
}

