/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.support.upload.impl.http.js7;

import com.vmware.ph.common.net.HttpConnectionConfig;
import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.support.upload.impl.http.js7.Session;
import com.vmware.ph.upload.HttpClientSetup;
import com.vmware.ph.upload.TransferProgressListener;
import com.vmware.ph.upload.exception.HttpUploadFailedException;
import com.vmware.ph.upload.exception.UploadAuthenticationException;
import com.vmware.ph.upload.exception.UploadFailedException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JscapeWebSession
implements Session {
    static final int MAX_RESPONSE_LENGTH = 2048;
    private static final Logger log = LoggerFactory.getLogger(JscapeWebSession.class);
    private final CloseableHttpClient httpclient;
    private final String hostname;
    private final boolean useHttps;

    static CloseableHttpClient createClient(String hostname, String username, String password, String domain, ProxySettings ps, HttpConnectionConfig connectionConfig) {
        AuthScope authScope = new AuthScope(hostname, -1, domain);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(authScope, credentials);
        HttpClientBuilder httpClientBuilder = HttpClientSetup.createHttpClientBuilder(connectionConfig, ps, credentialsProvider);
        return httpClientBuilder.build();
    }

    public JscapeWebSession(String hostname, String username, String password, String domain, boolean useHttps, ProxySettings proxySettings, HttpConnectionConfig connectionConfig) throws UploadAuthenticationException {
        this(JscapeWebSession.createClient(hostname, username, password, domain, proxySettings, connectionConfig), hostname, username, password, domain, useHttps);
    }

    JscapeWebSession(CloseableHttpClient httpclient, String hostname, String username, String password, String domain, boolean useHttps) throws UploadAuthenticationException {
        this.hostname = hostname;
        this.useHttps = useHttps;
        this.httpclient = httpclient;
        try {
            this.loginGet(username, password, domain);
        }
        catch (IOException e) {
            String msg = "Authentication failed for user " + username;
            UploadAuthenticationException ftpAuthenticationException = new UploadAuthenticationException(msg, e);
            log.error(msg + ". Throwing new " + ftpAuthenticationException, (Throwable)e);
            throw ftpAuthenticationException;
        }
    }

    @Override
    public void mkdir(String remotePath) throws IOException {
        log.info("Creating directory " + remotePath);
        this.doDirAction(remotePath, "mkdir");
    }

    @Override
    public void cwd(String remotePath) throws IOException {
        log.info("Changing directory to " + remotePath);
        this.doDirAction(remotePath, "cwd");
    }

    @Override
    public void upload(InputStream streamToUpload, String remoteFileName, TransferProgressListener iTransferProgressListener) throws IOException, UploadFailedException {
        log.info("Uploading on {} as {}.", (Object)this.hostname, (Object)remoteFileName);
        HttpPost httppost = new HttpPost(this.toURI("action/upload"));
        ProgressReportingInputStreamBody bin = new ProgressReportingInputStreamBody(streamToUpload, remoteFileName, iTransferProgressListener);
        assert (bin.getMimeType().equals("application/octet-stream"));
        MultipartEntityBuilder multiPartBuilder = MultipartEntityBuilder.create();
        multiPartBuilder.addPart("filename0", bin);
        httppost.setEntity(multiPartBuilder.build());
        CloseableHttpResponse response = this.httpclient.execute(httppost);
        this.logResponse(response);
        String responseString = EntityUtils.toString(response.getEntity());
        long length = responseString.length();
        if (length > 2048L) {
            responseString = responseString.substring(0, 2048);
        }
        log.info("First 2KB (out of total {} B) of response: {}", (Object)length, (Object)responseString);
        EntityUtils.consumeQuietly(response.getEntity());
        try {
            this.checkResponse(response);
        }
        catch (IOException e) {
            String msg = "Could not upload file " + remoteFileName;
            HttpUploadFailedException httpUploadFailedException = new HttpUploadFailedException(msg, e);
            log.error(msg + ". Throwing new " + httpUploadFailedException, (Throwable)e);
            throw httpUploadFailedException;
        }
    }

    @Override
    public void close() {
        try {
            this.httpclient.close();
        }
        catch (IOException e) {
            log.debug("Could not close httpclient");
        }
    }

    private void doDirAction(String remotePath, String dirActionName) throws IOException {
        ArrayList<NameValuePair> data = new ArrayList<NameValuePair>();
        data.add(this.toPair("filename", remotePath));
        data.add(this.toPair("oldname", ""));
        data.add(this.toPair("sortedColumnIndex", "null"));
        data.add(this.toPair("sortedAscending", "true"));
        data.add(this.toPair("action", dirActionName));
        this.postFormData(data, "action/");
    }

    private void postFormData(List<NameValuePair> data, String path) throws IOException {
        URI uri = this.toURI(path);
        log.info("Preparing POST request to " + uri);
        HttpPost postReq = new HttpPost(uri);
        postReq.addHeader("Referer", uri.toString());
        postReq.addHeader("Cache-Control", "no-cache");
        try {
            postReq.setEntity(new UrlEncodedFormEntity(data));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected support error.", e);
        }
        postReq.addHeader("Content-Type", "application/x-www-form-urlencoded");
        log.debug("Request headers: " + Arrays.asList(postReq.getAllHeaders()));
        CloseableHttpResponse response = this.httpclient.execute(postReq);
        this.logResponse(response);
        this.checkResponse(response);
    }

    private void checkResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine() == null) {
            throw new IOException("No status line.");
        }
        EntityUtils.consumeQuietly(response.getEntity());
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new IOException("Unexpected response code" + statusCode + ".");
        }
    }

    private void loginGet(String username, String password, String domain) throws IOException {
        String path = String.format("action/login?domain=%s&username=%s&password=%s&continue=/action/cwd?filename=/", domain, username, password);
        HttpGet getMethod = new HttpGet(this.toURI(path));
        this.doGetIgnoreResult(getMethod);
    }

    private void doGetIgnoreResult(HttpGet rootReq) throws IOException, ClientProtocolException {
        CloseableHttpResponse resp = this.httpclient.execute(rootReq);
        this.logResponse(resp);
        EntityUtils.consumeQuietly(resp.getEntity());
    }

    private void logResponse(HttpResponse response) {
        log.debug("Got response status line: " + response.getStatusLine());
        log.debug("Response entity: " + (response.getEntity() != null ? "present" : "missing"));
        log.debug("Response headers: " + Arrays.asList(response.getAllHeaders()));
    }

    private NameValuePair toPair(String name, String value) {
        return new BasicNameValuePair(name, value);
    }

    private URI toURI(String path) {
        return URI.create(String.format("http%s://%s/%s", this.useHttps ? "s" : "", this.hostname, path));
    }

    static class ProgressReportingInputStreamBody
    extends InputStreamBody {
        private static final Logger log = LoggerFactory.getLogger(ProgressReportingInputStreamBody.class);
        private volatile long bytesSent = 0L;
        private final long startTime = System.currentTimeMillis();
        private long lastLoggedTs = 0L;
        private long lastLoggedCount = 0L;
        private final TransferProgressListener iTransferProgressListener;

        public ProgressReportingInputStreamBody(InputStream streamToUpload, String remoteFileName, TransferProgressListener iTransferProgressListener) {
            super(streamToUpload, remoteFileName);
            this.iTransferProgressListener = iTransferProgressListener;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            FilterOutputStream decorated = new FilterOutputStream(out){

                @Override
                public void write(int b) throws IOException {
                    super.write(b);
                    ++ProgressReportingInputStreamBody.this.bytesSent;
                    ProgressReportingInputStreamBody.this.onNewBytesSent();
                }
            };
            super.writeTo(decorated);
        }

        private void onNewBytesSent() {
            long currentTime;
            long timeDiff;
            if (null != this.iTransferProgressListener) {
                this.iTransferProgressListener.notifyForTransferProgressUpdate(this.bytesSent);
            }
            if ((timeDiff = (currentTime = System.currentTimeMillis()) - this.lastLoggedTs) < 1000L || currentTime - this.startTime < 1000L) {
                return;
            }
            double bytesDiff = this.bytesSent - this.lastLoggedCount;
            double KBperSec = bytesDiff / 1024.0 / (double)(timeDiff / 1000L);
            double KBperSecAvg = this.bytesSent / 1024L / ((currentTime - this.startTime) / 1000L);
            log.debug(String.format("avg %.2f KB/sec (current %.2f KB/sec)", KBperSecAvg, KBperSec));
            this.lastLoggedTs = currentTime;
            this.lastLoggedCount = this.bytesSent;
        }
    }
}

